/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.profile.actions;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.FEUser;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.util.MD5;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.profile.actions.AbstractProfileAction;

public class ChangePasswordAction
extends AbstractProfileAction {
    private String currentPassword;
    private String newPassword;
    private String confirmNewPassword;
    private boolean passwordChanged;

    public String doDefault() throws Exception {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FEUser feu = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
                this.configChangePasswordEnabled(feu);
                return "success";
            }
            catch (DbException e2) {
                this.addActionError("Database error updating password");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String execute() {
        UserLogin user = this.getUserLogin();
        if (user != null) {
            try {
                FEUser feu = AppConfig.getsConfig().getUserManager().getUser(user.getUsername());
                this.configChangePasswordEnabled(feu);
                if (StringUtil.nullOrEmpty(this.currentPassword)) {
                    this.addFieldError("currentPassword", "Please enter your current password");
                    return "input";
                }
                if (!MD5.hash(this.currentPassword).equalsIgnoreCase(feu.getPasswordHash())) {
                    this.addFieldError("currentPassword", "Incorrect password");
                    return "input";
                }
                if (StringUtil.nullOrEmpty(this.newPassword)) {
                    this.addFieldError("newPassword", "Please enter a new password");
                    return "input";
                }
                if (StringUtil.nullOrEmpty(this.confirmNewPassword)) {
                    this.addFieldError("confirmNewPassword", "Please confirm your new password by re-entering it");
                    return "input";
                }
                if (!this.newPassword.equals(this.confirmNewPassword)) {
                    this.addFieldError("confirmNewPassword", "The confirmed new password doesn't match new password");
                    return "input";
                }
                AppConfig.getsConfig().getUserManager().changePassword(feu, this.newPassword);
                this.passwordChanged = true;
                return "success";
            }
            catch (DbException e2) {
                this.addActionError("Database error updating password");
            }
        } else {
            this.addActionError("User not found");
        }
        return "error";
    }

    public String getCurrentPassword() {
        return this.currentPassword;
    }

    public void setCurrentPassword(String currentPassword) {
        this.currentPassword = currentPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String newPassword) {
        this.newPassword = newPassword;
    }

    public String getConfirmNewPassword() {
        return this.confirmNewPassword;
    }

    public void setConfirmNewPassword(String confirmNewPassword) {
        this.confirmNewPassword = confirmNewPassword;
    }

    public boolean isPasswordChanged() {
        return this.passwordChanged;
    }

    public void setPasswordChanged(boolean passwordChanged) {
        this.passwordChanged = passwordChanged;
    }
}

