/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.StringUtil;
import com.cenqua.fisheye.web.admin.actions.user.UserAddAction;
import com.cenqua.fisheye.web.security.CaptchaManager;
import com.octo.captcha.service.CaptchaServiceException;

public class SignupAction
extends UserAddAction {
    private String captchaid;
    private String captchaResponse;

    public String getCaptchaid() {
        return this.captchaid;
    }

    public void setCaptchaid(String captchaid) {
        this.captchaid = captchaid;
    }

    public void setCaptchaResponse(String captchaResponse) {
        this.captchaResponse = captchaResponse;
    }

    public String doDefault() throws Exception {
        this.captchaid = CaptchaManager.getInstance().makeCaptchaId();
        return super.doDefault();
    }

    public String execute() {
        return super.execute();
    }

    public void validate() {
        boolean signupEnabled = AppConfig.getsConfig().getConfig().getSecurity().getBuiltIn().getSignup().getEnabled();
        if (!signupEnabled) {
            this.addActionError("Signup disabled.");
            return;
        }
        this.user.setAuthType(1);
        super.validate();
        if (this.hasErrors()) {
            return;
        }
        if (StringUtil.nullOrEmpty(this.captchaid)) {
            this.addActionError("Internal problem with CAPTCHA.");
            return;
        }
        if (StringUtil.nullOrEmpty(this.captchaResponse)) {
            this.addFieldError("captchaResponse", "Please enter the word in the image.");
            return;
        }
        Boolean valid = null;
        try {
            System.out.println("validateResponseForID " + this.captchaid + " " + this.captchaResponse);
            valid = CaptchaManager.getInstance().validateResponseForID(this.captchaid, this.captchaResponse);
        }
        catch (CaptchaServiceException e2) {
            Logs.APP_LOG.info((Object)"problem validating captcha", (Throwable)e2);
            this.addActionError("Internal problem with CAPTCHA.");
        }
        if (valid == null || !valid.booleanValue()) {
            this.addFieldError("captchaResponse", "Incorrect, try again.");
        }
    }
}

