/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.security;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.user.LoginCookie;
import com.cenqua.fisheye.user.LoginCookieToken;
import com.cenqua.fisheye.user.UserLogin;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.web.security.BasicRfc2617Authenticator;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;

@Component(value="userDetector")
public class UserDetector {
    private static final String ALREADY_PROCESSED = UserDetector.class.getName() + ".ALREADYPROCESSED";

    public UserLogin process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException, LicensePolicyException {
        boolean alreadyProcessed;
        boolean bl = alreadyProcessed = request.getAttribute(ALREADY_PROCESSED) != null;
        if (!alreadyProcessed) {
            request.setAttribute(ALREADY_PROCESSED, (Object)"yes");
        }
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = alreadyProcessed ? um.getCurrentUser(request) : um.validateCurrentUser(request, response);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            return user;
        }
        if (alreadyProcessed) {
            return null;
        }
        user = UserDetector.getUser(request, response);
        return user;
    }

    private static UserLogin getUser(HttpServletRequest request, HttpServletResponse response) throws LicensePolicyException {
        UserManager um = AppConfig.getsConfig().getUserManager();
        UserLogin user = UserDetector.tryTrustedApplicationsLogin(request, response, um);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            return user;
        }
        user = UserDetector.tryRequestDelegatedLogin(request, response, um);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            user = um.validateCurrentUser(request, response);
            return user;
        }
        user = UserDetector.tryRememberMeLogin(request, response, um);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            user = um.validateCurrentUser(request, response);
            return user;
        }
        user = UserDetector.tryPreCookedUrlLogin(request, response, um);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            user = um.validateCurrentUser(request, response);
            return user;
        }
        user = UserDetector.tryBasicAuthentication(request, response, um);
        if (user != null) {
            request.setAttribute("feuser", (Object)user);
            return um.validateCurrentUser(request, response);
        }
        return null;
    }

    private static UserLogin tryBasicAuthentication(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        BasicRfc2617Authenticator authenticator = new BasicRfc2617Authenticator();
        if (authenticator.containsUsernamePassword(request)) {
            try {
                return um.login(request, response, authenticator.getUsername(), authenticator.getPassword(), false);
            }
            catch (Exception e2) {
                return null;
            }
        }
        return null;
    }

    private static UserLogin tryTrustedApplicationsLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        HttpSession session = request.getSession(false);
        return (UserLogin)(session == null ? null : session.getAttribute("seraph_defaultauthenticator_user"));
    }

    private static UserLogin tryRequestDelegatedLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) throws LicensePolicyException {
        try {
            return um.tryRequestDelegatedLogin(request, response);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem logging user delegated ", (Throwable)e2);
            return null;
        }
    }

    private static UserLogin tryPreCookedUrlLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        String tok = request.getParameter("FEAUTH");
        if (tok == null) {
            return null;
        }
        return UserDetector.tryTokenLogin(tok, request, response, um);
    }

    private static UserLogin tryRememberMeLogin(HttpServletRequest request, HttpServletResponse response, UserManager um) {
        Cookie c2 = UserDetector.getPersistentCookie(request);
        if (c2 == null || c2.getValue() == null) {
            return null;
        }
        UserLogin user = UserDetector.tryTokenLogin(c2.getValue(), request, response, um);
        if (user == null) {
            c2.setMaxAge(0);
            response.addCookie(c2);
        }
        return user;
    }

    private static UserLogin tryTokenLogin(String value, HttpServletRequest request, HttpServletResponse response, UserManager um) {
        LoginCookieToken given = LoginCookie.decode(value);
        if (given == null) {
            return null;
        }
        try {
            return um.login(request, response, given);
        }
        catch (DbException e2) {
            Logs.APP_LOG.warn((Object)"problem logging in remembered user via a cookie", (Throwable)e2);
            return null;
        }
    }

    private static Cookie getPersistentCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i2 = 0; i2 < cookies.length; ++i2) {
            Cookie c2 = cookies[i2];
            if (!"remember".equals(c2.getName())) continue;
            return c2;
        }
        return null;
    }
}

