/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.tarball;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionContentsUtil;
import com.cenqua.fisheye.cvsrep.RCSParser;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.util.Disposer;
import com.cenqua.fisheye.web.tarball.TarballAction;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;

public class Tarballer
extends TarballAction.AbstractBaller {
    private final File mTmpFile = File.createTempFile("fisheyetar", null);
    private TarOutputStream mOut;

    public Tarballer(RevisionCache CRep, Path prefix) throws IOException {
        super(CRep, prefix);
        Disposer.threadInstance().deleteFileOnDispose(this.mTmpFile);
    }

    public void start(OutputStream os) {
        this.mOut = new TarOutputStream(os);
        this.mOut.setLongFileMode(2);
    }

    public void done() throws IOException {
        this.mOut.finish();
        this.mOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeFile(TarballAction.BallEntry entry, String vpath) throws IOException, RCSParser.ParseException, DbException {
        if (entry.binary) {
            RevisionContentsUtil.getBinaryRevision(this.mCRep, entry.key, this.mTmpFile);
        } else {
            BufferedOutputStream out = null;
            try {
                out = new BufferedOutputStream(new FileOutputStream(this.mTmpFile));
                this.mCRep.getTextRevision(entry.key, out, null, entry.symrev);
            }
            catch (Throwable throwable) {
                IOHelper.close(out);
                throw throwable;
            }
            IOHelper.close(out);
        }
        TarEntry te = new TarEntry(vpath);
        te.setModTime(entry.date);
        te.setSize(this.mTmpFile.length());
        this.mOut.putNextEntry(te);
        IOHelper.copyStream(this.mTmpFile, (OutputStream)this.mOut);
        this.mOut.closeEntry();
    }
}

