/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.web.util;

import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.web.themer.BriefCheckinCommentTag;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class CheckinCommentFormatter
extends BriefCheckinCommentTag {
    private Writer out;
    private RepositoryConfig cfg;

    private CheckinCommentFormatter(RepositoryConfig cfg, Writer out) {
        this.cfg = cfg;
        this.out = out;
    }

    protected RepositoryConfig getRepositoryConfig() {
        return this.cfg;
    }

    protected Writer getOut() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(RepositoryConfig cfg, String comment) throws IOException {
        boolean closeSession = !CheckinCommentFormatter.isSession();
        try {
            StringWriter str = new StringWriter();
            CheckinCommentFormatter formatter = new CheckinCommentFormatter(cfg, str);
            formatter.setComment(comment);
            formatter.doTag();
            String string = str.toString();
            return string;
        }
        finally {
            if (closeSession) {
                HibernateUtil.closeSession();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String format(RepositoryConfig cfg, String comment, int maxChars, boolean applyFormatting, boolean escapeHTML) throws IOException {
        boolean closeSession = !CheckinCommentFormatter.isSession();
        try {
            StringWriter str = new StringWriter();
            CheckinCommentFormatter formatter = new CheckinCommentFormatter(cfg, str);
            formatter.setAutoCommentFormatting(applyFormatting);
            formatter.setEscapeHTML(escapeHTML);
            formatter.setComment(comment);
            formatter.setEol("");
            formatter.setMaxCharacters(maxChars);
            formatter.setEllipses("...");
            formatter.doTag();
            String string = str.toString();
            return string;
        }
        finally {
            if (closeSession) {
                HibernateUtil.closeSession();
            }
        }
    }

    private static boolean isSession() {
        return AppConfig.isCrucible() && HibernateUtil.isCurrentSession();
    }
}

