/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class SVNAdminCreateCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        String fsType = (String)this.getCommandLine().getArgumentValue(SVNArgument.FS_TYPE);
        if (fsType != null && !"fsfs".equals(fsType)) {
            SVNCommand.println(out, "Unsupported repository type '" + fsType + "'");
            System.exit(1);
        }
        boolean isOldFormat = this.getCommandLine().hasArgument(SVNArgument.PRE_14_COMPATIBLE);
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(out, "jsvnadmin: Repository argument required");
            System.exit(1);
        }
        String absolutePath = this.getCommandLine().getPathAt(0);
        SVNRepositoryFactory.createLocalRepository((File)new File(absolutePath), null, (boolean)false, (boolean)false, (boolean)isOldFormat);
    }
}

