/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;

public class SVNAdminDumpCommand
extends SVNCommand
implements ISVNAdminEventHandler {
    private boolean myIsQuiet;
    private PrintStream myOut;

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(out, "jsvnadmin: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        SVNRevision[] revRange = this.getStartEndRevisions();
        SVNRevision rStart = revRange[0];
        SVNRevision rEnd = revRange[1];
        boolean isIncremental = this.getCommandLine().hasArgument(SVNArgument.INCREMENTAL);
        boolean useDeltas = this.getCommandLine().hasArgument(SVNArgument.DELTAS);
        this.myIsQuiet = this.getCommandLine().hasArgument(SVNArgument.QUIET);
        this.myOut = err;
        SVNAdminClient adminClient = this.getClientManager().getAdminClient();
        adminClient.setEventHandler((ISVNEventHandler)this);
        adminClient.doDump(reposRoot, (OutputStream)out, rStart, rEnd, isIncremental, useDeltas);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (!this.myIsQuiet && event != null && event.getAction() == SVNAdminEventAction.REVISION_DUMPED) {
            this.myOut.println(event.getMessage());
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

