/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminClient;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;

public class SVNAdminLoadCommand
extends SVNCommand
implements ISVNAdminEventHandler {
    private boolean myIsQuiet;
    private PrintStream myOut;
    private boolean myIsNodeOpened;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        this.run(System.in, out, err);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(out, "jsvnadmin: Repository argument required");
            System.exit(1);
        }
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        boolean ignoreUUID = this.getCommandLine().hasArgument(SVNArgument.IGNORE_UUID);
        boolean forceUUID = this.getCommandLine().hasArgument(SVNArgument.FORCE_UUID);
        SVNUUIDAction uuidAction = null;
        uuidAction = !ignoreUUID && !forceUUID ? SVNUUIDAction.DEFAULT : (ignoreUUID ? SVNUUIDAction.IGNORE_UUID : SVNUUIDAction.FORCE_UUID);
        boolean usePreCommitHook = this.getCommandLine().hasArgument(SVNArgument.USE_PRECOMMIT_HOOK);
        boolean usePostCommitHook = this.getCommandLine().hasArgument(SVNArgument.USE_POSTCOMMIT_HOOK);
        String parentDir = (String)this.getCommandLine().getArgumentValue(SVNArgument.PARENT_DIR);
        this.myIsQuiet = this.getCommandLine().hasArgument(SVNArgument.QUIET);
        this.myOut = out;
        SVNAdminClient adminClient = this.getClientManager().getAdminClient();
        adminClient.setEventHandler((ISVNEventHandler)this);
        adminClient.doLoad(reposRoot, in, usePreCommitHook, usePostCommitHook, uuidAction, parentDir);
    }

    public void handleAdminEvent(SVNAdminEvent event, double progress) throws SVNException {
        if (!this.myIsQuiet && event != null) {
            if (event.getAction() != SVNAdminEventAction.REVISION_LOAD && this.myIsNodeOpened) {
                this.myOut.println(" done.");
                this.myIsNodeOpened = false;
            }
            if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
                this.myOut.println();
            }
            this.myOut.println(event.getMessage());
            if (event.getAction() == SVNAdminEventAction.REVISION_LOADED) {
                this.myOut.println();
            }
            this.myIsNodeOpened = event.getAction() != SVNAdminEventAction.REVISION_LOAD;
        }
    }

    public void handleEvent(SVNEvent event, double progress) throws SVNException {
    }

    public void checkCancelled() throws SVNCancelException {
    }
}

