/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNCatCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        String message;
        SVNRevision pegRevision;
        int index;
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        SVNRevision revision = SVNRevision.BASE;
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        for (index = 0; index < this.getCommandLine().getPathCount(); ++index) {
            String absolutePath = this.getCommandLine().getPathAt(index);
            pegRevision = this.getCommandLine().getPathPegRevision(index);
            try {
                wcClient.doGetFileContents(new File(absolutePath), pegRevision, revision, true, (OutputStream)out);
            }
            catch (SVNException e) {
                message = e.getMessage();
                err.println(message);
            }
            out.flush();
        }
        revision = SVNRevision.HEAD;
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        for (index = 0; index < this.getCommandLine().getURLCount(); ++index) {
            String url = this.getCommandLine().getURL(index);
            pegRevision = this.getCommandLine().getPegRevision(index);
            try {
                wcClient.doGetFileContents(SVNURL.parseURIEncoded((String)url), pegRevision, revision, true, (OutputStream)out);
            }
            catch (SVNException e) {
                message = e.getMessage();
                err.println(message);
            }
            out.flush();
        }
    }
}

