/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNTreeHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminPath;
import org.tmatesoft.svn.core.wc.admin.SVNLookClient;

public class SVNLookTreeCommand
extends SVNCommand
implements ISVNTreeHandler {
    private PrintStream myOut;
    private boolean myIsIncludeIDs;
    private boolean myIsFullPaths;

    public void run(PrintStream out, PrintStream err) throws SVNException {
        if (!this.getCommandLine().hasPaths()) {
            SVNCommand.println(err, "jsvnlook: Repository argument required");
            System.exit(1);
        }
        this.myOut = out;
        this.myIsIncludeIDs = this.getCommandLine().hasArgument(SVNArgument.SHOW_IDS);
        this.myIsFullPaths = this.getCommandLine().hasArgument(SVNArgument.FULL_PATHS);
        File reposRoot = new File(this.getCommandLine().getPathAt(0));
        String path = this.getCommandLine().getPathCount() < 2 ? null : SVNPathUtil.canonicalizeAbsPath((String)this.getCommandLine().getPathAt(1));
        SVNRevision revision = SVNRevision.HEAD;
        SVNLookClient lookClient = this.getClientManager().getLookClient();
        if (this.getCommandLine().hasArgument(SVNArgument.TRANSACTION)) {
            String transactionName = (String)this.getCommandLine().getArgumentValue(SVNArgument.TRANSACTION);
            lookClient.doGetTree(reposRoot, path, transactionName, this.myIsIncludeIDs, (ISVNTreeHandler)this);
            return;
        }
        if (this.getCommandLine().hasArgument(SVNArgument.REVISION)) {
            revision = SVNRevision.parse((String)((String)this.getCommandLine().getArgumentValue(SVNArgument.REVISION)));
        }
        lookClient.doGetTree(reposRoot, path, revision, this.myIsIncludeIDs, (ISVNTreeHandler)this);
    }

    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void handlePath(SVNAdminPath adminPath) throws SVNException {
        if (adminPath != null) {
            String indentation = null;
            if (!this.myIsFullPaths) {
                indentation = "";
                for (int i = 0; i < adminPath.getTreeDepth(); ++i) {
                    indentation = indentation + " ";
                }
            }
            String path = adminPath.getPath();
            if (this.myIsFullPaths) {
                String string = path = path.startsWith("/") && !"/".equals(path) ? path.substring(1) : path;
                if (adminPath.isDir() && !"/".equals(path) && !path.endsWith("/")) {
                    path = path + "/";
                }
                SVNCommand.print(this.myOut, path);
            } else {
                String string = path = !"/".equals(path) ? SVNPathUtil.tail((String)path) : path;
                if (adminPath.isDir() && !"/".equals(path) && !path.endsWith("/")) {
                    path = path + "/";
                }
                SVNCommand.print(this.myOut, indentation + path);
            }
            if (this.myIsIncludeIDs) {
                SVNCommand.print(this.myOut, " <" + (adminPath.getNodeID() != null ? adminPath.getNodeID() : "unknown") + ">");
            }
            SVNCommand.println(this.myOut, "");
        }
    }
}

