/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.command;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.tmatesoft.svn.cli.SVNArgument;
import org.tmatesoft.svn.cli.SVNCommand;
import org.tmatesoft.svn.cli.command.SVNCommandEventProcessor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class SVNUnlockCommand
extends SVNCommand {
    public void run(InputStream in, PrintStream out, PrintStream err) throws SVNException {
        this.run(out, err);
    }

    public void run(PrintStream out, PrintStream err) throws SVNException {
        boolean force = this.getCommandLine().hasArgument(SVNArgument.FORCE);
        ArrayList<Object> files = new ArrayList<Object>();
        for (int i = 0; i < this.getCommandLine().getPathCount(); ++i) {
            files.add(new File(this.getCommandLine().getPathAt(i)));
        }
        File[] filesArray = files.toArray(new File[files.size()]);
        this.getClientManager().setEventHandler((ISVNEventHandler)new SVNCommandEventProcessor(out, err, false));
        SVNWCClient wcClient = this.getClientManager().getWCClient();
        if (filesArray.length > 0) {
            wcClient.doUnlock(filesArray, force);
        }
        files.clear();
        for (int i = 0; i < this.getCommandLine().getURLCount(); ++i) {
            files.add(this.getCommandLine().getURL(i));
        }
        String[] urls = files.toArray(new String[files.size()]);
        SVNURL[] svnURLs = new SVNURL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            svnURLs[i] = SVNURL.parseURIEncoded((String)urls[i]);
        }
        if (urls.length > 0) {
            wcClient.doUnlock(svnURLs, force);
        }
    }
}

