/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;

public class FishEyeClassLoader
extends URLClassLoader {
    private final List libraryPaths = new LinkedList();

    public FishEyeClassLoader(ClassLoader parent) {
        this(new URL[0], parent);
    }

    public FishEyeClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addJar(File file) throws MalformedURLException {
        this.addURL(file.toURL());
    }

    public void addJarsFromDir(File libdir) throws MalformedURLException {
        File[] files = libdir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!file.getName().endsWith(".jar")) continue;
            this.addJar(file);
        }
    }

    public void addLibraryDir(File dir) {
        this.libraryPaths.add(dir);
    }

    public void addLibraryPath(String path) {
        String part;
        int end;
        int start = 0;
        while ((end = path.indexOf(File.pathSeparator, start)) != -1) {
            part = path.substring(start, end);
            this.addLibraryDir(new File(part));
            start = end + File.pathSeparator.length();
        }
        if (start < path.length()) {
            part = path.substring(start);
            this.addLibraryDir(new File(part));
        }
    }

    protected String findLibrary(String name) {
        String libname = System.mapLibraryName(name);
        for (File dir : this.libraryPaths) {
            File lib = new File(dir, libname);
            if (!lib.exists()) continue;
            String libpath = lib.getAbsolutePath();
            return libpath;
        }
        return super.findLibrary(name);
    }
}

