import xmlrpclib

FISHEYE_HOST="http://localhost:8080/"

server = xmlrpclib.ServerProxy(FISHEYE_HOST + "api/xmlrpc")

print server

auth = ""
#auth = server.login("username", "password")
print "Using auth:", auth

reps = server.listRepositories(auth)

print "found %i repositories" %(len(reps))
print reps

rep = reps[0]
path = "/"
rc = server.listChangesets(auth, rep, path)
print "recent changes:"
print "maxReturn=", rc['maxReturn'], "returned=", len(rc['csids'])

csid = rc['csids'][0]

cs = server.getChangeset(auth, rep, csid)
print "changeset", cs['csid']
print "author %s, date %s, branch %s" % (cs['author'], cs['date'].value, cs['branch'])
print cs['log']
lastFile = None
for ri in cs['revisions']:
    print "- %s %s" % (ri['path'], ri['rev'])
    lastFile = ri['path']

print "looking at", lastFile
hist = server.listPathHistory(auth, rep, lastFile)
for r in hist['revisions']:
    print r['rev'], r['author'], r['date']
    if r.has_key('csid'): print r['csid']
    if r.has_key('ancestor'): print r['ancestor']
    print r['log']

    r2 = server.getRevision(auth, rep, lastFile, r['rev'])
    assert r2['rev'] == r['rev']


print "trying logout:", server.logout(auth)
print "listing reps after logout:", server.listRepositories(auth)
