/*
    This defines review information and methods we need to access data of a review
*/
// classes or structs
var comment = new Array(); //a list of commentClass obs indexed by comment id
var groups = new Array(); //a list of changeClass objects

/*Holds information about a particular group including
 * a list of lines that have comments on them (see lineClass)
 * the review this change relates to
 * the to and fromrevisions in the change.
 */
function groupClass(reviewid, fileName, fromRev, toRev){
    this.state = 1;
    this.reviewid = reviewid; //isn't currently used
    this.fileName = fileName;
    this.fromRev = fromRev;
    this.toRev = toRev;
    this.r1Lines = new Array(); //array of lineClass
    this.r2Lines = new Array(); //array of lineClass
}

/*holds details about a line in a file*/
function lineClass(el, selected){
    this.el = el; //line element id
    this.selected = selected; //is the line currently selected
    this.comments; //what comments are associated with this line (Array of commentClass)
}

/*
 * holds the raw comment text for editing as well as the optimum
 * textarea width and height
 */
function commentClass(comment, editWidth, editHeight){
    this.comment = comment;
    this.editWidth = editWidth;
    this.editHeight = editHeight;
}

/*
 Take the template contents and replace all occurances of commentId with the commentId provided,
 then evaluate all the template js in $(...) through insertVars() and return the resulting template string.
 The template string is typically used to populate the innerHTML of a SPAN or DIV 
*/
function displayGroupComment(commentId, templateID){
    template = insertVars($(templateID).innerHTML.replace(/commentId/g,commentId));
    return template;
}

/*
Insert variables based on a pattern match from $(js statement)
 If the js statement starts with "var " it is evaluated and then deleted from the output so you can set
 up local variables to work with.
 If it doesn't start with "var " the value of the evaluated javascript statment is inserted.

 for example $(var iteration = review.currentIteration;) sets a variable called iteration which you can then
 use to substitute values like $(iteration.createDate)

@param pass in the template string
*/
function insertVars(instr){
//    window.alert(instr);
    varsRegex = /\$\(([\w.;= \[\]]+)\)/g;
    outstr = instr;
    varsArray = varsRegex.exec(instr);
    while(varsArray != null){
        if(varsArray[1].search(/^var /) != -1){
            eval(varsArray[1]);
            replacement = "";
        }else{
            replacement = eval(varsArray[1]);
        }
//        window.alert("replace "+varsArray[1]+" with "+replacement);
        escapedPattern = varsArray[1].replace(/\[/g,"\\[").replace(/\]/g,"\\]");
        replacementRegex = new RegExp("\\$\\("+escapedPattern+"\\)","g");
//        window.alert("source "+replacementRegex.source);
        outstr = outstr.replace(replacementRegex, replacement);
        varsArray = varsRegex.exec(instr);
    }
    return outstr;
}
