/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.util;

import alt.java.io.File;
import alt.java.io.FileImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;

public class FileFactory {
    private static Map mockFiles;
    private static final transient Category log;

    public static File getFile(String absoluteFilename) {
        if (mockFiles == null || mockFiles.get(absoluteFilename) == null) {
            return new FileImpl(absoluteFilename);
        }
        return (File)mockFiles.get(absoluteFilename);
    }

    public static void addMockFile(String filename, File file) {
        if (mockFiles == null) {
            mockFiles = new HashMap();
        }
        mockFiles.put(filename, file);
    }

    public static void flushMockFiles() {
        mockFiles = null;
    }

    public static void removeDirectory(File directory) {
        String[] list = directory.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String filename = list[i];
            File f = FileFactory.getFile(directory.getAbsolutePath() + System.getProperty("file.separator") + filename);
            if (f.isDirectory()) {
                FileFactory.removeDirectory(f);
                continue;
            }
            log.debug((Object)("Deleting " + f.getAbsolutePath()));
            if (f.delete()) continue;
            log.warn((Object)("Unable to delete file " + f.getAbsolutePath()));
        }
        if (!directory.delete()) {
            log.error((Object)("Unable to delete directory " + directory.getAbsolutePath()));
        }
    }

    static {
        log = Category.getInstance((Class)FileFactory.class);
    }
}

