/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.license;

import com.atlassian.license.License;
import com.atlassian.license.LicenseType;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class DefaultLicense
implements License {
    public static long EVALUATION_PERIOD = 2678400000L;
    protected Date dateCreated;
    protected Date datePurchased;
    protected Date dateExpired;
    protected String organisation;
    protected LicenseType licenseType;
    private int users;
    private String partnerName;
    private String licenseId;
    private int permittedClusteredNodes;
    private long duration = -1L;

    public DefaultLicense(Date dateCreated, Date datePurchased, String organisation, LicenseType licenseType, int users, String partnerName) {
        this(dateCreated, datePurchased, organisation, licenseType, users, partnerName, "", 0);
    }

    public DefaultLicense(Date dateCreated, Date datePurchased, Date expires, String organisationName, LicenseType licenseType, int users, String partnerName) {
        this(dateCreated, datePurchased, expires, organisationName, licenseType, users, partnerName, "", 0);
    }

    public DefaultLicense(Date dateCreated, Date datePurchased, String organisation, LicenseType licenseType, int users, String partnerName, String licenseId, int permittedClusteredNodes) {
        this.dateCreated = dateCreated;
        this.datePurchased = datePurchased;
        this.organisation = organisation;
        this.licenseType = licenseType;
        this.users = users;
        this.partnerName = partnerName;
        this.licenseId = licenseId;
        this.permittedClusteredNodes = permittedClusteredNodes;
    }

    public DefaultLicense(Date dateCreated, Date datePurchased, long duration, String organisation, LicenseType licenseType, int users, String partnerName, String licenseId, int permittedClusteredNodes) {
        this(dateCreated, datePurchased, organisation, licenseType, users, partnerName, licenseId, 0);
        this.duration = duration;
    }

    public DefaultLicense(Date dateCreated, Date datePurchased, Date dateExpired, String organisation, LicenseType licenseType, int users, String partnerName, String licenseId, int permittedClusteredNodes) {
        this(dateCreated, datePurchased, organisation, licenseType, users, partnerName, licenseId, permittedClusteredNodes);
        this.dateExpired = dateExpired;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDatePurchased() {
        return this.datePurchased;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String toString() {
        return this.licenseType.getNiceName() + " licensed to " + this.organisation;
    }

    public boolean isExpired() {
        Date expiry = this.getExpiryDate();
        if (expiry == null) {
            return false;
        }
        return expiry.getTime() < System.currentTimeMillis();
    }

    public Date getExpiryDate() {
        Date expiry = this.dateExpired;
        if (expiry == null && this.licenseType.isEvaluationLicenseType()) {
            expiry = new Date(this.datePurchased.getTime() + EVALUATION_PERIOD);
        }
        return expiry;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public boolean isLicenseLevel(Collection levels) {
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            String level = (String)iterator.next();
            if (this.getLicenseType().getDescription().toLowerCase().indexOf(level.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public int getUsers() {
        if (this.licenseType.requiresUserLimit()) {
            return this.users;
        }
        return -1;
    }

    public String getLicenseId() {
        return this.licenseId;
    }

    public int getPermittedClusteredNodes() {
        return this.permittedClusteredNodes;
    }

    public long getLicenseDuration() {
        return this.duration;
    }
}

