/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.impl.DynamicPlugin;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.JarClassLoader;
import com.atlassian.plugin.loaders.classloading.PluginsClassLoader;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import com.atlassian.plugin.util.FileUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassLoadingPluginLoader
implements PluginLoader {
    private static Log log = LogFactory.getLog((Class)ClassLoadingPluginLoader.class);
    private final String pluginDescriptorFileName;
    private final Scanner scanner;
    private final Map plugins;
    private final DescriptorParserFactory descriptorParserFactory;

    public ClassLoadingPluginLoader(File path) {
        this(path, "atlassian-plugin.xml");
    }

    public ClassLoadingPluginLoader(File path, String pluginDescriptorFileName) {
        log.debug((Object)("Creating classloader for url " + path));
        this.scanner = new Scanner(path);
        this.pluginDescriptorFileName = pluginDescriptorFileName;
        this.descriptorParserFactory = new XmlDescriptorParserFactory();
        this.plugins = new HashMap();
    }

    public Collection loadAllPlugins(ModuleDescriptorFactory moduleDescriptorFactory) {
        this.scanner.scan();
        Iterator iterator = this.scanner.getDeploymentUnits().iterator();
        while (iterator.hasNext()) {
            DeploymentUnit deploymentUnit = (DeploymentUnit)iterator.next();
            try {
                Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
                this.plugins.put(deploymentUnit, plugin);
            }
            catch (PluginParseException e) {
                log.error((Object)("Error loading descriptor for : " + deploymentUnit), (Throwable)((Object)e));
            }
        }
        return this.plugins.values();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Plugin deployPluginFromUnit(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin = null;
        InputStream pluginDescriptor = null;
        JarClassLoader loader = new JarClassLoader(deploymentUnit.getPath(), Thread.currentThread().getContextClassLoader());
        try {
            if (loader.getResource(this.pluginDescriptorFileName) == null) {
                throw new PluginParseException("No descriptor found in classloader for : " + deploymentUnit);
            }
            pluginDescriptor = loader.getResourceAsStream(this.pluginDescriptorFileName);
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor);
            plugin = parser.configurePlugin(moduleDescriptorFactory, new DynamicPlugin(deploymentUnit, loader));
        }
        catch (PluginParseException e) {
            try {
                ((PluginsClassLoader)loader).close();
                throw e;
                catch (RuntimeException e2) {
                    ((PluginsClassLoader)loader).close();
                    throw e2;
                }
                catch (Error e3) {
                    ((PluginsClassLoader)loader).close();
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                FileUtils.shutdownStream(pluginDescriptor);
                throw throwable;
            }
        }
        FileUtils.shutdownStream(pluginDescriptor);
        return plugin;
    }

    public boolean supportsRemoval() {
        return true;
    }

    public boolean supportsAddition() {
        return true;
    }

    public Collection addFoundPlugins(ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Collection updatedDeploymentUnits = this.scanner.scan();
        ArrayList<Plugin> foundPlugins = new ArrayList<Plugin>();
        Iterator it = updatedDeploymentUnits.iterator();
        while (it.hasNext()) {
            DeploymentUnit deploymentUnit = (DeploymentUnit)it.next();
            if (this.plugins.containsKey(deploymentUnit)) continue;
            Plugin plugin = this.deployPluginFromUnit(deploymentUnit, moduleDescriptorFactory);
            this.plugins.put(deploymentUnit, plugin);
            foundPlugins.add(plugin);
        }
        return foundPlugins;
    }

    public void removePlugin(Plugin plugin) throws PluginException {
        if (plugin.isEnabled()) {
            throw new PluginException("Cannot remove an enabled plugin");
        }
        if (!plugin.isUninstallable()) {
            throw new PluginException("Cannot remove an uninstallable plugin: [" + plugin.getName() + "]");
        }
        DeploymentUnit deploymentUnit = this.findMatchingDeploymentUnit(plugin);
        File pluginOnDisk = deploymentUnit.getPath();
        try {
            plugin.close();
            if (!pluginOnDisk.delete()) {
                throw new PluginException("Could not delete plugin [" + plugin.getName() + "].");
            }
        }
        catch (SecurityException e) {
            throw new PluginException(e);
        }
        this.scanner.clear(pluginOnDisk);
        this.plugins.remove(deploymentUnit);
    }

    private DeploymentUnit findMatchingDeploymentUnit(Plugin plugin) throws PluginException {
        DeploymentUnit deploymentUnit = null;
        Iterator iterator = this.plugins.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getValue() != plugin) continue;
            deploymentUnit = (DeploymentUnit)entry.getKey();
        }
        if (deploymentUnit == null) {
            throw new PluginException("This pluginLoader has no memory of deploying the plugin you are trying remove: [" + plugin.getName() + "]");
        }
        return deploymentUnit;
    }

    public void shutDown() {
        this.scanner.clearAll();
        Iterator it = this.plugins.values().iterator();
        while (it.hasNext()) {
            Plugin plugin = (Plugin)it.next();
            plugin.close();
        }
    }
}

