/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders.classloading;

import com.atlassian.plugin.loaders.classloading.BytesURLStreamHandler;
import com.atlassian.plugin.loaders.classloading.PluginsClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;

public class JarClassLoader
extends PluginsClassLoader {
    private JarFile jar;
    private File file;
    private LinkedList innerLibraries;
    private HashMap cachedFiles = new HashMap();

    public JarClassLoader(File file, ClassLoader parent) {
        super(parent);
        this.file = file;
    }

    protected URL getDataURL(String name, byte[] data) throws MalformedURLException {
        return new URL(null, this.file.toURL().toExternalForm() + '!' + name, new BytesURLStreamHandler(data));
    }

    private void openJar() throws IOException {
        if (this.jar == null) {
            this.jar = new JarFile(this.file);
        }
    }

    public synchronized void loadInnerLibraries() {
        if (this.jar == null) {
            return;
        }
        this.innerLibraries = new LinkedList();
        Enumeration<JarEntry> entries = this.jar.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/lib/") || !name.endsWith(".jar")) continue;
            this.innerLibraries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized byte[] getFile(String path) {
        InnerJar innerJar;
        byte[] data;
        Iterator iter;
        FileBytes cacheLookup = (FileBytes)this.cachedFiles.get(path);
        if (cacheLookup != null) {
            return cacheLookup.data;
        }
        InputStream in = null;
        try {
            this.openJar();
            ZipEntry entry = this.jar.getEntry(path);
            if (entry == null) {
                if (this.innerLibraries == null) {
                    this.loadInnerLibraries();
                }
            } else {
                in = this.jar.getInputStream(entry);
                int size = (int)entry.getSize();
                byte[] data2 = JarClassLoader.readStream(in, size);
                this.cachedFiles.put(path, new FileBytes(data2));
                byte[] byArray = data2;
                return byArray;
            }
            iter = this.innerLibraries.iterator();
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        do {
            if (iter.hasNext()) continue;
            this.cachedFiles.put(path, new FileBytes(null));
            return null;
        } while ((data = (innerJar = new InnerJar(this.jar, (ZipEntry)iter.next())).getFile(path)) == null);
        this.cachedFiles.put(path, new FileBytes(data));
        return data;
    }

    public Object clone() {
        JarClassLoader loader = new JarClassLoader(this.file, this.getParent());
        loader.packages = this.packages;
        return loader;
    }

    public void close() {
        try {
            if (this.jar != null) {
                this.jar.close();
            }
            this.jar = null;
        }
        catch (IOException e) {
            log.error((Object)("Error closing JAR: " + e), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        byte[] data = this.getFile(path);
        if (data == null) {
            throw new ClassNotFoundException();
        }
        int pkgOffset = name.lastIndexOf(".");
        if (pkgOffset != -1) {
            String pkgName = name.substring(0, pkgOffset);
            JarClassLoader jarClassLoader = this;
            synchronized (jarClassLoader) {
                Package pkg = this.getPackage(pkgName);
                if (pkg == null) {
                    this.definePackage(pkgName, null, null, null, null, null, null, null);
                }
            }
        }
        return this.defineClass(name, data, 0, data.length);
    }

    private static class InnerJar {
        private JarFile jar;
        private ZipEntry entry;
        private Set knownPackagePrefixes = new HashSet();

        private InnerJar(JarFile jar, ZipEntry entry) {
            this.jar = jar;
            this.entry = entry;
            this.scanForPrefixes();
        }

        private void scanForPrefixes() {
            try {
                ZipEntry eachEntry;
                JarInputStream jarStream = new JarInputStream(this.jar.getInputStream(this.entry));
                while ((eachEntry = jarStream.getNextEntry()) != null) {
                    if (!eachEntry.isDirectory()) continue;
                    this.knownPackagePrefixes.add(eachEntry.getName());
                }
            }
            catch (IOException e) {
                PluginsClassLoader.log.error((Object)e, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getFile(String path) {
            byte[] byArray;
            ZipEntry eachEntry;
            if (path == null) {
                return null;
            }
            String prefix = this.getPrefix(path);
            if (prefix.length() != 0 && !this.knownPackagePrefixes.contains(prefix)) {
                return null;
            }
            JarInputStream jarStream = new JarInputStream(this.jar.getInputStream(this.entry));
            while ((eachEntry = jarStream.getNextEntry()) != null && !path.equals(eachEntry.getName())) {
            }
            if (eachEntry == null) {
                return null;
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int read;
                byte[] buffer = new byte[2048];
                while (jarStream.available() > 0 && (read = jarStream.read(buffer, 0, buffer.length)) >= 0) {
                    out.write(buffer, 0, read);
                }
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException e) {
                    PluginsClassLoader.log.error((Object)e, (Throwable)e);
                    return null;
                }
            }
            out.close();
            return byArray;
        }

        private String getPrefix(String path) {
            int i = path.lastIndexOf("/");
            return i >= 0 ? path.substring(0, i + 1) : "";
        }
    }

    private static class FileBytes {
        private byte[] data;

        private FileBytes(byte[] data) {
            this.data = data;
        }
    }
}

