/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders.classloading;

import com.atlassian.plugin.loaders.classloading.JarClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PluginsClassLoader
extends SecureClassLoader
implements Cloneable {
    protected static Log log = LogFactory.getLog((Class)PluginsClassLoader.class);
    protected String[] packages = null;
    private Map cache = new HashMap();

    protected PluginsClassLoader(ClassLoader parent) {
        super(parent);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = (Class)this.cache.get(name);
        if (c != null) {
            return c;
        }
        try {
            c = this.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            return super.loadClass(name, resolve);
        }
        this.cache.put(name, c);
        return c;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        byte[] data = this.getFile(path);
        if (data == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, data, 0, data.length);
    }

    protected URL findResource(String name) {
        byte[] data = this.getFile(name);
        if (data == null) {
            return null;
        }
        try {
            return this.getDataURL(name, data);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected abstract URL getDataURL(String var1, byte[] var2) throws MalformedURLException;

    public Enumeration findResources(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            return null;
        }
        return Collections.enumeration(Collections.singleton(url));
    }

    protected abstract byte[] getFile(String var1);

    public static ClassLoader getInstance(URL url) {
        return PluginsClassLoader.getInstance(url, ClassLoader.getSystemClassLoader());
    }

    public static ClassLoader getInstance(URL url, ClassLoader parent) {
        SecureClassLoader loader;
        File file = new File(url.getFile());
        if (file.isDirectory()) {
            log.warn((Object)("Making a DirectoryClassLoader for: " + file));
            loader = new URLClassLoader(new URL[]{url}, parent);
        } else {
            log.warn((Object)("Making a JarClassLoader for: " + file));
            loader = new JarClassLoader(file, parent);
        }
        return loader;
    }

    public abstract Object clone();

    public static byte[] readStream(InputStream in, int size) throws IOException {
        int bytesRead;
        if (in == null) {
            return null;
        }
        if (size == 0) {
            return new byte[0];
        }
        byte[] data = new byte[size];
        for (int currentTotal = 0; currentTotal < data.length && (bytesRead = in.read(data, currentTotal, data.length - currentTotal)) >= 0; currentTotal += bytesRead) {
        }
        in.close();
        return data;
    }

    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url != null) {
            return url;
        }
        return super.getResource(name);
    }

    public void close() {
    }
}

