/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders.classloading;

import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Scanner {
    private static Log log = LogFactory.getLog((Class)Scanner.class);
    private static final FileFilter fileFilter = new JarFileFilter();
    private File libDir;
    private Map scannedDeploymentUnits = new HashMap();

    public Scanner(File libDir) {
        this.libDir = libDir;
    }

    private DeploymentUnit createAndStoreDeploymentUnit(File file) throws MalformedURLException {
        if (this.isScanned(file)) {
            return null;
        }
        DeploymentUnit unit = new DeploymentUnit(file);
        this.scannedDeploymentUnits.put(file.getAbsolutePath(), unit);
        return unit;
    }

    public DeploymentUnit locateDeploymentUnit(File file) {
        return (DeploymentUnit)this.scannedDeploymentUnits.get(file.getAbsolutePath());
    }

    private boolean isScanned(File file) {
        return this.locateDeploymentUnit(file) != null;
    }

    public void clear(File file) {
        this.scannedDeploymentUnits.remove(file.getAbsolutePath());
    }

    public Collection scan() {
        ArrayList<File> removedFiles = new ArrayList<File>();
        Iterator iterator = this.scannedDeploymentUnits.values().iterator();
        while (iterator.hasNext()) {
            DeploymentUnit unit = (DeploymentUnit)iterator.next();
            if (unit.path.exists() && unit.path.canRead()) continue;
            removedFiles.add(unit.getPath());
        }
        this.clear(removedFiles);
        ArrayList<DeploymentUnit> result = new ArrayList<DeploymentUnit>();
        File[] files = this.libDir.listFiles(fileFilter);
        if (files == null) {
            log.error((Object)("listFiles returned null for directory " + this.libDir.getAbsolutePath()));
        } else {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                try {
                    DeploymentUnit unit;
                    if (this.isScanned(file) && this.isModified(file)) {
                        this.clear(file);
                        unit = this.createAndStoreDeploymentUnit(file);
                        if (unit == null) continue;
                        result.add(unit);
                        continue;
                    }
                    if (this.isScanned(file) || (unit = this.createAndStoreDeploymentUnit(file)) == null) continue;
                    result.add(unit);
                    continue;
                }
                catch (MalformedURLException e) {
                    log.error((Object)("Error deploying plugin " + file.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return result;
    }

    private boolean isModified(File file) {
        DeploymentUnit unit = this.locateDeploymentUnit(file);
        return file.lastModified() > unit.lastModified();
    }

    private void clear(List toUndeploy) {
        Iterator iterator = toUndeploy.iterator();
        while (iterator.hasNext()) {
            this.clear((File)iterator.next());
        }
    }

    public Collection getDeploymentUnits() {
        return Collections.unmodifiableCollection(this.scannedDeploymentUnits.values());
    }

    public void clearAll() {
        this.scannedDeploymentUnits.clear();
    }

    static class JarFileFilter
    implements FileFilter {
        JarFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().endsWith(".jar");
        }
    }
}

