/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.AbstractCompositeCondition;
import com.atlassian.plugin.web.conditions.AndCompositeCondition;
import com.atlassian.plugin.web.conditions.InvertedCondition;
import com.atlassian.plugin.web.conditions.OrCompositeCondition;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebLabel;
import com.atlassian.plugin.web.model.DefaultWebParam;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebParam;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public abstract class AbstractWebFragmentModuleDescriptor
extends AbstractModuleDescriptor
implements StateAware,
WebFragmentModuleDescriptor {
    protected WebInterfaceManager webInterfaceManager;
    protected int weight;
    protected Condition condition;
    protected ContextProvider contextProvider;
    protected DefaultWebLabel label;
    protected DefaultWebLabel tooltip;
    protected WebParam params;

    protected AbstractWebFragmentModuleDescriptor(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public AbstractWebFragmentModuleDescriptor() {
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.weight = 1000;
        try {
            this.weight = Integer.parseInt(element.attributeValue("weight"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (element.element("context-provider") != null) {
            this.contextProvider = this.makeContextProvider(element.element("context-provider"));
        }
        if (element.element("label") != null) {
            this.label = new DefaultWebLabel(element.element("label"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
        }
        if (element.element("tooltip") != null) {
            this.tooltip = new DefaultWebLabel(element.element("tooltip"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
        }
        if (this.getParams() != null) {
            this.params = new DefaultWebParam(this.getParams(), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
        }
        this.condition = this.makeConditions(element, 1);
    }

    protected Condition makeConditions(Element element, int type) throws PluginParseException {
        List singleConditionElements = element.elements("condition");
        Condition singleConditions = null;
        if (singleConditionElements != null && !singleConditionElements.isEmpty()) {
            singleConditions = this.makeConditions(singleConditionElements, type);
        }
        List nestedConditionsElements = element.elements("conditions");
        AbstractCompositeCondition nestedConditions = null;
        if (nestedConditionsElements != null && !nestedConditionsElements.isEmpty()) {
            nestedConditions = this.getCompositeCondition(type);
            Iterator iterator = nestedConditionsElements.iterator();
            while (iterator.hasNext()) {
                Element nestedElement = (Element)iterator.next();
                nestedConditions.addCondition(this.makeConditions(nestedElement, this.getCompositeType(nestedElement.attributeValue("type"))));
            }
        }
        if (singleConditions != null && nestedConditions != null) {
            AbstractCompositeCondition compositeCondition = this.getCompositeCondition(type);
            compositeCondition.addCondition(singleConditions);
            compositeCondition.addCondition(nestedConditions);
            return compositeCondition;
        }
        if (singleConditions != null) {
            return singleConditions;
        }
        if (nestedConditions != null) {
            return nestedConditions;
        }
        return null;
    }

    protected Condition makeConditions(List elements, int type) throws PluginParseException {
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return this.makeCondition((Element)elements.get(0));
        }
        AbstractCompositeCondition compositeCondition = this.getCompositeCondition(type);
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            Element element = (Element)it.next();
            compositeCondition.addCondition(this.makeCondition(element));
        }
        return compositeCondition;
    }

    protected Condition makeCondition(Element element) throws PluginParseException {
        try {
            Condition condition = this.webInterfaceManager.getWebFragmentHelper().loadCondition(element.attributeValue("class"), this.plugin);
            condition.init(LoaderUtils.getParams(element));
            if (element.attribute("invert") != null && "true".equals(element.attributeValue("invert"))) {
                return new InvertedCondition(condition);
            }
            return condition;
        }
        catch (ClassCastException e) {
            throw new PluginParseException("Configured condition class does not implement the Condition interface");
        }
        catch (Throwable t) {
            throw new PluginParseException(t);
        }
    }

    protected ContextProvider makeContextProvider(Element element) throws PluginParseException {
        try {
            ContextProvider context = this.webInterfaceManager.getWebFragmentHelper().loadContextProvider(element.attributeValue("class"), this.plugin);
            context.init(LoaderUtils.getParams(element));
            return context;
        }
        catch (ClassCastException e) {
            throw new PluginParseException("Configured context-provider class does not implement the ContextProvider interface");
        }
        catch (Throwable t) {
            throw new PluginParseException(t);
        }
    }

    private int getCompositeType(String type) throws PluginParseException {
        if ("or".equalsIgnoreCase(type)) {
            return 0;
        }
        if ("and".equalsIgnoreCase(type)) {
            return 1;
        }
        throw new PluginParseException("Invalid condition type specified. type = " + type);
    }

    private AbstractCompositeCondition getCompositeCondition(int type) throws PluginParseException {
        switch (type) {
            case 0: {
                return new OrCompositeCondition();
            }
            case 1: {
                return new AndCompositeCondition();
            }
        }
        throw new PluginParseException("Invalid condition type specified. type = " + type);
    }

    public void enabled() {
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        this.webInterfaceManager.refresh();
    }

    public int getWeight() {
        return this.weight;
    }

    public Object getModule() {
        return null;
    }

    public WebLabel getWebLabel() {
        return this.label;
    }

    public WebLabel getTooltip() {
        return this.tooltip;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    public WebParam getWebParams() {
        return this.params;
    }
}

