/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.cookie;

import com.atlassian.seraph.config.SecurityConfigFactory;
import com.atlassian.seraph.cookie.CookieEncoder;
import com.atlassian.seraph.util.CookieUtils;
import com.atlassian.seraph.util.EncryptionUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.log4j.Logger;

public class EncryptedCookieEncoder
implements CookieEncoder {
    private static final Logger LOG = Logger.getLogger((Class)EncryptedCookieEncoder.class);
    private static final String URL_ENCODING = "UTF-8";
    private static final String SEPARATOR = "^^^";
    private final EncryptionUtils encryptionUtils;

    public EncryptedCookieEncoder() {
        this(SecurityConfigFactory.getInstance().getCookieEncoding());
    }

    protected EncryptedCookieEncoder(String password) {
        if (password == null || password.length() == 0) {
            throw new IllegalArgumentException("The password must be specified");
        }
        this.encryptionUtils = new EncryptionUtils();
        this.encryptionUtils.setPassword(password);
    }

    public String encodePasswordCookie(String username, String password, String encoding) {
        StringBuffer sb = new StringBuffer();
        sb.append(username).append(SEPARATOR).append(password);
        return EncryptedCookieEncoder.escapeInvalidCookieCharacters(this.encryptionUtils.encrypt(sb.toString()));
    }

    public String[] decodePasswordCookie(String cookieVal, String encoding) {
        String[] result = new String[2];
        try {
            String text = this.encryptionUtils.decrypt(EncryptedCookieEncoder.unescapeInvalidCookieCharacters(cookieVal));
            int pos = text.indexOf(SEPARATOR);
            if (pos < 0) {
                LOG.info((Object)("Successfully decrypted password cookie, but decrypted value '" + text + "' is invalid because separator ('" + SEPARATOR + "') was not found. Returning null."));
                return null;
            }
            result[0] = text.substring(0, pos);
            result[1] = text.substring(pos + SEPARATOR.length());
        }
        catch (RuntimeException ex) {
            LOG.info((Object)"Password cookie could not be decrypted, trying old insecure method of decoding it");
            return CookieUtils.decodePasswordCookie(cookieVal, encoding);
        }
        return result;
    }

    private static String escapeInvalidCookieCharacters(String s) {
        try {
            return URLEncoder.encode(s, URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOG.fatal((Object)"UTF-8 encoding unsupported !!?!! How is that possible?", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static String unescapeInvalidCookieCharacters(String s) {
        try {
            return URLDecoder.decode(s, URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            LOG.fatal((Object)"UTF-8 encoding unsupported !!?!! How is that possible?", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

