/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.C3P0Registry;
import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    static final MLogger logger = MLog.getLogger(class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource == null ? (class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource = WrapperConnectionPoolDataSource.class$("com.mchange.v2.c3p0.WrapperConnectionPoolDataSource")) : class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource);
    ConnectionTester connectionTester = C3P0ImplUtils.defaultConnectionTester();
    static /* synthetic */ Class class$com$mchange$v2$c3p0$WrapperConnectionPoolDataSource;

    public WrapperConnectionPoolDataSource() {
        VetoableChangeListener setConnectionTesterListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Object val = evt.getNewValue();
                try {
                    if ("connectionTesterClassName".equals(evt.getPropertyName())) {
                        WrapperConnectionPoolDataSource.this.recreateConnectionTester((String)val);
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, "Failed to create ConnectionTester of class " + val, e);
                    }
                    throw new PropertyVetoException("Could not instantiate connection tester class with name '" + val + "'.", evt);
                }
            }
        };
        this.addVetoableChangeListener(setConnectionTesterListener);
        C3P0Registry.register(this);
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        Connection conn = this.getNestedDataSource().getConnection();
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        Connection conn = this.getNestedDataSource().getConnection(user, password);
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public synchronized PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        this.getNestedDataSource().setLogWriter(out);
    }

    public synchronized void setLoginTimeout(int seconds) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(seconds);
    }

    public synchronized int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public synchronized String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'user' property from our nested DataSource. Defaulting to no specified username.", e);
            }
            return null;
        }
    }

    public synchronized String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An Exception occurred while trying to find the 'password' property from our nested DataSource. Defaulting to no specified password.", e);
            }
            return null;
        }
    }

    private synchronized void recreateConnectionTester(String className) throws Exception {
        ConnectionTester ct;
        this.connectionTester = className != null ? (ct = (ConnectionTester)Class.forName(className).newInstance()) : C3P0ImplUtils.defaultConnectionTester();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

