/*
 * Decompiled with CFR 0.152.
 */
package clover.com.cenqua.license;

import clover_cenqua_com.atlassian.license.License;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CenquaLicense {
    public static final String LICENSE_NAMESPACE = "license";
    public static final String KEY_KEY = "license.key";
    public static final String USER_KEY = "license.user";
    public static final String ORG_KEY = "license.org";
    public static final String ID_KEY = "license.id";
    public static final String PUBLIC_ID_KEY = "license.publicid";
    public static final String ISSUED_KEY = "license.issued";
    public static final String MAINTEXPIRY_KEY = "license.maintExpiry";
    public static final String SEATS_KEY = "license.seats";
    public static final String ORIGIN_CENQUA = "Cenqua";
    public static final String ORIGIN_ATLASSIAN = "Atlassian";
    public static final String LICENSE_ORIGIN_KEY = "license.synthetic.license-origin";
    private static final long A_DAY = 86400000L;
    private final String productName;
    private final String licenseName;
    private final String supportedVersions;
    private final long softExpiry;
    private final long hardExpiry;
    private final Properties properties;
    private long licenseID;
    private String publicID;
    private long issued;
    private long maintExpiry;
    private int seats;
    private String key;
    private String user;
    private String organisation;

    public CenquaLicense(CenquaLicense that) {
        this.productName = that.productName;
        this.licenseName = that.licenseName;
        this.supportedVersions = that.supportedVersions;
        this.softExpiry = that.softExpiry;
        this.hardExpiry = that.hardExpiry;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)that.properties);
        this.extractLicenseProps();
    }

    public CenquaLicense(String productName, String licenseName, String supportedVersions, long softExpiry, long hardExpiry, Properties properties) {
        this.productName = productName;
        this.licenseName = licenseName;
        this.supportedVersions = supportedVersions;
        this.softExpiry = softExpiry;
        this.hardExpiry = hardExpiry;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)properties);
        this.properties.put(LICENSE_ORIGIN_KEY, ORIGIN_CENQUA);
        this.extractLicenseProps();
    }

    public CenquaLicense(String productName, License atlassianLicense, Properties props) {
        this.productName = productName;
        this.licenseName = atlassianLicense.getLicenseType().getNiceName();
        this.supportedVersions = "x";
        boolean expires = atlassianLicense.getLicenseType().isEvaluationLicenseType();
        this.hardExpiry = this.softExpiry = expires ? atlassianLicense.getDateCreated().getTime() + 2592000000L : 0L;
        this.maintExpiry = atlassianLicense.getDateCreated().getTime() + 31622400000L;
        this.organisation = atlassianLicense.getOrganisation();
        this.seats = atlassianLicense.getLicenseType().requiresUserLimit() ? atlassianLicense.getUsers() : 0;
        this.issued = atlassianLicense.getDatePurchased().getTime();
        this.user = atlassianLicense.getOrganisation();
        this.licenseID = -1L;
        this.key = atlassianLicense.getLicenseId();
        this.publicID = "";
        this.properties = new Properties();
        this.properties.put(LICENSE_ORIGIN_KEY, ORIGIN_ATLASSIAN);
        this.properties.put("owner", atlassianLicense.getLicenseType().getNiceName() + " License registered to " + atlassianLicense.getOrganisation() + ".");
        this.properties.put("preexpiry", expires ? "You have $daysleft day(s) before your license expires." : "");
        this.properties.put("postexpiry", expires ? "Your license has expired." : "");
        this.properties.put("termination", expires ? "Your license has expired." : "");
        this.properties.put("contact", "Please visit http://www.atlassian.com to obtain a license.");
        this.properties.put(ID_KEY, "" + this.licenseID);
        this.properties.put(PUBLIC_ID_KEY, this.publicID);
        this.properties.put(ISSUED_KEY, "" + this.issued);
        this.properties.put(MAINTEXPIRY_KEY, "" + this.maintExpiry);
        this.properties.put(KEY_KEY, this.key);
        this.properties.put(USER_KEY, this.user);
        this.properties.put(ORG_KEY, atlassianLicense.getOrganisation());
        this.properties.put(SEATS_KEY, "" + this.seats);
        this.properties.putAll((Map<?, ?>)props);
    }

    private void extractLicenseProps() {
        this.licenseID = Long.parseLong(this.properties.getProperty(ID_KEY, "-1"));
        this.publicID = this.properties.getProperty(PUBLIC_ID_KEY, "");
        this.issued = Long.parseLong(this.properties.getProperty(ISSUED_KEY, "0"));
        this.maintExpiry = Long.parseLong(this.properties.getProperty(MAINTEXPIRY_KEY, "0"));
        this.key = this.properties.getProperty(KEY_KEY, "-");
        this.user = this.properties.getProperty(USER_KEY, "-");
        this.organisation = this.properties.getProperty(ORG_KEY, "-");
        this.seats = Integer.parseInt(this.properties.getProperty(SEATS_KEY, "0"));
    }

    public String getProductName() {
        return this.productName;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getSupportedVersions() {
        return this.supportedVersions;
    }

    public long getSoftExpiry() {
        return this.softExpiry;
    }

    public long getHardExpiry() {
        return this.hardExpiry;
    }

    public String getKey() {
        return this.key;
    }

    public String getUser() {
        return this.user;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public int getSeats() {
        return this.seats;
    }

    public Iterator getPropertyKeys() {
        return this.properties.keySet().iterator();
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public boolean isExpired(long time) {
        return this.expires() && time > this.softExpiry;
    }

    public boolean isTerminated() {
        return this.isTerminated(System.currentTimeMillis());
    }

    public boolean isTerminated(long time) {
        return this.terminates() && time > this.hardExpiry;
    }

    public boolean expires() {
        return this.softExpiry != 0L;
    }

    public boolean terminates() {
        return this.hardExpiry != 0L;
    }

    public boolean maintenanceExpires() {
        return this.maintExpiry != 0L;
    }

    public boolean isMaintenanceExpired() {
        return this.isMaintenanceExpired(System.currentTimeMillis());
    }

    public boolean isMaintenanceExpired(long time) {
        return this.maintenanceExpires() && time > this.maintExpiry;
    }

    public long getMaintExpiry() {
        return this.maintExpiry;
    }

    public long getDaysTillExpiry() {
        return this.getDaysTillExpiry(System.currentTimeMillis());
    }

    public long getDaysTillExpiry(long now) {
        long days = this.countDays(this.softExpiry - now);
        return days < 0L ? 0L : days;
    }

    public long getID() {
        return this.licenseID;
    }

    public String getPublicID() {
        return this.publicID;
    }

    public long getIssuedTime() {
        return this.issued;
    }

    private long countDays(long aMilliseconds) {
        return aMilliseconds / 86400000L;
    }

    public boolean isVersionSupported(String str) {
        if (this.getSupportedVersions() == null || this.getSupportedVersions().length() == 0) {
            return false;
        }
        if (str == null || str.length() == 0) {
            return false;
        }
        String[] versions = CenquaLicense.toArray(this.getSupportedVersions(), ",");
        for (int i = 0; i < versions.length; ++i) {
            if (!this.isVersionSupported(versions[i].trim(), str)) continue;
            return true;
        }
        return false;
    }

    private boolean isVersionSupported(String version, String str) {
        String[] supported = CenquaLicense.toArray(version, ".");
        String[] actual = CenquaLicense.toArray(str, ".");
        for (int i = 0; i < supported.length; ++i) {
            String a;
            String s = supported[i];
            String string = a = i < actual.length ? actual[i] : "";
            if (s.compareTo("x") == 0 || s.compareTo(a) == 0) continue;
            return false;
        }
        return true;
    }

    private static String[] toArray(String str, String del) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(str, del, false);
        String[] array = new String[tokens.countTokens()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = tokens.nextToken();
        }
        return array;
    }
}

