/*
 * Decompiled with CFR 0.152.
 */
package clover.edu.emory.mathcs.backport.java.util.concurrent;

import clover.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import clover.edu.emory.mathcs.backport.java.util.concurrent.CancellationException;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ExecutorCompletionService;
import clover.edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import clover.edu.emory.mathcs.backport.java.util.concurrent.Future;
import clover.edu.emory.mathcs.backport.java.util.concurrent.FutureTask;
import clover.edu.emory.mathcs.backport.java.util.concurrent.RunnableFuture;
import clover.edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import clover.edu.emory.mathcs.backport.java.util.concurrent.TimeoutException;
import clover.edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractExecutorService
implements ExecutorService {
    static final /* synthetic */ boolean $assertionsDisabled;

    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new FutureTask(runnable, value);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    public Future submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object doInvokeAny(Collection tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        int ntasks = tasks.size();
        if (ntasks == 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Future> futures = new ArrayList<Future>(ntasks);
        ExecutorCompletionService ecs = new ExecutorCompletionService(this);
        try {
            ExecutionException ee = null;
            long lastTime = timed ? Utils.nanoTime() : 0L;
            Iterator it = tasks.iterator();
            futures.add(ecs.submit((Callable)it.next()));
            --ntasks;
            int active = 1;
            while (true) {
                Object object;
                Future f;
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit((Callable)it.next()));
                        ++active;
                    } else {
                        if (active == 0) {
                            if (ee != null) throw ee;
                            break;
                        }
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            long now = Utils.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    object = f.get();
                }
                catch (InterruptedException interruptedException) {
                    throw interruptedException;
                }
                catch (ExecutionException executionException) {
                    ee = executionException;
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    ee = new ExecutionException(runtimeException);
                    continue;
                }
                Object var18_17 = null;
                Iterator iterator = futures.iterator();
                while (iterator.hasNext()) {
                    ((Future)iterator.next()).cancel(true);
                }
                return object;
                break;
            }
            ee = new ExecutionException();
            throw ee;
        }
        catch (Throwable throwable) {
            Object var18_18 = null;
            Iterator iterator = futures.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    throw throwable;
                }
                ((Future)iterator.next()).cancel(true);
            }
        }
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection tasks) throws InterruptedException {
        ArrayList<RunnableFuture> arrayList;
        block11: {
            Iterator i3;
            if (tasks == null) {
                throw new NullPointerException();
            }
            ArrayList<RunnableFuture> futures = new ArrayList<RunnableFuture>(tasks.size());
            boolean done = false;
            try {
                Future f;
                Iterator t = tasks.iterator();
                while (t.hasNext()) {
                    f = this.newTaskFor((Callable)t.next());
                    futures.add((RunnableFuture)f);
                    this.execute((Runnable)((Object)f));
                }
                Iterator i2 = futures.iterator();
                while (i2.hasNext()) {
                    f = (Future)i2.next();
                    if (f.isDone()) continue;
                    try {
                        f.get();
                    }
                    catch (CancellationException ignore) {
                    }
                    catch (ExecutionException ignore) {}
                }
                done = true;
                arrayList = futures;
                Object var8_9 = null;
                if (done) break block11;
                i3 = futures.iterator();
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (!done) {
                    Iterator i3 = futures.iterator();
                    while (i3.hasNext()) {
                        Future f = (Future)i3.next();
                        f.cancel(true);
                    }
                }
                throw throwable;
            }
            while (i3.hasNext()) {
                Future f = (Future)i3.next();
                f.cancel(true);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        Object object;
        boolean done;
        ArrayList<RunnableFuture> futures;
        block21: {
            ArrayList<RunnableFuture> arrayList;
            block20: {
                Iterator iterator;
                ArrayList<RunnableFuture> arrayList2;
                block19: {
                    if (tasks == null || unit == null) {
                        throw new NullPointerException();
                    }
                    long nanos = unit.toNanos(timeout);
                    futures = new ArrayList<RunnableFuture>(tasks.size());
                    done = false;
                    try {
                        Iterator t = tasks.iterator();
                        while (t.hasNext()) {
                            futures.add(this.newTaskFor((Callable)t.next()));
                        }
                        long l = Utils.nanoTime();
                        Iterator iterator2 = futures.iterator();
                        while (iterator2.hasNext()) {
                            this.execute((Runnable)iterator2.next());
                            long l2 = Utils.nanoTime();
                            if ((nanos -= l2 - (l = l2)) > 0L) continue;
                            arrayList2 = futures;
                            Object var22_16 = null;
                            if (done) return arrayList2;
                            iterator = futures.iterator();
                            break block19;
                        }
                        object = futures.iterator();
                        while (object.hasNext()) {
                            Future future = (Future)object.next();
                            if (future.isDone()) continue;
                            if (nanos <= 0L) {
                                arrayList = futures;
                                break block20;
                            }
                            try {
                                future.get(nanos, TimeUnit.NANOSECONDS);
                            }
                            catch (CancellationException cancellationException) {
                            }
                            catch (ExecutionException executionException) {
                            }
                            catch (TimeoutException timeoutException) {
                                ArrayList<RunnableFuture> arrayList3 = futures;
                                Object var22_18 = null;
                                if (done) return arrayList3;
                                Iterator iterator3 = futures.iterator();
                                while (true) {
                                    if (!iterator3.hasNext()) {
                                        return arrayList3;
                                    }
                                    Future future2 = (Future)iterator3.next();
                                    future2.cancel(true);
                                }
                            }
                            long l3 = Utils.nanoTime();
                            nanos -= l3 - l;
                            l = l3;
                        }
                        done = true;
                        object = futures;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var22_20 = null;
                        if (!done) {
                            Iterator iterator4 = futures.iterator();
                            while (iterator4.hasNext()) {
                                Future future = (Future)iterator4.next();
                                future.cancel(true);
                            }
                        }
                        throw throwable;
                    }
                }
                while (iterator.hasNext()) {
                    Future future = (Future)iterator.next();
                    future.cancel(true);
                }
                return arrayList2;
            }
            Object var22_17 = null;
            if (done) return arrayList;
            Iterator iterator = futures.iterator();
            while (iterator.hasNext()) {
                Future future = (Future)iterator.next();
                future.cancel(true);
            }
            return arrayList;
        }
        Object var22_19 = null;
        if (done) return object;
        Iterator iterator = futures.iterator();
        while (iterator.hasNext()) {
            Future future = (Future)iterator.next();
            future.cancel(true);
        }
        return object;
    }

    static {
        $assertionsDisabled = !AbstractExecutorService.class.desiredAssertionStatus();
    }
}

