/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteCollection;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2ByteMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2ByteMap
implements Long2ByteMap,
Serializable {
    protected byte defRetValue;

    protected AbstractLong2ByteMap() {
    }

    public void setDefRetValue(byte rv) {
        this.defaultReturnValue(rv);
    }

    public byte getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(byte rv) {
        this.defRetValue = rv;
    }

    public byte defaultReturnValue() {
        return this.defRetValue;
    }

    public byte put(long key, byte value) {
        throw new UnsupportedOperationException();
    }

    public byte remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? new Byte(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        byte v = this.put(k, (Byte)ov);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        byte v = this.remove(k);
        return this.containsKey(k) ? new Byte(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Byte)ov);
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(byte v) {
        return ((ByteCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2ByteMap) {
            while (n-- != 0) {
                Long2ByteMap.Entry e = (Long2ByteMap.Entry)i.next();
                this.put(e.getLongKey(), e.getByteValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2ByteMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2ByteMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2ByteMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2ByteMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractByteCollection(){

            public boolean contains(byte k) {
                return AbstractLong2ByteMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2ByteMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2ByteMap.this.entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Long2ByteMap.Entry)this.i.next()).getByteValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Long2ByteMap.Entry first = (Long2ByteMap.Entry)i.next();
            s.append(String.valueOf(first.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(first.getByteValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2ByteMap.Entry {
        protected long key;
        protected byte value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = (Byte)value;
        }

        public BasicEntry(long key, byte value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Byte(this.value);
        }

        public byte getByteValue() {
            return this.value;
        }

        public byte setValue(byte value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Byte(this.setValue((Byte)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == (Byte)e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

