/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatCollection;
import clover.it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import clover.it.unimi.dsi.fastutil.floats.FloatCollection;
import clover.it.unimi.dsi.fastutil.floats.FloatIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongIterator;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSet;
import clover.it.unimi.dsi.fastutil.longs.Long2FloatMap;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractLong2FloatMap
implements Long2FloatMap,
Serializable {
    protected float defRetValue;

    protected AbstractLong2FloatMap() {
    }

    public void setDefRetValue(float rv) {
        this.defaultReturnValue(rv);
    }

    public float getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(float rv) {
        this.defRetValue = rv;
    }

    public float defaultReturnValue() {
        return this.defRetValue;
    }

    public float put(long key, float value) {
        throw new UnsupportedOperationException();
    }

    public float remove(long key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        long k = (Long)ok;
        return this.containsKey(k) ? new Float(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        long k = (Long)ok;
        float v = this.put(k, ((Float)ov).floatValue());
        return this.containsKey(k) ? new Float(v) : null;
    }

    public Object remove(Object ok) {
        long k = (Long)ok;
        float v = this.remove(k);
        return this.containsKey(k) ? new Float(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Float)ov).floatValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Long)ok);
    }

    public boolean containsValue(float v) {
        return ((FloatCollection)this.values()).contains(v);
    }

    public boolean containsKey(long k) {
        return ((LongSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Long2FloatMap) {
            while (n-- != 0) {
                Long2FloatMap.Entry e = (Long2FloatMap.Entry)i.next();
                this.put(e.getLongKey(), e.getFloatValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractLongSet(){

            public boolean contains(long k) {
                return AbstractLong2FloatMap.this.containsKey(k);
            }

            public int size() {
                return AbstractLong2FloatMap.this.size();
            }

            public LongIterator longIterator() {
                return new AbstractLongIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2FloatMap.this.entrySet().iterator();
                    }

                    public long nextLong() {
                        return ((Long2FloatMap.Entry)this.i.next()).getLongKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractFloatCollection(){

            public boolean contains(float k) {
                return AbstractLong2FloatMap.this.containsValue(k);
            }

            public int size() {
                return AbstractLong2FloatMap.this.size();
            }

            public FloatIterator floatIterator() {
                return new AbstractFloatIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractLong2FloatMap.this.entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Long2FloatMap.Entry)this.i.next()).getFloatValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Long2FloatMap.Entry first = (Long2FloatMap.Entry)i.next();
            s.append(String.valueOf(first.getLongKey()));
            s.append("=>");
            s.append(String.valueOf(first.getFloatValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Long2FloatMap.Entry {
        protected long key;
        protected float value;

        public BasicEntry(Object key, Object value) {
            this.key = (Long)key;
            this.value = ((Float)value).floatValue();
        }

        public BasicEntry(long key, float value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return new Float(this.value);
        }

        public float getFloatValue() {
            return this.value;
        }

        public float setValue(float value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Float(this.setValue(((Float)value).floatValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Long)e.getKey() && this.value == ((Float)e.getValue()).floatValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ HashCommon.float2int(this.value);
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

