/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.longs;

import clover.it.unimi.dsi.fastutil.HashCommon;
import clover.it.unimi.dsi.fastutil.longs.AbstractLong2ReferenceSortedMap;
import clover.it.unimi.dsi.fastutil.longs.AbstractLongSortedSet;
import clover.it.unimi.dsi.fastutil.longs.Long2ReferenceMap;
import clover.it.unimi.dsi.fastutil.longs.Long2ReferenceSortedMap;
import clover.it.unimi.dsi.fastutil.longs.LongBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.longs.LongComparator;
import clover.it.unimi.dsi.fastutil.longs.LongIterator;
import clover.it.unimi.dsi.fastutil.longs.LongListIterator;
import clover.it.unimi.dsi.fastutil.longs.LongSet;
import clover.it.unimi.dsi.fastutil.longs.LongSortedSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.AbstractReferenceCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import clover.it.unimi.dsi.fastutil.objects.ReferenceCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Long2ReferenceRBTreeMap
extends AbstractLong2ReferenceSortedMap
implements Serializable,
Cloneable,
Long2ReferenceSortedMap {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected volatile transient ObjectSet entries;
    protected volatile transient LongSet keys;
    protected volatile transient ReferenceCollection values;
    protected transient boolean modified;
    protected Comparator storedComparator;
    protected transient LongComparator actualComparator;
    public static final long serialVersionUID = -7046029254386353129L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public Long2ReferenceRBTreeMap() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator == null || this.storedComparator instanceof LongComparator ? (LongComparator)this.storedComparator : new LongComparator(){

            public int compare(long k1, long k2) {
                return Long2ReferenceRBTreeMap.this.storedComparator.compare(new Long(k1), new Long(k2));
            }

            public int compare(Object ok1, Object ok2) {
                return Long2ReferenceRBTreeMap.this.storedComparator.compare(ok1, ok2);
            }
        };
    }

    public Long2ReferenceRBTreeMap(Comparator c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public Long2ReferenceRBTreeMap(Map m) {
        this();
        this.putAll(m);
    }

    public Long2ReferenceRBTreeMap(SortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    public Long2ReferenceRBTreeMap(Long2ReferenceMap m) {
        this();
        this.putAll((Map)m);
    }

    public Long2ReferenceRBTreeMap(Long2ReferenceSortedMap m) {
        this(m.comparator());
        this.putAll((Map)m);
    }

    public Long2ReferenceRBTreeMap(long[] k, Object[] v, Comparator c) {
        this(c);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Long2ReferenceRBTreeMap(long[] k, Object[] v) {
        this(k, v, null);
    }

    final int compare(long k1, long k2) {
        return this.actualComparator == null ? (k1 < k2 ? -1 : (k1 == k2 ? 0 : 1)) : this.actualComparator.compare(k1, k2);
    }

    final Entry findKey(long k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(long k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    /*
     * WARNING - void declaration
     */
    public Object put(long k, Object v) {
        this.modified = false;
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k, v);
            this.tree = this.firstEntry;
        } else {
            void e;
            Entry p = this.tree;
            int n = 0;
            while (true) {
                Entry oldValue;
                int cmp;
                if ((cmp = this.compare(k, p.key)) == 0) {
                    Object i = p.value;
                    p.value = v;
                    return i;
                }
                this.nodePath[n] = p;
                this.dirPath[n++] = cmp > 0;
                if (this.dirPath[n++]) {
                    if (p.succ()) {
                        ++this.count;
                        oldValue = new Entry(k, v);
                        if (p.right == null) {
                            this.lastEntry = oldValue;
                        }
                        oldValue.left = p;
                        oldValue.right = p.right;
                        p.right(oldValue);
                        break;
                    }
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    oldValue = new Entry(k, v);
                    if (p.left == null) {
                        this.firstEntry = oldValue;
                    }
                    oldValue.right = p;
                    oldValue.left = p.left;
                    p.left(oldValue);
                    break;
                }
                p = p.left;
            }
            this.modified = true;
            --e;
            while (e > 0 && !this.nodePath[e].black()) {
                Entry x;
                Entry i;
                if (!this.dirPath[e - true]) {
                    Entry x2;
                    i = this.nodePath[e - true].right;
                    if (!this.nodePath[e - true].succ() && !i.black()) {
                        this.nodePath[e].black(true);
                        i.black(true);
                        this.nodePath[e - true].black(false);
                        e -= 2;
                        continue;
                    }
                    if (!this.dirPath[e]) {
                        i = this.nodePath[e];
                    } else {
                        x2 = this.nodePath[e];
                        i = x2.right;
                        x2.right = i.left;
                        i.left = x2;
                        this.nodePath[e - true].left = i;
                        if (i.pred()) {
                            i.pred(false);
                            x2.succ(i);
                        }
                    }
                    x2 = this.nodePath[e - true];
                    x2.black(false);
                    i.black(true);
                    x2.left = i.right;
                    i.right = x2;
                    if (e < 2) {
                        this.tree = i;
                    } else if (this.dirPath[e - 2]) {
                        this.nodePath[e - 2].right = i;
                    } else {
                        this.nodePath[e - 2].left = i;
                    }
                    if (!i.succ()) break;
                    i.succ(false);
                    x2.pred(i);
                    break;
                }
                i = this.nodePath[e - true].left;
                if (!this.nodePath[e - true].pred() && !i.black()) {
                    this.nodePath[e].black(true);
                    i.black(true);
                    this.nodePath[e - true].black(false);
                    e -= 2;
                    continue;
                }
                if (this.dirPath[e]) {
                    i = this.nodePath[e];
                } else {
                    x = this.nodePath[e];
                    i = x.left;
                    x.left = i.right;
                    i.right = x;
                    this.nodePath[e - true].right = i;
                    if (i.succ()) {
                        i.succ(false);
                        x.pred(i);
                    }
                }
                x = this.nodePath[e - true];
                x.black(false);
                i.black(true);
                x.right = i.left;
                i.left = x;
                if (e < 2) {
                    this.tree = i;
                } else if (this.dirPath[e - 2]) {
                    this.nodePath[e - 2].right = i;
                } else {
                    this.nodePath[e - 2].left = i;
                }
                if (!i.pred()) break;
                i.pred(false);
                x.succ(i);
                break;
            }
        }
        this.tree.black(true);
        return this.defRetValue;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Object remove(long k) {
        void cmp;
        Entry p;
        block59: {
            void s;
            Entry j;
            boolean r;
            block65: {
                block60: {
                    Entry color;
                    block64: {
                        block62: {
                            block63: {
                                block57: {
                                    block58: {
                                        this.modified = false;
                                        if (this.tree == null) {
                                            return this.defRetValue;
                                        }
                                        p = this.tree;
                                        boolean bl = false;
                                        do {
                                            int i;
                                            if ((i = this.compare(k, p.key)) == 0) {
                                                if (p.left != null) break block57;
                                                break block58;
                                            }
                                            this.dirPath[cmp] = i > 0;
                                            this.nodePath[cmp] = p;
                                        } while (!(this.dirPath[++cmp] ? (p = p.right()) == null : (p = p.left()) == null));
                                        return this.defRetValue;
                                    }
                                    this.firstEntry = p.next();
                                }
                                if (p.right == null) {
                                    this.lastEntry = p.prev();
                                }
                                if (!p.succ()) break block62;
                                if (!p.pred()) break block63;
                                if (cmp == false) {
                                    this.tree = p.left;
                                    break block59;
                                } else if (this.dirPath[cmp - true]) {
                                    this.nodePath[cmp - true].succ(p.right);
                                    break block59;
                                } else {
                                    this.nodePath[cmp - true].pred(p.left);
                                }
                                break block59;
                            }
                            p.prev().right = p.right;
                            if (cmp == false) {
                                this.tree = p.left;
                                break block59;
                            } else if (this.dirPath[cmp - true]) {
                                this.nodePath[cmp - true].right = p.left;
                                break block59;
                            } else {
                                this.nodePath[cmp - true].left = p.left;
                            }
                            break block59;
                        }
                        Entry entry = p.right;
                        if (!entry.pred()) break block64;
                        entry.left = p.left;
                        entry.pred(p.pred());
                        if (!entry.pred()) {
                            entry.prev().right = entry;
                        }
                        if (cmp == false) {
                            this.tree = entry;
                        } else if (this.dirPath[cmp - true]) {
                            this.nodePath[cmp - true].right = entry;
                        } else {
                            this.nodePath[cmp - true].left = entry;
                        }
                        r = entry.black();
                        color.black(p.black());
                        p.black(r);
                        this.dirPath[cmp] = true;
                        this.nodePath[cmp++] = color;
                        break block59;
                    }
                    void var8_9 = cmp++;
                    while (true) {
                        this.dirPath[cmp] = false;
                        this.nodePath[cmp++] = color;
                        j = color.left;
                        if (j.pred()) {
                            this.dirPath[s] = true;
                            this.nodePath[s] = j;
                            if (j.succ()) {
                                break;
                            }
                            break block60;
                        }
                        color = j;
                    }
                    color.pred(j);
                    break block65;
                }
                color.left = j.right;
            }
            j.left = p.left;
            if (!p.pred()) {
                p.prev().right = j;
                j.pred(false);
            }
            j.right(p.right);
            r = j.black();
            j.black(p.black());
            p.black(r);
            if (s == false) {
                this.tree = j;
            } else if (this.dirPath[s - true]) {
                this.nodePath[s - true].right = j;
            } else {
                this.nodePath[s - true].left = j;
            }
        }
        if (p.black()) {
            while (cmp > 0) {
                block61: {
                    Entry y;
                    Entry w;
                    if (this.dirPath[cmp - true] && !this.nodePath[cmp - true].succ() || !this.dirPath[cmp - true] && !this.nodePath[cmp - true].pred()) {
                        Entry r;
                        Entry entry = r = this.dirPath[cmp - true] ? this.nodePath[cmp - true].right : this.nodePath[cmp - true].left;
                        if (!r.black()) {
                            r.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[cmp - true]) {
                        Entry r = this.nodePath[cmp - true].right;
                        if (!r.black()) {
                            r.black(true);
                            this.nodePath[cmp - true].black(false);
                            this.nodePath[cmp - true].right = r.left;
                            r.left = this.nodePath[cmp - true];
                            if (cmp < 2) {
                                this.tree = r;
                            } else if (this.dirPath[cmp - 2]) {
                                this.nodePath[cmp - 2].right = r;
                            } else {
                                this.nodePath[cmp - 2].left = r;
                            }
                            this.nodePath[cmp] = this.nodePath[cmp - true];
                            this.dirPath[cmp] = false;
                            this.nodePath[cmp - true] = r;
                            r = this.nodePath[++cmp - true].right;
                        }
                        if ((r.pred() || r.left.black()) && (r.succ() || r.right.black())) {
                            r.black(false);
                            break block61;
                        } else {
                            if (r.succ() || r.right.black()) {
                                w = r.left;
                                w.black(true);
                                y.black(false);
                                y.left = w.right;
                                w.right = y;
                                y = this.nodePath[cmp - true].right = w;
                                if (y.succ()) {
                                    y.succ(false);
                                    y.right.pred(y);
                                }
                            }
                            y.black(this.nodePath[cmp - true].black());
                            this.nodePath[cmp - true].black(true);
                            y.right.black(true);
                            this.nodePath[cmp - true].right = y.left;
                            y.left = this.nodePath[cmp - true];
                            if (cmp < 2) {
                                this.tree = y;
                            } else if (this.dirPath[cmp - 2]) {
                                this.nodePath[cmp - 2].right = y;
                            } else {
                                this.nodePath[cmp - 2].left = y;
                            }
                            if (!y.pred()) break;
                            y.pred(false);
                            this.nodePath[cmp - true].succ(y);
                            break;
                        }
                    }
                    y = this.nodePath[cmp - true].left;
                    if (!y.black()) {
                        y.black(true);
                        this.nodePath[cmp - true].black(false);
                        this.nodePath[cmp - true].left = y.right;
                        y.right = this.nodePath[cmp - true];
                        if (cmp < 2) {
                            this.tree = y;
                        } else if (this.dirPath[cmp - 2]) {
                            this.nodePath[cmp - 2].right = y;
                        } else {
                            this.nodePath[cmp - 2].left = y;
                        }
                        this.nodePath[cmp] = this.nodePath[cmp - true];
                        this.dirPath[cmp] = true;
                        this.nodePath[cmp - true] = y;
                        y = this.nodePath[++cmp - true].left;
                    }
                    if ((y.pred() || y.left.black()) && (y.succ() || y.right.black())) {
                        y.black(false);
                    } else {
                        void var7_8;
                        if (y.pred() || y.left.black()) {
                            w = y.right;
                            w.black(true);
                            y.black(false);
                            y.right = w.left;
                            w.left = y;
                            y = this.nodePath[cmp - true].left = w;
                            if (y.pred()) {
                                y.pred(false);
                                y.left.succ(y);
                            }
                        }
                        var7_8.black(this.nodePath[cmp - true].black());
                        this.nodePath[cmp - true].black(true);
                        var7_8.left.black(true);
                        this.nodePath[cmp - true].left = var7_8.right;
                        var7_8.right = this.nodePath[cmp - true];
                        if (cmp < 2) {
                            this.tree = var7_8;
                        } else if (this.dirPath[cmp - 2]) {
                            this.nodePath[cmp - 2].right = var7_8;
                        } else {
                            this.nodePath[cmp - 2].left = var7_8;
                        }
                        if (!var7_8.succ()) break;
                        var7_8.succ(false);
                        this.nodePath[cmp - true].pred((Entry)var7_8);
                        break;
                    }
                }
                --cmp;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        this.modified = true;
        --this.count;
        return p.value;
    }

    public Object put(Object ok, Object ov) {
        Object oldValue = this.put((Long)ok, ov);
        return this.modified ? this.defRetValue : oldValue;
    }

    public Object remove(Object ok) {
        Object oldValue = this.remove((Long)ok);
        return this.modified ? oldValue : this.defRetValue;
    }

    public boolean containsValue(Object v) {
        ValueIterator i = new ValueIterator();
        int n = this.count;
        while (n-- != 0) {
            Object j = i.next();
            if (j != v) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.count = 0;
        this.tree = null;
        this.entries = null;
        this.values = null;
        this.keys = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    public boolean containsKey(long k) {
        return this.findKey(k) != null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object get(long k) {
        Entry e = this.findKey(k);
        return e == null ? this.defRetValue : e.value;
    }

    public Object get(Object ok) {
        Entry e = this.findKey((Long)ok);
        return e == null ? this.defRetValue : e.getValue();
    }

    public long firstLongKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    public long lastLongKey() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    public Object firstKey() {
        return new Long(this.firstLongKey());
    }

    public Object lastKey() {
        return new Long(this.lastLongKey());
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractObjectSet(){

                public ObjectIterator objectIterator() {
                    return new TreeIterator();
                }

                public boolean contains(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Long2ReferenceRBTreeMap.this.findKey((Long)e.getKey());
                    return ((Object)e).equals(f);
                }

                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry e = (Map.Entry)o;
                    Entry f = Long2ReferenceRBTreeMap.this.findKey((Long)e.getKey());
                    if (f != null) {
                        Long2ReferenceRBTreeMap.this.remove(f.key);
                    }
                    return f != null;
                }

                public int size() {
                    return Long2ReferenceRBTreeMap.this.count;
                }

                public void clear() {
                    Long2ReferenceRBTreeMap.this.clear();
                }
            };
        }
        return this.entries;
    }

    public Set keySet() {
        if (this.keys == null) {
            class KeySet
            extends AbstractLongSortedSet {
                KeySet() {
                }

                public LongIterator longIterator() {
                    return new KeyIterator();
                }

                public LongBidirectionalIterator iterator(long from) {
                    return new KeyIterator(from);
                }

                public Comparator comparator() {
                    return Long2ReferenceRBTreeMap.this.storedComparator;
                }

                public boolean contains(long k) {
                    return Long2ReferenceRBTreeMap.this.containsKey(k);
                }

                public boolean remove(long k) {
                    Long2ReferenceRBTreeMap.this.remove(k);
                    return Long2ReferenceRBTreeMap.this.modified;
                }

                public int size() {
                    return Long2ReferenceRBTreeMap.this.count;
                }

                public void clear() {
                    Long2ReferenceRBTreeMap.this.clear();
                }

                public long firstLong() {
                    return Long2ReferenceRBTreeMap.this.firstEntry.key;
                }

                public long lastLong() {
                    return Long2ReferenceRBTreeMap.this.lastEntry.key;
                }

                public LongSortedSet headSet(long to) {
                    return (LongSortedSet)Long2ReferenceRBTreeMap.this.headMap(to).keySet();
                }

                public LongSortedSet tailSet(long from) {
                    return (LongSortedSet)Long2ReferenceRBTreeMap.this.tailMap(from).keySet();
                }

                public LongSortedSet subSet(long from, long to) {
                    return (LongSortedSet)Long2ReferenceRBTreeMap.this.subMap(from, to).keySet();
                }
            }
            this.keys = new KeySet();
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractReferenceCollection(){

                public ObjectIterator objectIterator() {
                    return new ValueIterator();
                }

                public boolean contains(Object k) {
                    return Long2ReferenceRBTreeMap.this.containsValue(k);
                }

                public int size() {
                    return Long2ReferenceRBTreeMap.this.count;
                }

                public void clear() {
                    Long2ReferenceRBTreeMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Comparator comparator() {
        return this.storedComparator;
    }

    public Long2ReferenceSortedMap headMap(long to) {
        return new Submap(0L, true, to, false);
    }

    public Long2ReferenceSortedMap tailMap(long from) {
        return new Submap(from, false, 0L, true);
    }

    public Long2ReferenceSortedMap subMap(long from, long to) {
        return new Submap(from, false, to, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        Long2ReferenceRBTreeMap c;
        try {
            c = (Long2ReferenceRBTreeMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.allocatePaths();
        if (this.count != 0) {
            void q;
            void p;
            Entry entry = new Entry();
            Entry entry2 = new Entry();
            Entry rp = entry;
            p.left(this.tree);
            Entry rq = entry2;
            q.pred(null);
            while (true) {
                Entry e;
                if (!rp.pred()) {
                    e = (Entry)rp.left.clone();
                    e.pred(rq.left);
                    e.succ(rq);
                    rq.left(e);
                    rp = rp.left;
                    rq = rq.left;
                } else {
                    while (rp.succ()) {
                        rp = rp.right;
                        if (rp == null) {
                            rq.right = null;
                            c.firstEntry = c.tree = q.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        rq = rq.right;
                    }
                    rp = rp.right;
                    rq = rq.right;
                }
                if (rp.succ()) continue;
                e = (Entry)rp.right.clone();
                e.succ(rq.right);
                e.pred(rq);
                rq.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        TreeIterator i = new TreeIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            Entry e = (Entry)i.next();
            s.writeLong(e.key);
            s.writeObject(e.value);
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readLong(), s.readObject());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readLong(), s.readObject());
            top.black(true);
            top.right(new Entry(s.readLong(), s.readObject()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readLong();
        top.value = s.readObject();
        top.black(true);
        top.right(this.readTree(s, rightN, top, succ));
        if (n + 2 == (n + 2 & -(n + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private int checkTree(Entry e, int d, int D) {
        if (e == null) {
            return 0;
        }
        if (e.black()) {
            ++d;
        }
        if (e.left() != null) {
            D = this.checkTree(e.left(), d, D);
        }
        if (e.right() != null) {
            D = this.checkTree(e.right(), d, D);
        }
        if (e.left() == null && e.right() == null) {
            if (D == -1) {
                D = d;
            } else if (D != d) {
                throw new AssertionError((Object)("Mismatch between number of black nodes (" + D + " and " + d + ")"));
            }
        }
        return D;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private final class Submap
    extends AbstractLong2ReferenceSortedMap
    implements Serializable,
    Long2ReferenceSortedMap {
        long from;
        long to;
        boolean bottom;
        boolean top;
        protected volatile transient ObjectSet entries;
        protected volatile transient LongSet keys;
        protected volatile transient ReferenceCollection values;

        public Submap(long from, boolean bottom, long to, boolean top) {
            if (!bottom && !top && Long2ReferenceRBTreeMap.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start key (" + from + ") is larger than end key (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
            this.defRetValue = Long2ReferenceRBTreeMap.this.defRetValue;
        }

        public void clear() {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        final boolean in(long k) {
            return !(!this.bottom && Long2ReferenceRBTreeMap.this.compare(k, this.from) < 0 || !this.top && Long2ReferenceRBTreeMap.this.compare(k, this.to) >= 0);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new AbstractObjectSet(){

                    public ObjectIterator objectIterator() {
                        return new SubmapIterator();
                    }

                    public boolean contains(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Long2ReferenceRBTreeMap.this.findKey((Long)e.getKey());
                        return f != null && Submap.this.in(f.key) && ((Object)e).equals(f);
                    }

                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry e = (Map.Entry)o;
                        Entry f = Long2ReferenceRBTreeMap.this.findKey((Long)e.getKey());
                        if (f != null && Submap.this.in(f.key)) {
                            Submap.this.remove(f.key);
                        }
                        return f != null;
                    }

                    public int size() {
                        int c = 0;
                        Iterator i = this.iterator();
                        while (i.hasNext()) {
                            ++c;
                            i.next();
                        }
                        return c;
                    }

                    public boolean isEmpty() {
                        return !new SubmapIterator().hasNext();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.entries;
        }

        public Set keySet() {
            if (this.keys == null) {
                class KeySet
                extends AbstractLongSortedSet
                implements LongSortedSet {
                    KeySet() {
                    }

                    public LongIterator longIterator() {
                        return new SubmapKeyIterator();
                    }

                    public LongBidirectionalIterator iterator(long from) {
                        return new SubmapKeyIterator(from);
                    }

                    public Comparator comparator() {
                        return ((Submap)Submap.this).Long2ReferenceRBTreeMap.this.storedComparator;
                    }

                    public boolean contains(long k) {
                        return Submap.this.containsKey(k);
                    }

                    public boolean remove(long k) {
                        Submap.this.remove(k);
                        return ((Submap)Submap.this).Long2ReferenceRBTreeMap.this.modified;
                    }

                    public int size() {
                        return Submap.this.size();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }

                    public long firstLong() {
                        return Submap.this.firstEntry().key;
                    }

                    public long lastLong() {
                        return Submap.this.lastEntry().key;
                    }

                    public LongSortedSet headSet(long to) {
                        return (LongSortedSet)Submap.this.headMap(to).keySet();
                    }

                    public LongSortedSet tailSet(long from) {
                        return (LongSortedSet)Submap.this.tailMap(from).keySet();
                    }

                    public LongSortedSet subSet(long from, long to) {
                        return (LongSortedSet)Submap.this.subMap(from, to).keySet();
                    }
                }
                this.keys = new KeySet();
            }
            return this.keys;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new AbstractReferenceCollection(){

                    public ObjectIterator objectIterator() {
                        return new SubmapValueIterator();
                    }

                    public boolean contains(Object k) {
                        return Submap.this.containsValue(k);
                    }

                    public int size() {
                        return Submap.this.size();
                    }

                    public void clear() {
                        Submap.this.clear();
                    }
                };
            }
            return this.values;
        }

        public boolean containsKey(long k) {
            return this.in(k) && Long2ReferenceRBTreeMap.this.containsKey(k);
        }

        public boolean containsValue(Object v) {
            SubmapIterator i = new SubmapIterator();
            while (i.hasNext()) {
                Object ev = ((Entry)i.next()).value;
                if (ev != v) continue;
                return true;
            }
            return false;
        }

        public Object get(long k) {
            Entry e;
            return this.in(k) && (e = Long2ReferenceRBTreeMap.this.findKey(k)) != null ? e.value : this.defRetValue;
        }

        public Object get(Object ok) {
            Entry e;
            return this.in((Long)ok) && (e = Long2ReferenceRBTreeMap.this.findKey((Long)ok)) != null ? e.getValue() : this.defRetValue;
        }

        public Object put(long k, Object v) {
            Long2ReferenceRBTreeMap.this.modified = false;
            if (!this.in(k)) {
                throw new IllegalArgumentException("Key (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            Object oldValue = Long2ReferenceRBTreeMap.this.put(k, v);
            return Long2ReferenceRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        public Object put(Object ok, Object ov) {
            Object oldValue = this.put((Long)ok, ov);
            return Long2ReferenceRBTreeMap.this.modified ? this.defRetValue : oldValue;
        }

        public Object remove(long k) {
            Long2ReferenceRBTreeMap.this.modified = false;
            if (!this.in(k)) {
                return this.defRetValue;
            }
            Object oldValue = Long2ReferenceRBTreeMap.this.remove(k);
            return Long2ReferenceRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        public Object remove(Object ok) {
            Object oldValue = this.remove((Long)ok);
            return Long2ReferenceRBTreeMap.this.modified ? oldValue : this.defRetValue;
        }

        public int size() {
            SubmapIterator i = new SubmapIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            return n;
        }

        public boolean isEmpty() {
            return !new SubmapIterator().hasNext();
        }

        public Comparator comparator() {
            return Long2ReferenceRBTreeMap.this.storedComparator;
        }

        public Long2ReferenceSortedMap headMap(long to) {
            if (this.top) {
                return new Submap(this.from, this.bottom, to, false);
            }
            return Long2ReferenceRBTreeMap.this.compare(to, this.to) < 0 ? new Submap(this.from, this.bottom, to, false) : this;
        }

        public Long2ReferenceSortedMap tailMap(long from) {
            if (this.bottom) {
                return new Submap(from, false, this.to, this.top);
            }
            return Long2ReferenceRBTreeMap.this.compare(from, this.from) > 0 ? new Submap(from, false, this.to, this.top) : this;
        }

        public Long2ReferenceSortedMap subMap(long from, long to) {
            if (this.top && this.bottom) {
                return new Submap(from, false, to, false);
            }
            if (!this.top) {
                long l = to = Long2ReferenceRBTreeMap.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                long l = from = Long2ReferenceRBTreeMap.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Submap(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (Long2ReferenceRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = Long2ReferenceRBTreeMap.this.firstEntry;
            } else {
                e = Long2ReferenceRBTreeMap.this.locateKey(this.from);
                if (Long2ReferenceRBTreeMap.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && Long2ReferenceRBTreeMap.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (Long2ReferenceRBTreeMap.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = Long2ReferenceRBTreeMap.this.lastEntry;
            } else {
                e = Long2ReferenceRBTreeMap.this.locateKey(this.to);
                if (Long2ReferenceRBTreeMap.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && Long2ReferenceRBTreeMap.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        public long firstLongKey() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public long lastLongKey() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Object firstKey() {
            return new Long(this.firstLongKey());
        }

        public Object lastKey() {
            return new Long(this.lastLongKey());
        }

        private final class SubmapValueIterator
        extends SubmapIterator
        implements ObjectListIterator {
            private SubmapValueIterator() {
            }

            public Object next() {
                return this.nextEntry().value;
            }

            public Object previous() {
                return this.previousEntry().value;
            }

            public void set(Object v) {
                throw new UnsupportedOperationException();
            }

            public void add(Object v) {
                throw new UnsupportedOperationException();
            }
        }

        private final class SubmapKeyIterator
        extends SubmapIterator
        implements LongListIterator {
            public SubmapKeyIterator() {
            }

            public SubmapKeyIterator(long from) {
                super(from);
            }

            public long nextLong() {
                return this.nextEntry().key;
            }

            public long previousLong() {
                return this.previousEntry().key;
            }

            public Object next() {
                return new Long(this.nextEntry().key);
            }

            public Object previous() {
                return new Long(this.previousEntry().key);
            }

            public void set(long k) {
                throw new UnsupportedOperationException();
            }

            public void add(long k) {
                throw new UnsupportedOperationException();
            }
        }

        private class SubmapIterator
        extends TreeIterator {
            SubmapIterator() {
                this.next = Submap.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubmapIterator(long k) {
                this();
                if (this.next == null) return;
                if (!submap.bottom && submap.Long2ReferenceRBTreeMap.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!submap.top) {
                    this.prev = submap.lastEntry();
                    if (submap.Long2ReferenceRBTreeMap.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = submap.Long2ReferenceRBTreeMap.this.locateKey(k);
                if (submap.Long2ReferenceRBTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Submap.this.bottom && this.prev != null && Long2ReferenceRBTreeMap.this.compare(this.prev.key, Submap.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Submap.this.top && this.next != null && Long2ReferenceRBTreeMap.this.compare(this.next.key, Submap.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private final class ValueIterator
    extends TreeIterator
    implements ObjectListIterator {
        private ValueIterator() {
        }

        public Object next() {
            return this.nextEntry().value;
        }

        public Object previous() {
            return this.previousEntry().value;
        }

        public void set(Object v) {
            throw new UnsupportedOperationException();
        }

        public void add(Object v) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends TreeIterator
    implements LongListIterator {
        public KeyIterator() {
        }

        public KeyIterator(long k) {
            super(k);
        }

        public long nextLong() {
            return this.nextEntry().key;
        }

        public long previousLong() {
            return this.previousEntry().key;
        }

        public Object next() {
            return new Long(this.nextEntry().key);
        }

        public Object previous() {
            return new Long(this.previousEntry().key);
        }

        public void set(long k) {
            throw new UnsupportedOperationException();
        }

        public void add(long k) {
            throw new UnsupportedOperationException();
        }
    }

    private class TreeIterator
    extends AbstractObjectListIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        TreeIterator() {
            this.next = Long2ReferenceRBTreeMap.this.firstEntry;
        }

        TreeIterator(long k) {
            this.next = Long2ReferenceRBTreeMap.this.locateKey(k);
            if (this.next != null) {
                if (Long2ReferenceRBTreeMap.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        public Object next() {
            return this.nextEntry();
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public Object previous() {
            return this.previousEntry();
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            Long2ReferenceRBTreeMap.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry
    implements Cloneable,
    Long2ReferenceMap.Entry {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        long key;
        Object value;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Object k, Object v) {
            this.key = (Long)k;
            this.value = v;
            this.info = -1073741824;
        }

        Entry(long k, Object v) {
            this.key = k;
            this.value = v;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Object getKey() {
            return new Long(this.key);
        }

        public long getLongKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.value = this.value;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key == (Long)e.getKey() && this.value == e.getValue();
        }

        public int hashCode() {
            return HashCommon.long2int(this.key) ^ System.identityHashCode(this.value);
        }

        public String toString() {
            return this.key + "=>" + this.value;
        }
    }
}

