/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import clover.it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import clover.it.unimi.dsi.fastutil.ints.IntCollection;
import clover.it.unimi.dsi.fastutil.ints.IntIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import clover.it.unimi.dsi.fastutil.objects.Object2IntMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractObject2IntMap
implements Object2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractObject2IntMap() {
    }

    public void setDefRetValue(int rv) {
        this.defaultReturnValue(rv);
    }

    public int getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    public int defaultReturnValue() {
        return this.defRetValue;
    }

    public int put(Object key, int value) {
        throw new UnsupportedOperationException();
    }

    public int removeInt(Object key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        Object k = ok;
        return this.containsKey(k) ? new Integer(this.getInt(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        Object k = ok;
        int v = this.put(k, (Integer)ov);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public Object remove(Object ok) {
        Object k = ok;
        int v = this.removeInt(k);
        return this.containsKey(k) ? new Integer(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    public boolean containsValue(int v) {
        return ((IntCollection)this.values()).contains(v);
    }

    public boolean containsKey(Object k) {
        return ((ObjectSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Object2IntMap) {
            while (n-- != 0) {
                Object2IntMap.Entry e = (Object2IntMap.Entry)i.next();
                this.put(e.getKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractObjectSet(){

            public boolean contains(Object k) {
                return AbstractObject2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractObject2IntMap.this.size();
            }

            public ObjectIterator objectIterator() {
                return new AbstractObjectIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractObject2IntMap.this.entrySet().iterator();
                    }

                    public Object next() {
                        return ((Object2IntMap.Entry)this.i.next()).getKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractObject2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractObject2IntMap.this.size();
            }

            public IntIterator intIterator() {
                return new AbstractIntIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractObject2IntMap.this.entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Object2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean bl = true;
        s.append("{");
        while (n-- != 0) {
            if (bl) {
                bl = false;
            } else {
                s.append(", ");
            }
            Object2IntMap.Entry first = (Object2IntMap.Entry)i.next();
            if (this == first.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(first.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(first.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Object2IntMap.Entry {
        protected Object key;
        protected int value;

        public BasicEntry(Object key, Object value) {
            this.key = key;
            this.value = (Integer)value;
        }

        public BasicEntry(Object key, int value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return new Integer(this.value);
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Integer(this.setValue((Integer)value));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

