/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.objects.AbstractObjectListIterator;
import clover.it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import clover.it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectCollection;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterator;
import clover.it.unimi.dsi.fastutil.objects.ObjectIterators;
import clover.it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ObjectRBTreeSet
extends AbstractObjectSortedSet
implements Serializable,
Cloneable,
ObjectSortedSet {
    protected transient Entry tree;
    protected int count;
    protected transient Entry firstEntry;
    protected transient Entry lastEntry;
    protected Comparator storedComparator;
    protected transient Comparator actualComparator;
    public static final long serialVersionUID = -7046029254386353130L;
    private static final boolean ASSERTS = false;
    private transient boolean[] dirPath;
    private transient Entry[] nodePath;

    public ObjectRBTreeSet() {
        this.allocatePaths();
        this.tree = null;
        this.count = 0;
    }

    private void setActualComparator() {
        this.actualComparator = this.storedComparator;
    }

    public ObjectRBTreeSet(Comparator c) {
        this();
        this.storedComparator = c;
        this.setActualComparator();
    }

    public ObjectRBTreeSet(Collection c) {
        this();
        this.addAll(c);
    }

    public ObjectRBTreeSet(SortedSet s) {
        this(s.comparator());
        this.addAll((Collection)s);
    }

    public ObjectRBTreeSet(ObjectCollection c) {
        this();
        this.addAll((Collection)c);
    }

    public ObjectRBTreeSet(ObjectSortedSet s) {
        this(s.comparator());
        this.addAll((Collection)s);
    }

    public ObjectRBTreeSet(ObjectIterator i) {
        this.allocatePaths();
        while (i.hasNext()) {
            this.add(i.next());
        }
    }

    public ObjectRBTreeSet(Iterator i) {
        this(ObjectIterators.asObjectIterator(i));
    }

    public ObjectRBTreeSet(Object[] a, int offset, int length, Comparator c) {
        this(c);
        ObjectArrays.ensureOffsetLength(a, offset, length);
        for (int i = 0; i < length; ++i) {
            this.add(a[offset + i]);
        }
    }

    public ObjectRBTreeSet(Object[] a, int offset, int length) {
        this(a, offset, length, null);
    }

    public ObjectRBTreeSet(Object[] a) {
        this();
        int i = a.length;
        while (i-- != 0) {
            this.add(a[i]);
        }
    }

    public ObjectRBTreeSet(Object[] a, Comparator c) {
        this(c);
        int i = a.length;
        while (i-- != 0) {
            this.add(a[i]);
        }
    }

    final int compare(Object k1, Object k2) {
        return this.actualComparator == null ? ((Comparable)k1).compareTo(k2) : this.actualComparator.compare(k1, k2);
    }

    private Entry findKey(Object k) {
        int cmp;
        Entry e = this.tree;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            e = cmp < 0 ? e.left() : e.right();
        }
        return e;
    }

    final Entry locateKey(Object k) {
        Entry e = this.tree;
        Entry last = this.tree;
        int cmp = 0;
        while (e != null && (cmp = this.compare(k, e.key)) != 0) {
            last = e;
            e = cmp < 0 ? e.left() : e.right();
        }
        return cmp == 0 ? e : last;
    }

    private void allocatePaths() {
        this.dirPath = new boolean[64];
        this.nodePath = new Entry[64];
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(Object k) {
        if (this.tree == null) {
            ++this.count;
            this.lastEntry = this.firstEntry = new Entry(k);
            this.tree = this.firstEntry;
        } else {
            void e;
            Entry p = this.tree;
            int n = 0;
            while (true) {
                Entry i;
                int cmp;
                if ((cmp = this.compare(k, p.key)) == 0) {
                    return false;
                }
                this.nodePath[n] = p;
                this.dirPath[n++] = cmp > 0;
                if (this.dirPath[n++]) {
                    if (p.succ()) {
                        ++this.count;
                        i = new Entry(k);
                        if (p.right == null) {
                            this.lastEntry = i;
                        }
                        i.left = p;
                        i.right = p.right;
                        p.right(i);
                        break;
                    }
                    p = p.right;
                    continue;
                }
                if (p.pred()) {
                    ++this.count;
                    i = new Entry(k);
                    if (p.left == null) {
                        this.firstEntry = i;
                    }
                    i.right = p;
                    i.left = p.left;
                    p.left(i);
                    break;
                }
                p = p.left;
            }
            --e;
            while (e > 0 && !this.nodePath[e].black()) {
                Entry x;
                Entry y;
                if (!this.dirPath[e - true]) {
                    Entry x2;
                    y = this.nodePath[e - true].right;
                    if (!this.nodePath[e - true].succ() && !y.black()) {
                        this.nodePath[e].black(true);
                        y.black(true);
                        this.nodePath[e - true].black(false);
                        e -= 2;
                        continue;
                    }
                    if (!this.dirPath[e]) {
                        y = this.nodePath[e];
                    } else {
                        x2 = this.nodePath[e];
                        y = x2.right;
                        x2.right = y.left;
                        y.left = x2;
                        this.nodePath[e - true].left = y;
                        if (y.pred()) {
                            y.pred(false);
                            x2.succ(y);
                        }
                    }
                    x2 = this.nodePath[e - true];
                    x2.black(false);
                    y.black(true);
                    x2.left = y.right;
                    y.right = x2;
                    if (e < 2) {
                        this.tree = y;
                    } else if (this.dirPath[e - 2]) {
                        this.nodePath[e - 2].right = y;
                    } else {
                        this.nodePath[e - 2].left = y;
                    }
                    if (!y.succ()) break;
                    y.succ(false);
                    x2.pred(y);
                    break;
                }
                y = this.nodePath[e - true].left;
                if (!this.nodePath[e - true].pred() && !y.black()) {
                    this.nodePath[e].black(true);
                    y.black(true);
                    this.nodePath[e - true].black(false);
                    e -= 2;
                    continue;
                }
                if (this.dirPath[e]) {
                    y = this.nodePath[e];
                } else {
                    x = this.nodePath[e];
                    y = x.left;
                    x.left = y.right;
                    y.right = x;
                    this.nodePath[e - true].right = y;
                    if (y.succ()) {
                        y.succ(false);
                        x.pred(y);
                    }
                }
                x = this.nodePath[e - true];
                x.black(false);
                y.black(true);
                x.right = y.left;
                y.left = x;
                if (e < 2) {
                    this.tree = y;
                } else if (this.dirPath[e - 2]) {
                    this.nodePath[e - 2].right = y;
                } else {
                    this.nodePath[e - 2].left = y;
                }
                if (!y.pred()) break;
                y.pred(false);
                x.succ(y);
                break;
            }
        }
        this.tree.black(true);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean remove(Object k) {
        void cmp;
        Entry p;
        block59: {
            void s;
            Entry j;
            boolean r;
            block65: {
                block60: {
                    Entry color;
                    block64: {
                        block62: {
                            block63: {
                                block57: {
                                    block58: {
                                        if (this.tree == null) {
                                            return false;
                                        }
                                        p = this.tree;
                                        boolean bl = false;
                                        do {
                                            int i;
                                            if ((i = this.compare(k, p.key)) == 0) {
                                                if (p.left != null) break block57;
                                                break block58;
                                            }
                                            this.dirPath[cmp] = i > 0;
                                            this.nodePath[cmp] = p;
                                        } while (!(this.dirPath[++cmp] ? (p = p.right()) == null : (p = p.left()) == null));
                                        return false;
                                    }
                                    this.firstEntry = p.next();
                                }
                                if (p.right == null) {
                                    this.lastEntry = p.prev();
                                }
                                if (!p.succ()) break block62;
                                if (!p.pred()) break block63;
                                if (cmp == false) {
                                    this.tree = p.left;
                                    break block59;
                                } else if (this.dirPath[cmp - true]) {
                                    this.nodePath[cmp - true].succ(p.right);
                                    break block59;
                                } else {
                                    this.nodePath[cmp - true].pred(p.left);
                                }
                                break block59;
                            }
                            p.prev().right = p.right;
                            if (cmp == false) {
                                this.tree = p.left;
                                break block59;
                            } else if (this.dirPath[cmp - true]) {
                                this.nodePath[cmp - true].right = p.left;
                                break block59;
                            } else {
                                this.nodePath[cmp - true].left = p.left;
                            }
                            break block59;
                        }
                        Entry entry = p.right;
                        if (!entry.pred()) break block64;
                        entry.left = p.left;
                        entry.pred(p.pred());
                        if (!entry.pred()) {
                            entry.prev().right = entry;
                        }
                        if (cmp == false) {
                            this.tree = entry;
                        } else if (this.dirPath[cmp - true]) {
                            this.nodePath[cmp - true].right = entry;
                        } else {
                            this.nodePath[cmp - true].left = entry;
                        }
                        r = entry.black();
                        color.black(p.black());
                        p.black(r);
                        this.dirPath[cmp] = true;
                        this.nodePath[cmp++] = color;
                        break block59;
                    }
                    void var7_9 = cmp++;
                    while (true) {
                        this.dirPath[cmp] = false;
                        this.nodePath[cmp++] = color;
                        j = color.left;
                        if (j.pred()) {
                            this.dirPath[s] = true;
                            this.nodePath[s] = j;
                            if (j.succ()) {
                                break;
                            }
                            break block60;
                        }
                        color = j;
                    }
                    color.pred(j);
                    break block65;
                }
                color.left = j.right;
            }
            j.left = p.left;
            if (!p.pred()) {
                p.prev().right = j;
                j.pred(false);
            }
            j.right(p.right);
            r = j.black();
            j.black(p.black());
            p.black(r);
            if (s == false) {
                this.tree = j;
            } else if (this.dirPath[s - true]) {
                this.nodePath[s - true].right = j;
            } else {
                this.nodePath[s - true].left = j;
            }
        }
        if (p.black()) {
            while (cmp > 0) {
                block61: {
                    Entry y;
                    Entry w;
                    if (this.dirPath[cmp - true] && !this.nodePath[cmp - true].succ() || !this.dirPath[cmp - true] && !this.nodePath[cmp - true].pred()) {
                        Entry r;
                        Entry entry = r = this.dirPath[cmp - true] ? this.nodePath[cmp - true].right : this.nodePath[cmp - true].left;
                        if (!r.black()) {
                            r.black(true);
                            break;
                        }
                    }
                    if (!this.dirPath[cmp - true]) {
                        Entry r = this.nodePath[cmp - true].right;
                        if (!r.black()) {
                            r.black(true);
                            this.nodePath[cmp - true].black(false);
                            this.nodePath[cmp - true].right = r.left;
                            r.left = this.nodePath[cmp - true];
                            if (cmp < 2) {
                                this.tree = r;
                            } else if (this.dirPath[cmp - 2]) {
                                this.nodePath[cmp - 2].right = r;
                            } else {
                                this.nodePath[cmp - 2].left = r;
                            }
                            this.nodePath[cmp] = this.nodePath[cmp - true];
                            this.dirPath[cmp] = false;
                            this.nodePath[cmp - true] = r;
                            r = this.nodePath[++cmp - true].right;
                        }
                        if ((r.pred() || r.left.black()) && (r.succ() || r.right.black())) {
                            r.black(false);
                            break block61;
                        } else {
                            if (r.succ() || r.right.black()) {
                                w = r.left;
                                w.black(true);
                                y.black(false);
                                y.left = w.right;
                                w.right = y;
                                y = this.nodePath[cmp - true].right = w;
                                if (y.succ()) {
                                    y.succ(false);
                                    y.right.pred(y);
                                }
                            }
                            y.black(this.nodePath[cmp - true].black());
                            this.nodePath[cmp - true].black(true);
                            y.right.black(true);
                            this.nodePath[cmp - true].right = y.left;
                            y.left = this.nodePath[cmp - true];
                            if (cmp < 2) {
                                this.tree = y;
                            } else if (this.dirPath[cmp - 2]) {
                                this.nodePath[cmp - 2].right = y;
                            } else {
                                this.nodePath[cmp - 2].left = y;
                            }
                            if (!y.pred()) break;
                            y.pred(false);
                            this.nodePath[cmp - true].succ(y);
                            break;
                        }
                    }
                    y = this.nodePath[cmp - true].left;
                    if (!y.black()) {
                        y.black(true);
                        this.nodePath[cmp - true].black(false);
                        this.nodePath[cmp - true].left = y.right;
                        y.right = this.nodePath[cmp - true];
                        if (cmp < 2) {
                            this.tree = y;
                        } else if (this.dirPath[cmp - 2]) {
                            this.nodePath[cmp - 2].right = y;
                        } else {
                            this.nodePath[cmp - 2].left = y;
                        }
                        this.nodePath[cmp] = this.nodePath[cmp - true];
                        this.dirPath[cmp] = true;
                        this.nodePath[cmp - true] = y;
                        y = this.nodePath[++cmp - true].left;
                    }
                    if ((y.pred() || y.left.black()) && (y.succ() || y.right.black())) {
                        y.black(false);
                    } else {
                        void var6_8;
                        if (y.pred() || y.left.black()) {
                            w = y.right;
                            w.black(true);
                            y.black(false);
                            y.right = w.left;
                            w.left = y;
                            y = this.nodePath[cmp - true].left = w;
                            if (y.pred()) {
                                y.pred(false);
                                y.left.succ(y);
                            }
                        }
                        var6_8.black(this.nodePath[cmp - true].black());
                        this.nodePath[cmp - true].black(true);
                        var6_8.left.black(true);
                        this.nodePath[cmp - true].left = var6_8.right;
                        var6_8.right = this.nodePath[cmp - true];
                        if (cmp < 2) {
                            this.tree = var6_8;
                        } else if (this.dirPath[cmp - 2]) {
                            this.nodePath[cmp - 2].right = var6_8;
                        } else {
                            this.nodePath[cmp - 2].left = var6_8;
                        }
                        if (!var6_8.succ()) break;
                        var6_8.succ(false);
                        this.nodePath[cmp - true].pred((Entry)var6_8);
                        break;
                    }
                }
                --cmp;
            }
            if (this.tree != null) {
                this.tree.black(true);
            }
        }
        --this.count;
        return true;
    }

    public boolean contains(Object k) {
        return this.findKey(k) != null;
    }

    public void clear() {
        this.count = 0;
        this.tree = null;
        this.lastEntry = null;
        this.firstEntry = null;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Object first() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.firstEntry.key;
    }

    public Object last() {
        if (this.tree == null) {
            throw new NoSuchElementException();
        }
        return this.lastEntry.key;
    }

    public ObjectIterator objectIterator() {
        return new SetIterator();
    }

    public ObjectBidirectionalIterator iterator(Object from) {
        return new SetIterator(from);
    }

    public Comparator comparator() {
        return this.storedComparator;
    }

    public SortedSet headSet(Object to) {
        return new Subset(null, true, to, false);
    }

    public SortedSet tailSet(Object from) {
        return new Subset(from, false, null, true);
    }

    public SortedSet subSet(Object from, Object to) {
        return new Subset(from, false, to, false);
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        ObjectRBTreeSet c;
        try {
            c = (ObjectRBTreeSet)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.allocatePaths();
        if (this.count != 0) {
            void q;
            void p;
            Entry entry = new Entry();
            Entry entry2 = new Entry();
            Entry rp = entry;
            p.left(this.tree);
            Entry rq = entry2;
            q.pred(null);
            while (true) {
                Entry e;
                if (!rp.pred()) {
                    e = (Entry)rp.left.clone();
                    e.pred(rq.left);
                    e.succ(rq);
                    rq.left(e);
                    rp = rp.left;
                    rq = rq.left;
                } else {
                    while (rp.succ()) {
                        rp = rp.right;
                        if (rp == null) {
                            rq.right = null;
                            c.firstEntry = c.tree = q.left;
                            while (c.firstEntry.left != null) {
                                c.firstEntry = c.firstEntry.left;
                            }
                            c.lastEntry = c.tree;
                            while (c.lastEntry.right != null) {
                                c.lastEntry = c.lastEntry.right;
                            }
                            return c;
                        }
                        rq = rq.right;
                    }
                    rp = rp.right;
                    rq = rq.right;
                }
                if (rp.succ()) continue;
                e = (Entry)rp.right.clone();
                e.succ(rq.right);
                e.pred(rq);
                rq.right(e);
            }
        }
        return c;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int n = this.count;
        SetIterator i = new SetIterator();
        s.defaultWriteObject();
        while (n-- != 0) {
            s.writeObject(i.next());
        }
    }

    private Entry readTree(ObjectInputStream s, int n, Entry pred, Entry succ) throws IOException, ClassNotFoundException {
        if (n == 1) {
            Entry top = new Entry(s.readObject());
            top.pred(pred);
            top.succ(succ);
            top.black(true);
            return top;
        }
        if (n == 2) {
            Entry top = new Entry(s.readObject());
            top.black(true);
            top.right(new Entry(s.readObject()));
            top.right.pred(top);
            top.pred(pred);
            top.right.succ(succ);
            return top;
        }
        int rightN = n / 2;
        int leftN = n - rightN - 1;
        Entry top = new Entry();
        top.left(this.readTree(s, leftN, pred, top));
        top.key = s.readObject();
        top.black(true);
        top.right(this.readTree(s, rightN, top, succ));
        if (n + 2 == (n + 2 & -(n + 2))) {
            top.right.black(false);
        }
        return top;
    }

    private int checkTree(Entry e, int d, int D) {
        if (e == null) {
            return 0;
        }
        if (e.black()) {
            ++d;
        }
        if (e.left() != null) {
            D = this.checkTree(e.left(), d, D);
        }
        if (e.right() != null) {
            D = this.checkTree(e.right(), d, D);
        }
        if (e.left() == null && e.right() == null) {
            if (D == -1) {
                D = d;
            } else if (D != d) {
                throw new AssertionError((Object)("Mismatch between number of black nodes (" + D + " and " + d + ")"));
            }
        }
        return D;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActualComparator();
        this.allocatePaths();
        if (this.count != 0) {
            Entry e = this.tree = this.readTree(s, this.count, null, null);
            while (e.left() != null) {
                e = e.left();
            }
            this.firstEntry = e;
            e = this.tree;
            while (e.right() != null) {
                e = e.right();
            }
            this.lastEntry = e;
        }
    }

    private final class Subset
    extends AbstractObjectSortedSet
    implements Serializable,
    ObjectSortedSet {
        Object from;
        Object to;
        boolean bottom;
        boolean top;

        public Subset(Object from, boolean bottom, Object to, boolean top) {
            if (!bottom && !top && ObjectRBTreeSet.this.compare(from, to) > 0) {
                throw new IllegalArgumentException("Start element (" + from + ") is larger than end element (" + to + ")");
            }
            this.from = from;
            this.bottom = bottom;
            this.to = to;
            this.top = top;
        }

        public void clear() {
            SubsetIterator i = new SubsetIterator();
            while (i.hasNext()) {
                i.next();
                i.remove();
            }
        }

        final boolean in(Object k) {
            return !(!this.bottom && ObjectRBTreeSet.this.compare(k, this.from) < 0 || !this.top && ObjectRBTreeSet.this.compare(k, this.to) >= 0);
        }

        public boolean contains(Object k) {
            return this.in(k) && ObjectRBTreeSet.this.contains(k);
        }

        public boolean add(Object k) {
            if (!this.in(k)) {
                throw new IllegalArgumentException("Element (" + k + ") out of range [" + (this.bottom ? "-" : String.valueOf(this.from)) + ", " + (this.top ? "-" : String.valueOf(this.to)) + ")");
            }
            return ObjectRBTreeSet.this.add(k);
        }

        public boolean remove(Object k) {
            if (!this.in(k)) {
                return false;
            }
            return ObjectRBTreeSet.this.remove(k);
        }

        public int size() {
            SubsetIterator i = new SubsetIterator();
            int n = 0;
            while (i.hasNext()) {
                ++n;
                i.next();
            }
            return n;
        }

        public boolean isEmpty() {
            return !new SubsetIterator().hasNext();
        }

        public Comparator comparator() {
            return ObjectRBTreeSet.this.storedComparator;
        }

        public ObjectIterator objectIterator() {
            return new SubsetIterator();
        }

        public ObjectBidirectionalIterator iterator(Object from) {
            return new SubsetIterator(from);
        }

        public SortedSet headSet(Object to) {
            if (this.top) {
                return new Subset(this.from, this.bottom, to, false);
            }
            return ObjectRBTreeSet.this.compare(to, this.to) < 0 ? new Subset(this.from, this.bottom, to, false) : this;
        }

        public SortedSet tailSet(Object from) {
            if (this.bottom) {
                return new Subset(from, false, this.to, this.top);
            }
            return ObjectRBTreeSet.this.compare(from, this.from) > 0 ? new Subset(from, false, this.to, this.top) : this;
        }

        public SortedSet subSet(Object from, Object to) {
            if (this.top && this.bottom) {
                return new Subset(from, false, to, false);
            }
            if (!this.top) {
                Object object = to = ObjectRBTreeSet.this.compare(to, this.to) < 0 ? to : this.to;
            }
            if (!this.bottom) {
                Object object = from = ObjectRBTreeSet.this.compare(from, this.from) > 0 ? from : this.from;
            }
            if (!this.top && !this.bottom && from == this.from && to == this.to) {
                return this;
            }
            return new Subset(from, false, to, false);
        }

        public Entry firstEntry() {
            Entry e;
            if (ObjectRBTreeSet.this.tree == null) {
                return null;
            }
            if (this.bottom) {
                e = ObjectRBTreeSet.this.firstEntry;
            } else {
                e = ObjectRBTreeSet.this.locateKey(this.from);
                if (ObjectRBTreeSet.this.compare(e.key, this.from) < 0) {
                    e = e.next();
                }
            }
            if (e == null || !this.top && ObjectRBTreeSet.this.compare(e.key, this.to) >= 0) {
                return null;
            }
            return e;
        }

        public Entry lastEntry() {
            Entry e;
            if (ObjectRBTreeSet.this.tree == null) {
                return null;
            }
            if (this.top) {
                e = ObjectRBTreeSet.this.lastEntry;
            } else {
                e = ObjectRBTreeSet.this.locateKey(this.to);
                if (ObjectRBTreeSet.this.compare(e.key, this.to) >= 0) {
                    e = e.prev();
                }
            }
            if (e == null || !this.bottom && ObjectRBTreeSet.this.compare(e.key, this.from) < 0) {
                return null;
            }
            return e;
        }

        public Object first() {
            Entry e = this.firstEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        public Object last() {
            Entry e = this.lastEntry();
            if (e == null) {
                throw new NoSuchElementException();
            }
            return e.key;
        }

        private final class SubsetIterator
        extends SetIterator {
            SubsetIterator() {
                this.next = Subset.this.firstEntry();
            }

            /*
             * Enabled aggressive block sorting
             */
            SubsetIterator(Object k) {
                this();
                if (this.next == null) return;
                if (!subset.bottom && subset.ObjectRBTreeSet.this.compare(k, this.next.key) < 0) {
                    this.prev = null;
                    return;
                }
                if (!subset.top) {
                    this.prev = subset.lastEntry();
                    if (subset.ObjectRBTreeSet.this.compare(k, this.prev.key) >= 0) {
                        this.next = null;
                        return;
                    }
                }
                this.next = subset.ObjectRBTreeSet.this.locateKey(k);
                if (subset.ObjectRBTreeSet.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                    return;
                }
                this.prev = this.next.prev();
            }

            void updatePrevious() {
                this.prev = this.prev.prev();
                if (!Subset.this.bottom && this.prev != null && ObjectRBTreeSet.this.compare(this.prev.key, Subset.this.from) < 0) {
                    this.prev = null;
                }
            }

            void updateNext() {
                this.next = this.next.next();
                if (!Subset.this.top && this.next != null && ObjectRBTreeSet.this.compare(this.next.key, Subset.this.to) >= 0) {
                    this.next = null;
                }
            }
        }
    }

    private class SetIterator
    extends AbstractObjectListIterator {
        Entry prev;
        Entry next;
        Entry curr;
        int index = 0;

        SetIterator() {
            this.next = ObjectRBTreeSet.this.firstEntry;
        }

        SetIterator(Object k) {
            this.next = ObjectRBTreeSet.this.locateKey(k);
            if (this.next != null) {
                if (ObjectRBTreeSet.this.compare(this.next.key, k) <= 0) {
                    this.prev = this.next;
                    this.next = this.next.next();
                } else {
                    this.prev = this.next.prev();
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public boolean hasPrevious() {
            return this.prev != null;
        }

        void updateNext() {
            this.next = this.next.next();
        }

        Entry nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.curr = this.prev = this.next;
            ++this.index;
            this.updateNext();
            return this.curr;
        }

        public Object next() {
            return this.nextEntry().key;
        }

        public Object previous() {
            return this.previousEntry().key;
        }

        void updatePrevious() {
            this.prev = this.prev.prev();
        }

        Entry previousEntry() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.curr = this.next = this.prev;
            --this.index;
            this.updatePrevious();
            return this.curr;
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void remove() {
            if (this.curr == null) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
            }
            this.next = this.prev = this.curr;
            this.updatePrevious();
            this.updateNext();
            ObjectRBTreeSet.this.remove(this.curr.key);
            this.curr = null;
        }
    }

    private static final class Entry
    implements Cloneable {
        private static final int BLACK_MASK = 1;
        private static final int SUCC_MASK = Integer.MIN_VALUE;
        private static final int PRED_MASK = 0x40000000;
        Object key;
        Entry left;
        Entry right;
        int info;

        Entry() {
        }

        Entry(Object k) {
            this.key = k;
            this.info = -1073741824;
        }

        Entry left() {
            return (this.info & 0x40000000) != 0 ? null : this.left;
        }

        Entry right() {
            return (this.info & Integer.MIN_VALUE) != 0 ? null : this.right;
        }

        boolean pred() {
            return (this.info & 0x40000000) != 0;
        }

        boolean succ() {
            return (this.info & Integer.MIN_VALUE) != 0;
        }

        void pred(boolean pred) {
            this.info = pred ? (this.info |= 0x40000000) : (this.info &= 0xBFFFFFFF);
        }

        void succ(boolean succ) {
            this.info = succ ? (this.info |= Integer.MIN_VALUE) : (this.info &= Integer.MAX_VALUE);
        }

        void pred(Entry pred) {
            this.info |= 0x40000000;
            this.left = pred;
        }

        void succ(Entry succ) {
            this.info |= Integer.MIN_VALUE;
            this.right = succ;
        }

        void left(Entry left) {
            this.info &= 0xBFFFFFFF;
            this.left = left;
        }

        void right(Entry right) {
            this.info &= Integer.MAX_VALUE;
            this.right = right;
        }

        boolean black() {
            return (this.info & 1) != 0;
        }

        void black(boolean black) {
            this.info = black ? (this.info |= 1) : (this.info &= 0xFFFFFFFE);
        }

        Entry next() {
            Entry next = this.right;
            if ((this.info & Integer.MIN_VALUE) == 0) {
                while ((next.info & 0x40000000) == 0) {
                    next = next.left;
                }
            }
            return next;
        }

        Entry prev() {
            Entry prev = this.left;
            if ((this.info & 0x40000000) == 0) {
                while ((prev.info & Integer.MIN_VALUE) == 0) {
                    prev = prev.right;
                }
            }
            return prev;
        }

        public Object getKey() {
            return this.key;
        }

        public Object clone() {
            Entry c;
            try {
                c = (Entry)super.clone();
            }
            catch (CloneNotSupportedException cantHappen) {
                throw new InternalError();
            }
            c.key = this.key;
            c.info = this.info;
            return c;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key == null ? e.key == null : this.key.equals(e.key);
        }

        public int hashCode() {
            return this.key == null ? 0 : this.key.hashCode();
        }

        public String toString() {
            return "" + this.key;
        }
    }
}

