/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.needle;

import clover.org.jfree.chart.needle.MeterNeedle;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class PinNeedle
extends MeterNeedle
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3787089953079863373L;

    /*
     * WARNING - void declaration
     */
    protected void drawNeedle(Graphics2D g2, Rectangle2D plotArea, Point2D rotate, double angle) {
        void shape;
        GeneralPath generalPath = new GeneralPath();
        int pointer = (int)plotArea.getMinY();
        int minY = (int)plotArea.getMaxY();
        int maxY = (int)(plotArea.getMinX() + plotArea.getWidth() / 2.0);
        int midX = (int)(plotArea.getWidth() / 10.0);
        if (midX < 2) {
            midX = 2;
        }
        generalPath.moveTo(maxY - midX, minY - midX);
        generalPath.lineTo(maxY + midX, minY - midX);
        generalPath.lineTo(maxY, pointer + midX);
        generalPath.closePath();
        midX = 4 * midX;
        Ellipse2D.Double lenX = new Ellipse2D.Double(maxY - midX / 2, plotArea.getMaxY() - (double)midX, midX, midX);
        Area circle = new Area(lenX);
        circle.add(new Area((Shape)shape));
        if (rotate != null && angle != 0.0) {
            this.getTransform().setToRotation(angle, rotate.getX(), rotate.getY());
            circle.transform(this.getTransform());
        }
        this.defaultDisplay(g2, circle);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PinNeedle)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

