/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.plot;

import clover.org.jfree.chart.entity.PieSectionEntity;
import clover.org.jfree.chart.event.PlotChangeEvent;
import clover.org.jfree.chart.labels.PieToolTipGenerator;
import clover.org.jfree.chart.plot.PiePlot;
import clover.org.jfree.chart.plot.PiePlotState;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.PlotState;
import clover.org.jfree.data.general.DatasetUtilities;
import clover.org.jfree.data.general.PieDataset;
import clover.org.jfree.ui.RectangleInsets;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PiePlot3D
extends PiePlot
implements Serializable {
    private static final long serialVersionUID = 3408984188945161432L;
    private double depthFactor = 0.12;
    private boolean darkerSides = false;

    public PiePlot3D() {
        this(null);
    }

    public PiePlot3D(PieDataset dataset) {
        super(dataset);
        this.setCircular(false, false);
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setDepthFactor(double factor) {
        this.depthFactor = factor;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getDarkerSides() {
        return this.darkerSides;
    }

    public void setDarkerSides(boolean darker) {
        this.darkerSides = darker;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    /*
     * WARNING - void declaration
     */
    public void draw(Graphics2D g2, Rectangle2D plotArea, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        void lower;
        Object object;
        Object object2;
        Stroke stroke;
        Paint paint;
        Paint paint2;
        Object object3;
        int n;
        void top;
        void upper;
        void runningTotal;
        Serializable serializable;
        Object object4;
        void dataset;
        List list;
        void linkArea;
        void v1;
        void h1;
        void vv;
        RectangleInsets insets = this.getInsets();
        insets.trim(plotArea);
        Rectangle2D originalPlotArea = (Rectangle2D)plotArea.clone();
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        this.drawBackground(g2, plotArea);
        Shape savedClip = g2.getClip();
        g2.clip(plotArea);
        double gapPercent = this.getInteriorGap();
        double labelPercent = 0.0;
        if (this.getLabelGenerator() != null) {
            labelPercent = this.getLabelGap() + this.getMaximumLabelWidth();
        }
        double gapHorizontal = plotArea.getWidth() * (gapPercent + labelPercent) * 2.0;
        double gapVertical = plotArea.getHeight() * gapPercent * 2.0;
        double linkX = plotArea.getX() + gapHorizontal / 2.0;
        double linkY = plotArea.getY() + gapVertical / 2.0;
        double linkW = plotArea.getWidth() - gapHorizontal;
        double linkH = plotArea.getHeight() - gapVertical;
        if (this.isCircular()) {
            double min = Math.min(linkW, linkH) / 2.0;
            linkX = (linkX + linkX + linkW) / 2.0 - min;
            linkY = (linkY + linkY + linkH) / 2.0 - min;
            linkW = 2.0 * min;
            linkH = 2.0 * min;
        }
        PiePlotState piePlotState = this.initialise(g2, plotArea, this, null, info);
        Rectangle2D.Double double_ = new Rectangle2D.Double(linkX, linkY, linkW, linkH * (1.0 - this.depthFactor));
        piePlotState.setLinkArea(double_);
        double d = linkW * this.getLabelLinkMargin();
        double d2 = linkH * this.getLabelLinkMargin();
        Rectangle2D.Double double_2 = new Rectangle2D.Double(linkX + vv / 2.0, linkY + d2 / 2.0, linkW - vv, linkH - d2);
        piePlotState.setExplodedPieArea(double_2);
        double d3 = this.getMaximumExplodePercent();
        double d4 = d3 / (1.0 + d3);
        double d5 = ((RectangularShape)double_2).getWidth() * d4;
        double d6 = ((RectangularShape)double_2).getHeight() * h1;
        Rectangle2D.Double double_3 = new Rectangle2D.Double(((RectangularShape)double_2).getX() + v1 / 2.0, ((RectangularShape)double_2).getY() + d6 / 2.0, ((RectangularShape)double_2).getWidth() - v1, ((RectangularShape)double_2).getHeight() - d6);
        int n2 = (int)(((RectangularShape)double_3).getHeight() * this.depthFactor);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(linkX, linkY, linkW, linkH - (double)n2);
        piePlotState.setLinkArea(double_4);
        piePlotState.setPieArea((Rectangle2D)linkArea);
        piePlotState.setPieCenterX(linkArea.getCenterX());
        piePlotState.setPieCenterY(linkArea.getCenterY() - (double)n2 / 2.0);
        piePlotState.setPieWRadius(linkArea.getWidth() / 2.0);
        piePlotState.setPieHRadius((linkArea.getHeight() - (double)n2) / 2.0);
        PieDataset pieDataset = this.getDataset();
        if (DatasetUtilities.isEmptyOrNull(this.getDataset())) {
            this.drawNoDataMessage(g2, plotArea);
            g2.setClip(savedClip);
            this.drawOutline(g2, plotArea);
            return;
        }
        if ((double)pieDataset.getKeys().size() > plotArea.getWidth()) {
            void fm;
            String string = "Too many elements";
            Font font = new Font("dialog", 1, 10);
            g2.setFont(font);
            FontMetrics fontMetrics = g2.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth((String)fm);
            g2.drawString((String)fm, (int)(plotArea.getX() + (plotArea.getWidth() - (double)n3) / 2.0), (int)(plotArea.getY() + plotArea.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double d7 = Math.min(plotArea.getWidth(), plotArea.getHeight()) / 2.0;
            plotArea = new Rectangle2D.Double(plotArea.getCenterX() - d7, plotArea.getCenterY() - d7, 2.0 * d7, 2.0 * d7);
        }
        if ((list = pieDataset.getKeys()).size() == 0) {
            return;
        }
        double d8 = linkArea.getX();
        double d9 = linkArea.getY();
        Composite composite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double d10 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        double d11 = 0.0;
        if (dataset < 0) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d12;
            double d13;
            void dataValue;
            object4 = (Comparable)iterator.next();
            serializable = pieDataset.getValue((Comparable)object4);
            if (serializable == null) {
                dataValue.add(null);
                continue;
            }
            double d14 = ((Number)serializable).doubleValue();
            if (d14 <= 0.0) {
                dataValue.add(null);
                continue;
            }
            double d15 = this.getStartAngle();
            double d16 = d15 + (d13 = this.getDirection().getFactor()) * (d11 + d14) * 360.0 / d10;
            if (Math.abs(d16 - (d12 = d15 + d13 * (d11 * 360.0) / d10)) > this.getMinimumArcAngleToDraw()) {
                dataValue.add(new Arc2D.Double((double)runningTotal, d9 + (double)dataset, linkArea.getWidth(), linkArea.getHeight() - (double)dataset, d12, d16 - d12, 2));
            } else {
                dataValue.add(null);
            }
            d11 += d14;
        }
        object4 = g2.getClip();
        serializable = new Ellipse2D.Double(linkArea.getX(), linkArea.getY(), linkArea.getWidth(), linkArea.getHeight() - (double)dataset);
        Ellipse2D.Double double_5 = new Ellipse2D.Double(linkArea.getX(), linkArea.getY() + (double)dataset, linkArea.getWidth(), linkArea.getHeight() - (double)dataset);
        Rectangle2D.Double double_6 = new Rectangle2D.Double(((RectangularShape)((Object)serializable)).getX(), ((RectangularShape)((Object)serializable)).getCenterY(), linkArea.getWidth(), double_5.getMaxY() - ((RectangularShape)((Object)serializable)).getCenterY());
        Rectangle2D.Double double_7 = new Rectangle2D.Double(linkArea.getX(), ((RectangularShape)((Object)serializable)).getY(), linkArea.getWidth(), double_5.getCenterY() - ((RectangularShape)((Object)serializable)).getY());
        Area area = new Area((Shape)upper);
        area.add(new Area(double_6));
        Area area2 = new Area(double_5);
        area2.add(new Area(double_7));
        Area area3 = new Area(area);
        area3.intersect(area2);
        Area area4 = new Area(area3);
        area4.subtract(new Area((Shape)upper));
        Area area5 = new Area(area3);
        area5.subtract(new Area(double_5));
        Arc2D.Double double_8 = new Arc2D.Double((double)runningTotal, d9 + (double)dataset, linkArea.getWidth(), linkArea.getHeight() - (double)dataset, 0.0, 360.0, 2);
        int n4 = top.size();
        for (n = 0; n < n4; ++n) {
            double_8 = (Arc2D.Double)top.get(n);
            if (double_8 == null) continue;
            object3 = this.getSectionKey(n);
            paint2 = this.lookupSectionPaint((Comparable)object3, true);
            paint = this.lookupSectionOutlinePaint((Comparable)object3);
            stroke = this.lookupSectionOutlineStroke((Comparable)object3);
            g2.setPaint(paint2);
            g2.fill(double_8);
            g2.setPaint(paint);
            g2.setStroke(stroke);
            g2.draw(double_8);
            g2.setPaint(paint2);
            object2 = double_8.getStartPoint();
            int[] nArray = new int[]{(int)double_8.getCenterX(), (int)double_8.getCenterX(), (int)((Point2D)object2).getX(), (int)((Point2D)object2).getX()};
            int[] nArray2 = new int[]{(int)double_8.getCenterY(), (int)double_8.getCenterY() - dataset, (int)((Point2D)object2).getY() - dataset, (int)((Point2D)object2).getY()};
            object = new Polygon(nArray, nArray2, 4);
            g2.setPaint(Color.lightGray);
            g2.fill((Shape)object);
            g2.setPaint(paint);
            g2.setStroke(stroke);
            g2.draw((Shape)object);
            g2.setPaint(paint2);
        }
        g2.setPaint(Color.gray);
        g2.fill(area5);
        g2.fill(area4);
        n = 0;
        Iterator bottom = top.iterator();
        while (bottom.hasNext()) {
            object3 = (Arc2D)bottom.next();
            if (object3 != null) {
                object2 = this.getSectionKey(n);
                paint2 = this.lookupSectionPaint((Comparable)object2, true);
                paint = this.lookupSectionOutlinePaint((Comparable)object2);
                stroke = this.lookupSectionOutlineStroke((Comparable)object2);
                this.drawSide(g2, (Rectangle2D)linkArea, (Arc2D)object3, area4, area5, paint2, paint, stroke, false, true);
            }
            ++n;
        }
        n = 0;
        bottom = top.iterator();
        while (bottom.hasNext()) {
            object3 = (Arc2D)bottom.next();
            if (object3 != null) {
                object2 = this.getSectionKey(n);
                paint2 = this.lookupSectionPaint((Comparable)object2);
                paint = this.lookupSectionOutlinePaint((Comparable)object2);
                stroke = this.lookupSectionOutlineStroke((Comparable)object2);
                this.drawSide(g2, (Rectangle2D)linkArea, (Arc2D)object3, area4, area5, paint2, paint, stroke, true, false);
            }
            ++n;
        }
        g2.setClip((Shape)lower);
        for (int i = 0; i < n4; ++i) {
            void sectionKeys;
            Object object5;
            Object object6;
            double_8 = (Arc2D.Double)top.get(i);
            if (double_8 == null) continue;
            object3 = new Arc2D.Double((double)runningTotal, d9, linkArea.getWidth(), linkArea.getHeight() - (double)dataset, double_8.getAngleStart(), double_8.getAngleExtent(), 2);
            object = (Comparable)list.get(i);
            paint2 = this.lookupSectionPaint((Comparable)object, true);
            paint = this.lookupSectionOutlinePaint((Comparable)object);
            stroke = this.lookupSectionOutlineStroke((Comparable)object);
            g2.setPaint(paint2);
            g2.fill((Shape)object3);
            g2.setStroke(stroke);
            g2.setPaint(paint);
            g2.draw((Shape)object3);
            if (info != null && (object6 = info.getOwner().getEntityCollection()) != null) {
                object5 = null;
                PieToolTipGenerator pieToolTipGenerator = this.getToolTipGenerator();
                if (pieToolTipGenerator != null) {
                    object5 = pieToolTipGenerator.generateToolTip(pieDataset, (Comparable)object);
                }
                String string = null;
                if (this.getURLGenerator() != null) {
                    string = this.getURLGenerator().generateURL(pieDataset, (Comparable)object, this.getPieIndex());
                }
                PieSectionEntity pieSectionEntity = new PieSectionEntity((Shape)object3, pieDataset, this.getPieIndex(), i, (Comparable)object, (String)object5, string);
                object6.add(pieSectionEntity);
            }
            object6 = pieDataset.getKeys();
            object5 = new Rectangle2D.Double(originalPlotArea.getX(), originalPlotArea.getY(), originalPlotArea.getWidth(), originalPlotArea.getHeight() - (double)dataset);
            if (this.getSimpleLabels()) {
                this.drawSimpleLabels(g2, (List)object6, d10, (Rectangle2D)object5, (Rectangle2D)sectionKeys, piePlotState);
                continue;
            }
            this.drawLabels(g2, (List)object6, d10, (Rectangle2D)object5, (Rectangle2D)sectionKeys, piePlotState);
        }
        g2.setClip(savedClip);
        g2.setComposite(composite);
        this.drawOutline(g2, originalPlotArea);
    }

    /*
     * WARNING - void declaration
     */
    protected void drawSide(Graphics2D g2, Rectangle2D plotArea, Arc2D arc, Area front, Area back, Paint paint, Paint outlinePaint, Stroke outlineStroke, boolean drawFront, boolean drawBack) {
        if (this.getDarkerSides() && paint instanceof Color) {
            Color c = (Color)paint;
            c = c.darker();
            paint = c;
        }
        double d = arc.getAngleStart();
        double d2 = arc.getAngleExtent();
        double d3 = d + d2;
        g2.setStroke(outlineStroke);
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 > -180.0) {
                        if (drawFront) {
                            Area area = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), arc.getStartPoint().getX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                            area.intersect(front);
                            g2.setPaint(paint);
                            g2.fill(area);
                            g2.setPaint(outlinePaint);
                            g2.draw(area);
                        }
                    } else {
                        void side2;
                        Area area = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                        area.intersect(front);
                        Area area2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                        area2.intersect(front);
                        g2.setPaint(paint);
                        if (drawFront) {
                            g2.fill((Shape)side2);
                            g2.fill(area2);
                        }
                        if (drawBack) {
                            g2.fill(back);
                        }
                        g2.setPaint(outlinePaint);
                        if (drawFront) {
                            g2.draw((Shape)side2);
                            g2.draw(area2);
                        }
                        if (drawBack) {
                            g2.draw(back);
                        }
                    }
                } else {
                    Area side2;
                    if (drawBack) {
                        side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                        side2.intersect(back);
                        g2.setPaint(paint);
                        g2.fill(side2);
                        g2.setPaint(outlinePaint);
                        g2.draw(side2);
                    }
                    if (drawFront) {
                        side2 = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                        side2.intersect(front);
                        g2.setPaint(paint);
                        g2.fill(side2);
                        g2.setPaint(outlinePaint);
                        g2.draw(side2);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 > -180.0) {
                    if (drawBack) {
                        Area side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), arc.getEndPoint().getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                        side2.intersect(back);
                        g2.setPaint(paint);
                        g2.fill(side2);
                        g2.setPaint(outlinePaint);
                        g2.draw(side2);
                    }
                } else {
                    Area side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    side2.intersect(back);
                    Area area = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    area.intersect(back);
                    g2.setPaint(paint);
                    if (drawBack) {
                        g2.fill(side2);
                        g2.fill(area);
                    }
                    if (drawFront) {
                        g2.fill(front);
                    }
                    g2.setPaint(outlinePaint);
                    if (drawBack) {
                        g2.draw(side2);
                        g2.draw(area);
                    }
                    if (drawFront) {
                        g2.draw(front);
                    }
                }
            } else {
                Area side2;
                if (drawBack) {
                    side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    side2.intersect(back);
                    g2.setPaint(paint);
                    g2.fill(side2);
                    g2.setPaint(outlinePaint);
                    g2.draw(side2);
                }
                if (drawFront) {
                    side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                    side2.intersect(front);
                    g2.setPaint(paint);
                    g2.fill(side2);
                    g2.setPaint(outlinePaint);
                    g2.draw(side2);
                }
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 < 180.0) {
                        if (drawFront) {
                            Area side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), arc.getEndPoint().getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                            side2.intersect(front);
                            g2.setPaint(paint);
                            g2.fill(side2);
                            g2.setPaint(outlinePaint);
                            g2.draw(side2);
                        }
                    } else {
                        Area side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                        side2.intersect(front);
                        Area area = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                        area.intersect(front);
                        g2.setPaint(paint);
                        if (drawFront) {
                            g2.fill(side2);
                            g2.fill(area);
                        }
                        if (drawBack) {
                            g2.fill(back);
                        }
                        g2.setPaint(outlinePaint);
                        if (drawFront) {
                            g2.draw(side2);
                            g2.draw(area);
                        }
                        if (drawBack) {
                            g2.draw(back);
                        }
                    }
                } else {
                    Area side2;
                    if (drawBack) {
                        side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                        side2.intersect(back);
                        g2.setPaint(paint);
                        g2.fill(side2);
                        g2.setPaint(outlinePaint);
                        g2.draw(side2);
                    }
                    if (drawFront) {
                        side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                        side2.intersect(front);
                        g2.setPaint(paint);
                        g2.fill(side2);
                        g2.setPaint(outlinePaint);
                        g2.draw(side2);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 < 180.0) {
                    if (drawBack) {
                        Area side2 = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), arc.getStartPoint().getX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                        side2.intersect(back);
                        g2.setPaint(paint);
                        g2.fill(side2);
                        g2.setPaint(outlinePaint);
                        g2.draw(side2);
                    }
                } else {
                    Area side2 = new Area(new Rectangle2D.Double(arc.getStartPoint().getX(), plotArea.getY(), plotArea.getX() - arc.getStartPoint().getX(), plotArea.getHeight()));
                    side2.intersect(back);
                    Area area = new Area(new Rectangle2D.Double(arc.getEndPoint().getX(), plotArea.getY(), plotArea.getMaxX() - arc.getEndPoint().getX(), plotArea.getHeight()));
                    area.intersect(back);
                    g2.setPaint(paint);
                    if (drawBack) {
                        g2.fill(side2);
                        g2.fill(area);
                    }
                    if (drawFront) {
                        g2.fill(front);
                    }
                    g2.setPaint(outlinePaint);
                    if (drawBack) {
                        g2.draw(side2);
                        g2.draw(area);
                    }
                    if (drawFront) {
                        g2.draw(front);
                    }
                }
            } else {
                Area area;
                if (drawBack) {
                    area = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getStartPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    area.intersect(back);
                    g2.setPaint(paint);
                    g2.fill(area);
                    g2.setPaint(outlinePaint);
                    g2.draw(area);
                }
                if (drawFront) {
                    area = new Area(new Rectangle2D.Double(plotArea.getX(), plotArea.getY(), arc.getEndPoint().getX() - plotArea.getX(), plotArea.getHeight()));
                    area.intersect(front);
                    g2.setPaint(paint);
                    g2.fill(area);
                    g2.setPaint(outlinePaint);
                    g2.draw(area);
                }
            }
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_3D_Plot");
    }

    private boolean isAngleAtFront(double angle) {
        return Math.sin(Math.toRadians(angle)) < 0.0;
    }

    private boolean isAngleAtBack(double angle) {
        return Math.sin(Math.toRadians(angle)) > 0.0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PiePlot3D)) {
            return false;
        }
        PiePlot3D that = (PiePlot3D)obj;
        if (this.depthFactor != that.depthFactor) {
            return false;
        }
        if (this.darkerSides != that.darkerSides) {
            return false;
        }
        return super.equals(obj);
    }
}

