/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.LegendItem;
import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.renderer.AreaRendererEndType;
import clover.org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class AreaRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -4231878281385812757L;
    private AreaRendererEndType endType = AreaRendererEndType.TAPER;

    public AreaRendererEndType getEndType() {
        return this.endType;
    }

    public void setEndType(AreaRendererEndType type) {
        if (type == null) {
            throw new IllegalArgumentException("Null 'type' argument.");
        }
        this.endType = type;
        this.fireChangeEvent();
    }

    public LegendItem getLegendItem(int datasetIndex, int series) {
        String label;
        CategoryPlot cp = this.getPlot();
        if (cp == null) {
            return null;
        }
        if (!this.isSeriesVisible(series) || !this.isSeriesVisibleInLegend(series)) {
            return null;
        }
        CategoryDataset dataset = cp.getDataset(datasetIndex);
        String description = label = this.getLegendItemLabelGenerator().generateLabel(dataset, series);
        String toolTipText = null;
        if (this.getLegendItemToolTipGenerator() != null) {
            toolTipText = this.getLegendItemToolTipGenerator().generateLabel(dataset, series);
        }
        String urlText = null;
        if (this.getLegendItemURLGenerator() != null) {
            urlText = this.getLegendItemURLGenerator().generateLabel(dataset, series);
        }
        Rectangle2D.Double shape = new Rectangle2D.Double(-4.0, -4.0, 8.0, 8.0);
        Paint paint = this.lookupSeriesPaint(series);
        Paint outlinePaint = this.lookupSeriesOutlinePaint(series);
        Stroke outlineStroke = this.lookupSeriesOutlineStroke(series);
        LegendItem result = new LegendItem(label, description, toolTipText, urlText, (Shape)shape, paint, outlineStroke, outlinePaint);
        result.setDataset(dataset);
        result.setDatasetIndex(datasetIndex);
        result.setSeriesKey(dataset.getRowKey(series));
        result.setSeriesIndex(series);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        if (!this.getItemVisible(row, column)) {
            return;
        }
        Number value = dataset.getValue(row, column);
        if (value != null) {
            EntityCollection entityCollection;
            void yz;
            void y2;
            void y1;
            void area;
            void y0;
            Serializable serializable;
            Number n0;
            PlotOrientation orientation = plot.getOrientation();
            RectangleEdge axisEdge = plot.getDomainAxisEdge();
            int count = dataset.getColumnCount();
            float x0 = (float)domainAxis.getCategoryStart(column, count, dataArea, axisEdge);
            float x1 = (float)domainAxis.getCategoryMiddle(column, count, dataArea, axisEdge);
            float x2 = (float)domainAxis.getCategoryEnd(column, count, dataArea, axisEdge);
            x0 = Math.round(x0);
            x1 = Math.round(x1);
            x2 = Math.round(x2);
            if (this.endType == AreaRendererEndType.TRUNCATE) {
                if (column == 0) {
                    x0 = x1;
                } else if (column == this.getColumnCount() - 1) {
                    x2 = x1;
                }
            }
            double yy1 = value.doubleValue();
            double yy0 = 0.0;
            if (column > 0 && (n0 = dataset.getValue(row, column - 1)) != null) {
                yy0 = (n0.doubleValue() + yy1) / 2.0;
            }
            double d = 0.0;
            if (column < dataset.getColumnCount() - 1 && (serializable = dataset.getValue(row, column + 1)) != null) {
                d = (((Number)serializable).doubleValue() + yy1) / 2.0;
            }
            serializable = plot.getRangeAxisEdge();
            float f = (float)rangeAxis.valueToJava2D(yy0, dataArea, (RectangleEdge)serializable);
            float f2 = (float)rangeAxis.valueToJava2D(yy1, dataArea, (RectangleEdge)y0);
            float f3 = (float)rangeAxis.valueToJava2D(d, dataArea, (RectangleEdge)y0);
            float f4 = (float)rangeAxis.valueToJava2D(0.0, dataArea, (RectangleEdge)y0);
            g2.setPaint(this.getItemPaint(row, column));
            g2.setStroke(this.getItemStroke(row, column));
            GeneralPath generalPath = new GeneralPath();
            if (orientation == PlotOrientation.VERTICAL) {
                generalPath.moveTo(x0, (float)area);
                generalPath.lineTo(x0, (float)y1);
                generalPath.lineTo(x1, (float)y2);
                generalPath.lineTo(x2, (float)yz);
                generalPath.lineTo(x2, (float)area);
            } else if (orientation == PlotOrientation.HORIZONTAL) {
                generalPath.moveTo((float)area, x0);
                generalPath.lineTo((float)y1, x0);
                generalPath.lineTo((float)y2, x1);
                generalPath.lineTo((float)yz, x2);
                generalPath.lineTo((float)area, x2);
            }
            generalPath.closePath();
            g2.setPaint(this.getItemPaint(row, column));
            g2.fill(generalPath);
            if (this.isItemLabelVisible(row, column)) {
                this.drawItemLabel(g2, orientation, dataset, row, column, x1, (double)y2, value.doubleValue() < 0.0);
            }
            if ((entityCollection = state.getEntityCollection()) != null) {
                void entities;
                this.addItemEntity(entityCollection, dataset, row, column, (Shape)entities);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AreaRenderer)) {
            return false;
        }
        AreaRenderer that = (AreaRenderer)obj;
        if (!this.endType.equals(that.endType)) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

