/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.renderer.category.AreaRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.data.DataUtilities;
import clover.org.jfree.data.Range;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.data.general.DatasetUtilities;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class StackedAreaRenderer
extends AreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3595635038460823663L;
    private boolean renderAsPercentages;

    public StackedAreaRenderer() {
        this(false);
    }

    public StackedAreaRenderer(boolean renderAsPercentages) {
        this.renderAsPercentages = renderAsPercentages;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean asPercentages) {
        this.renderAsPercentages = asPercentages;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset dataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(dataset);
    }

    /*
     * WARNING - void declaration
     */
    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        float transStackLeft;
        float transStack1;
        void transY1;
        GeneralPath entityArea = null;
        EntityCollection entities = state.getEntityCollection();
        double y1 = 0.0;
        Number n = dataset.getValue(row, column);
        if (n != null) {
            y1 = n.doubleValue();
        }
        double[] stack1 = this.getStackValues(dataset, row, column);
        double xx1 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double y0 = 0.0;
        n = dataset.getValue(row, Math.max(column - 1, 0));
        if (n != null) {
            y0 = n.doubleValue();
        }
        double[] stack0 = this.getStackValues(dataset, row, Math.max(column - 1, 0));
        double xx0 = domainAxis.getCategoryStart(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        int itemCount = dataset.getColumnCount();
        double y2 = 0.0;
        n = dataset.getValue(row, Math.min(column + 1, itemCount - 1));
        if (n != null) {
            y2 = n.doubleValue();
        }
        double[] stack2 = this.getStackValues(dataset, row, Math.min(column + 1, itemCount - 1));
        double xx2 = domainAxis.getCategoryEnd(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge());
        double xxLeft = xx0;
        double xxRight = xx2;
        double[] stackLeft = this.averageStackValues(stack0, stack1);
        double[] stackRight = this.averageStackValues(stack1, stack2);
        double[] adjStackLeft = this.adjustedStackValues(stack0, stack1);
        double[] adjStackRight = this.adjustedStackValues(stack1, stack2);
        RectangleEdge rectangleEdge = plot.getRangeAxisEdge();
        GeneralPath edge1 = new GeneralPath();
        GeneralPath left = new GeneralPath();
        if (y1 >= 0.0) {
            void transYRight;
            float right = (float)rangeAxis.valueToJava2D(y1 + stack1[1], dataArea, rectangleEdge);
            transStack1 = (float)rangeAxis.valueToJava2D(stack1[1], dataArea, (RectangleEdge)transY1);
            transStackLeft = (float)rangeAxis.valueToJava2D(adjStackLeft[1], dataArea, (RectangleEdge)transY1);
            if (y0 >= 0.0) {
                double yleft = (y0 + y1) / 2.0 + stackLeft[1];
                float transYLeft = (float)rangeAxis.valueToJava2D(yleft, dataArea, (RectangleEdge)transY1);
                edge1.moveTo((float)xx1, right);
                edge1.lineTo((float)xx1, transStack1);
                edge1.lineTo((float)xxLeft, transStackLeft);
                edge1.lineTo((float)xxLeft, transYLeft);
                edge1.closePath();
            } else {
                edge1.moveTo((float)xx1, transStack1);
                edge1.lineTo((float)xx1, right);
                edge1.lineTo((float)xxLeft, transStackLeft);
                edge1.closePath();
            }
            float f = (float)rangeAxis.valueToJava2D(adjStackRight[1], dataArea, (RectangleEdge)transY1);
            if (y2 >= 0.0) {
                double d = (y1 + y2) / 2.0 + stackRight[1];
                float f2 = (float)rangeAxis.valueToJava2D(d, dataArea, (RectangleEdge)transY1);
                left.moveTo((float)xx1, transStack1);
                left.lineTo((float)xx1, right);
                left.lineTo((float)xxRight, f2);
                left.lineTo((float)xxRight, (float)transYRight);
                left.closePath();
            } else {
                left.moveTo((float)xx1, transStack1);
                left.lineTo((float)xx1, right);
                left.lineTo((float)xxRight, (float)transYRight);
                left.closePath();
            }
        } else {
            float right = (float)rangeAxis.valueToJava2D(y1 + stack1[0], dataArea, (RectangleEdge)transY1);
            transStack1 = (float)rangeAxis.valueToJava2D(stack1[0], dataArea, (RectangleEdge)transY1);
            transStackLeft = (float)rangeAxis.valueToJava2D(adjStackLeft[0], dataArea, (RectangleEdge)transY1);
            if (y0 >= 0.0) {
                edge1.moveTo((float)xx1, transStack1);
                edge1.lineTo((float)xx1, right);
                edge1.lineTo((float)xxLeft, transStackLeft);
                edge1.clone();
            } else {
                double yleft = (y0 + y1) / 2.0 + stackLeft[0];
                float transYLeft = (float)rangeAxis.valueToJava2D(yleft, dataArea, (RectangleEdge)transY1);
                edge1.moveTo((float)xx1, right);
                edge1.lineTo((float)xx1, transStack1);
                edge1.lineTo((float)xxLeft, transStackLeft);
                edge1.lineTo((float)xxLeft, transYLeft);
                edge1.closePath();
            }
            float transYRight = (float)rangeAxis.valueToJava2D(adjStackRight[0], dataArea, (RectangleEdge)transY1);
            if (y2 >= 0.0) {
                left.moveTo((float)xx1, transStack1);
                left.lineTo((float)xx1, right);
                left.lineTo((float)xxRight, transYRight);
                left.closePath();
            } else {
                double d = (y1 + y2) / 2.0 + stackRight[0];
                float f = (float)rangeAxis.valueToJava2D(d, dataArea, (RectangleEdge)transY1);
                left.moveTo((float)xx1, transStack1);
                left.lineTo((float)xx1, right);
                left.lineTo((float)xxRight, f);
                left.lineTo((float)xxRight, transYRight);
                left.closePath();
            }
        }
        g2.setPaint(this.getItemPaint(row, column));
        g2.setStroke(this.getItemStroke(row, column));
        Paint itemPaint = this.getItemPaint(row, column);
        if (pass == 0) {
            g2.setPaint(itemPaint);
            g2.fill(edge1);
            g2.fill(left);
        }
        if (entities != null) {
            GeneralPath gp = new GeneralPath(edge1);
            gp.append(left, false);
            entityArea = gp;
            this.addItemEntity(entities, dataset, row, column, entityArea);
        }
    }

    protected double getPreviousHeight(CategoryDataset dataset, int series, int category) {
        double result = 0.0;
        double d = 0.0;
        if (this.renderAsPercentages) {
            d = DataUtilities.calculateColumnTotal(dataset, category);
        }
        for (int i = 0; i < series; ++i) {
            Number i2 = dataset.getValue(i, category);
            if (i2 == null) continue;
            double v = i2.doubleValue();
            if (this.renderAsPercentages) {
                v /= d;
            }
            result += v;
        }
        return result;
    }

    protected double[] getStackValues(CategoryDataset dataset, int series, int index) {
        double[] result = new double[2];
        for (int i = 0; i < series; ++i) {
            if (!this.isSeriesVisible(i)) continue;
            double v = 0.0;
            Number n = dataset.getValue(i, index);
            if (n != null) {
                v = n.doubleValue();
            }
            if (Double.isNaN(v)) continue;
            if (v >= 0.0) {
                result[1] = result[1] + v;
                continue;
            }
            result[0] = result[0] + v;
        }
        return result;
    }

    private double[] averageStackValues(double[] stack1, double[] stack2) {
        double[] result = new double[]{(stack1[0] + stack2[0]) / 2.0, (stack1[1] + stack2[1]) / 2.0};
        return result;
    }

    private double[] adjustedStackValues(double[] stack1, double[] stack2) {
        double[] result = new double[]{stack1[0] == 0.0 || stack2[0] == 0.0 ? 0.0 : (stack1[0] + stack2[0]) / 2.0, stack1[1] == 0.0 || stack2[1] == 0.0 ? 0.0 : (stack1[1] + stack2[1]) / 2.0};
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackedAreaRenderer)) {
            return false;
        }
        StackedAreaRenderer that = (StackedAreaRenderer)obj;
        if (this.renderAsPercentages != that.renderAsPercentages) {
            return false;
        }
        return super.equals(obj);
    }
}

