/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.category;

import clover.org.jfree.chart.axis.CategoryAxis;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.CategoryItemLabelGenerator;
import clover.org.jfree.chart.labels.ItemLabelAnchor;
import clover.org.jfree.chart.labels.ItemLabelPosition;
import clover.org.jfree.chart.plot.CategoryPlot;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.renderer.category.BarRenderer;
import clover.org.jfree.chart.renderer.category.CategoryItemRendererState;
import clover.org.jfree.data.DataUtilities;
import clover.org.jfree.data.Range;
import clover.org.jfree.data.category.CategoryDataset;
import clover.org.jfree.data.general.DatasetUtilities;
import clover.org.jfree.ui.GradientPaintTransformer;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.ui.TextAnchor;
import clover.org.jfree.util.PublicCloneable;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class StackedBarRenderer
extends BarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    static final long serialVersionUID = 6402943811500067531L;
    private boolean renderAsPercentages;

    public StackedBarRenderer() {
        this(false);
    }

    public StackedBarRenderer(boolean renderAsPercentages) {
        this.renderAsPercentages = renderAsPercentages;
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(p);
        this.setBaseNegativeItemLabelPosition(p);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean asPercentages) {
        this.renderAsPercentages = asPercentages;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 2;
    }

    public Range findRangeBounds(CategoryDataset dataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(dataset, this.getBase());
    }

    protected void calculateBarWidth(CategoryPlot plot, Rectangle2D dataArea, int rendererIndex, CategoryItemRendererState state) {
        CategoryAxis xAxis = plot.getDomainAxisForDataset(rendererIndex);
        CategoryDataset data = plot.getDataset(rendererIndex);
        if (data != null) {
            PlotOrientation orientation = plot.getOrientation();
            double space = 0.0;
            if (orientation == PlotOrientation.HORIZONTAL) {
                space = dataArea.getHeight();
            } else if (orientation == PlotOrientation.VERTICAL) {
                space = dataArea.getWidth();
            }
            double maxWidth = space * this.getMaximumBarWidth();
            int columns = data.getColumnCount();
            double categoryMargin = 0.0;
            if (columns > 1) {
                categoryMargin = xAxis.getCategoryMargin();
            }
            double used = space * (1.0 - xAxis.getLowerMargin() - xAxis.getUpperMargin() - categoryMargin);
            if (columns > 0) {
                state.setBarWidth(Math.min(used / (double)columns, maxWidth));
            } else {
                state.setBarWidth(Math.min(used, maxWidth));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawItem(Graphics2D g2, CategoryItemRendererState state, Rectangle2D dataArea, CategoryPlot plot, CategoryAxis domainAxis, ValueAxis rangeAxis, CategoryDataset dataset, int row, int column, int pass) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        void barLength;
        void barL0;
        double translatedValue;
        double d;
        double positiveBase;
        Number dataValue = dataset.getValue(row, column);
        if (dataValue == null) {
            return;
        }
        double value = dataValue.doubleValue();
        double total = 0.0;
        if (this.renderAsPercentages) {
            total = DataUtilities.calculateColumnTotal(dataset, column);
            value /= total;
        }
        PlotOrientation orientation = plot.getOrientation();
        double barW0 = domainAxis.getCategoryMiddle(column, this.getColumnCount(), dataArea, plot.getDomainAxisEdge()) - state.getBarWidth() / 2.0;
        double negativeBase = positiveBase = this.getBase();
        for (int i = 0; i < row; ++i) {
            Number v = dataset.getValue(i, column);
            if (v == null) continue;
            double d2 = v.doubleValue();
            if (this.renderAsPercentages) {
                d2 /= total;
            }
            if (d2 > 0.0) {
                positiveBase += d2;
                continue;
            }
            negativeBase += d2;
        }
        RectangleEdge location = plot.getRangeAxisEdge();
        if (value >= 0.0) {
            d = rangeAxis.valueToJava2D(positiveBase, dataArea, location);
            translatedValue = rangeAxis.valueToJava2D(positiveBase + value, dataArea, location);
        } else {
            d = rangeAxis.valueToJava2D(negativeBase, dataArea, location);
            translatedValue = rangeAxis.valueToJava2D(negativeBase + value, dataArea, location);
        }
        double d3 = Math.min(d, translatedValue);
        double d4 = Math.max(Math.abs(translatedValue - barL0), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = orientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double((double)barLength, barW0, d4, state.getBarWidth()) : new Rectangle2D.Double(barW0, (double)barLength, state.getBarWidth(), d4);
        if (pass == 0) {
            EntityCollection entityCollection;
            void t;
            Paint paint = this.getItemPaint(row, column);
            GradientPaintTransformer gradientPaintTransformer = this.getGradientPaintTransformer();
            if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
                paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)t);
            }
            g2.setPaint(paint);
            g2.fill((Shape)t);
            if (this.isDrawBarOutline() && state.getBarWidth() > 3.0) {
                g2.setStroke(this.getItemOutlineStroke(row, column));
                g2.setPaint(this.getItemOutlinePaint(row, column));
                g2.draw((Shape)t);
            }
            if ((entityCollection = state.getEntityCollection()) != null) {
                this.addItemEntity(entityCollection, dataset, row, column, (Shape)t);
            }
        } else if (pass == 1 && (categoryItemLabelGenerator = this.getItemLabelGenerator(row, column)) != null && this.isItemLabelVisible(row, column)) {
            this.drawItemLabel(g2, dataset, row, column, plot, categoryItemLabelGenerator, double_, value < 0.0);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackedBarRenderer)) {
            return false;
        }
        StackedBarRenderer that = (StackedBarRenderer)obj;
        if (this.renderAsPercentages != that.renderAsPercentages) {
            return false;
        }
        return super.equals(obj);
    }
}

