/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.xy;

import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.ItemLabelAnchor;
import clover.org.jfree.chart.labels.ItemLabelPosition;
import clover.org.jfree.chart.labels.XYItemLabelGenerator;
import clover.org.jfree.chart.plot.CrosshairState;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.XYPlot;
import clover.org.jfree.chart.renderer.xy.XYBarRenderer;
import clover.org.jfree.chart.renderer.xy.XYItemRendererState;
import clover.org.jfree.data.Range;
import clover.org.jfree.data.general.DatasetUtilities;
import clover.org.jfree.data.xy.IntervalXYDataset;
import clover.org.jfree.data.xy.TableXYDataset;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.ui.TextAnchor;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class StackedXYBarRenderer
extends XYBarRenderer {
    private static final long serialVersionUID = -7049101055533436444L;
    private boolean renderAsPercentages = false;
    static /* synthetic */ Class class$org$jfree$data$xy$IntervalXYDataset;
    static /* synthetic */ Class class$org$jfree$data$xy$TableXYDataset;

    public StackedXYBarRenderer() {
        this(0.0);
    }

    public StackedXYBarRenderer(double margin) {
        super(margin);
        ItemLabelPosition p = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER);
        this.setBasePositiveItemLabelPosition(p);
        this.setBaseNegativeItemLabelPosition(p);
        this.setPositiveItemLabelPositionFallback(null);
        this.setNegativeItemLabelPositionFallback(null);
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean asPercentages) {
        this.renderAsPercentages = asPercentages;
        this.fireChangeEvent();
    }

    public int getPassCount() {
        return 2;
    }

    public XYItemRendererState initialise(Graphics2D g2, Rectangle2D dataArea, XYPlot plot, XYDataset data, PlotRenderingInfo info) {
        return new XYBarRenderer.XYBarRendererState(this, info);
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset != null) {
            if (this.renderAsPercentages) {
                return new Range(0.0, 1.0);
            }
            return DatasetUtilities.findStackedRangeBounds((TableXYDataset)dataset);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        void translatedHeight;
        void translatedEndX;
        double d;
        double d2;
        if (!(dataset instanceof IntervalXYDataset) || !(dataset instanceof TableXYDataset)) {
            String message = "dataset (type " + dataset.getClass().getName() + ") has wrong type:";
            boolean and = false;
            if (!(class$org$jfree$data$xy$IntervalXYDataset == null ? (class$org$jfree$data$xy$IntervalXYDataset = StackedXYBarRenderer.class$("clover.org.jfree.data.xy.IntervalXYDataset")) : class$org$jfree$data$xy$IntervalXYDataset).isAssignableFrom(dataset.getClass())) {
                message = message + " it is no IntervalXYDataset";
                and = true;
            }
            if (!(class$org$jfree$data$xy$TableXYDataset == null ? (class$org$jfree$data$xy$TableXYDataset = StackedXYBarRenderer.class$("clover.org.jfree.data.xy.TableXYDataset")) : class$org$jfree$data$xy$TableXYDataset).isAssignableFrom(dataset.getClass())) {
                if (and) {
                    message = message + " and";
                }
                message = message + " it is no TableXYDataset";
            }
            throw new IllegalArgumentException(message);
        }
        IntervalXYDataset intervalDataset = (IntervalXYDataset)dataset;
        double d3 = intervalDataset.getYValue(series, item);
        if (Double.isNaN(d3)) {
            return;
        }
        double d4 = 0.0;
        if (this.renderAsPercentages) {
            d4 = DatasetUtilities.calculateStackTotal((TableXYDataset)dataset, item);
            d3 /= d4;
        }
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < series; ++i) {
            double d7 = dataset.getYValue(i, item);
            if (Double.isNaN(d7)) continue;
            if (this.renderAsPercentages) {
                d7 /= d4;
            }
            if (d7 > 0.0) {
                d5 += d7;
                continue;
            }
            d6 += d7;
        }
        RectangleEdge edgeR = plot.getRangeAxisEdge();
        if (d3 > 0.0) {
            d2 = rangeAxis.valueToJava2D(d5, dataArea, edgeR);
            d = rangeAxis.valueToJava2D(d5 + d3, dataArea, edgeR);
        } else {
            d2 = rangeAxis.valueToJava2D(d6, dataArea, edgeR);
            d = rangeAxis.valueToJava2D(d6 + d3, dataArea, edgeR);
        }
        RectangleEdge rectangleEdge = plot.getDomainAxisEdge();
        double d8 = intervalDataset.getStartXValue(series, item);
        if (Double.isNaN(d8)) {
            return;
        }
        double d9 = domainAxis.valueToJava2D(d8, dataArea, rectangleEdge);
        double d10 = intervalDataset.getEndXValue(series, item);
        if (Double.isNaN(d10)) {
            return;
        }
        double d11 = domainAxis.valueToJava2D(d10, dataArea, rectangleEdge);
        double d12 = Math.max(1.0, Math.abs(d11 - translatedEndX));
        double d13 = Math.abs(d - d2);
        if (this.getMargin() > 0.0) {
            double d14 = d12 * this.getMargin();
            cut -= d14;
            translatedEndX += d14 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = plot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d2, d), (double)translatedHeight, d13, d12);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double((double)translatedEndX, Math.min(d2, d), d12, d13);
        }
        if (pass == 0) {
            Object object;
            Paint paint = this.getItemPaint(series, item);
            if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
                object = (GradientPaint)paint;
                paint = this.getGradientPaintTransformer().transform((GradientPaint)object, double_);
            }
            g2.setPaint(paint);
            g2.fill(double_);
            if (this.isDrawBarOutline() && Math.abs((double)(translatedHeight - translatedEndX)) > 3.0) {
                g2.setStroke(this.getItemStroke(series, item));
                g2.setPaint(this.getItemOutlinePaint(series, item));
                g2.draw(double_);
            }
            if (info != null && (object = info.getOwner().getEntityCollection()) != null) {
                this.addEntity((EntityCollection)object, double_, dataset, series, item, double_.getCenterX(), double_.getCenterY());
            }
        } else if (pass == 1 && this.isItemLabelVisible(series, item)) {
            XYItemLabelGenerator xYItemLabelGenerator = this.getItemLabelGenerator(series, item);
            this.drawItemLabel(g2, dataset, series, item, plot, xYItemLabelGenerator, double_, d3 < 0.0);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackedXYBarRenderer)) {
            return false;
        }
        StackedXYBarRenderer that = (StackedXYBarRenderer)obj;
        if (this.renderAsPercentages != that.renderAsPercentages) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = result * 37 + (this.renderAsPercentages ? 1 : 0);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

