/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.xy;

import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.plot.CrosshairState;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.XYPlot;
import clover.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import clover.org.jfree.chart.renderer.xy.XYItemRenderer;
import clover.org.jfree.chart.renderer.xy.XYItemRendererState;
import clover.org.jfree.data.xy.WindDataset;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class WindItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 8078914101916976844L;

    /*
     * WARNING - void declaration
     */
    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D plotArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        void ax2;
        WindDataset windData = (WindDataset)dataset;
        Paint seriesPaint = this.getItemPaint(series, item);
        Stroke seriesStroke = this.getItemStroke(series, item);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        Number x = windData.getX(series, item);
        Number windDir = windData.getWindDirection(series, item);
        Number wforce = windData.getWindForce(series, item);
        double windForce = wforce.doubleValue();
        double wdirt = Math.toRadians(windDir.doubleValue() * -30.0 - 90.0);
        RectangleEdge rectangleEdge = plot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = plot.getRangeAxisEdge();
        double d = domainAxis.valueToJava2D(x.doubleValue(), plotArea, rectangleEdge);
        double ay1 = rangeAxis.valueToJava2D(0.0, plotArea, rectangleEdge2);
        double d2 = x.doubleValue() + windForce * Math.cos(wdirt) * 8000000.0;
        double rax2 = windForce * Math.sin(wdirt);
        double ray2 = domainAxis.valueToJava2D(d2, plotArea, rectangleEdge);
        double d3 = rangeAxis.valueToJava2D(rax2, plotArea, rectangleEdge2);
        int diri = windDir.intValue();
        int forcei = wforce.intValue();
        String dirforce = diri + "-" + forcei;
        Line2D.Double line = new Line2D.Double((double)ax2, ay1, ray2, d3);
        g2.draw(line);
        g2.setPaint(Color.blue);
        g2.setFont(new Font("foo", 1, 9));
        g2.drawString(dirforce, (float)ax2, (float)ay1);
        g2.setPaint(seriesPaint);
        g2.setStroke(seriesStroke);
        double d4 = Math.toRadians(windDir.doubleValue() * -30.0 - 90.0 - 5.0);
        double d5 = wforce.doubleValue() * Math.cos(d4) * 8000000.0 * 0.8 + x.doubleValue();
        double d6 = wforce.doubleValue() * Math.sin(d4) * 0.8;
        double d7 = domainAxis.valueToJava2D(d5, plotArea, rectangleEdge);
        double ralx2 = rangeAxis.valueToJava2D(d6, plotArea, rectangleEdge2);
        line = new Line2D.Double(d7, ralx2, ray2, d3);
        g2.draw(line);
        double raly2 = Math.toRadians(windDir.doubleValue() * -30.0 - 90.0 + 5.0);
        double rarx2 = wforce.doubleValue() * Math.cos(raly2) * 8000000.0 * 0.8 + x.doubleValue();
        double rary2 = wforce.doubleValue() * Math.sin(raly2) * 0.8;
        double aldir = domainAxis.valueToJava2D(rarx2, plotArea, rectangleEdge);
        double ardir = rangeAxis.valueToJava2D(rary2, plotArea, rectangleEdge2);
        line = new Line2D.Double(aldir, ardir, ray2, d3);
        g2.draw(line);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

