/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.chart.renderer.xy;

import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.entity.EntityCollection;
import clover.org.jfree.chart.labels.BoxAndWhiskerXYToolTipGenerator;
import clover.org.jfree.chart.plot.CrosshairState;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.plot.PlotRenderingInfo;
import clover.org.jfree.chart.plot.XYPlot;
import clover.org.jfree.chart.renderer.Outlier;
import clover.org.jfree.chart.renderer.OutlierList;
import clover.org.jfree.chart.renderer.OutlierListCollection;
import clover.org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import clover.org.jfree.chart.renderer.xy.XYItemRenderer;
import clover.org.jfree.chart.renderer.xy.XYItemRendererState;
import clover.org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.io.SerialUtilities;
import clover.org.jfree.ui.RectangleEdge;
import clover.org.jfree.util.PaintUtilities;
import clover.org.jfree.util.PublicCloneable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class XYBoxAndWhiskerRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8020170108532232324L;
    private double boxWidth;
    private transient Paint boxPaint;
    private boolean fillBox;
    private transient Paint artifactPaint = Color.black;

    public XYBoxAndWhiskerRenderer() {
        this(-1.0);
    }

    public XYBoxAndWhiskerRenderer(double boxWidth) {
        this.boxWidth = boxWidth;
        this.boxPaint = Color.green;
        this.fillBox = true;
        this.setBaseToolTipGenerator(new BoxAndWhiskerXYToolTipGenerator());
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double width) {
        if (width != this.boxWidth) {
            this.boxWidth = width;
            this.fireChangeEvent();
        }
    }

    public Paint getBoxPaint() {
        return this.boxPaint;
    }

    public void setBoxPaint(Paint paint) {
        this.boxPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getFillBox() {
        return this.fillBox;
    }

    public void setFillBox(boolean flag) {
        this.fillBox = flag;
        this.fireChangeEvent();
    }

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.artifactPaint = paint;
        this.fireChangeEvent();
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        PlotOrientation orientation = plot.getOrientation();
        if (orientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(g2, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
        } else if (orientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(g2, dataArea, info, plot, domainAxis, rangeAxis, dataset, series, item, crosshairState, pass);
        }
    }

    public void drawHorizontalItem(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Paint p;
        double exactBoxWidth;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        BoxAndWhiskerXYDataset boxAndWhiskerData = (BoxAndWhiskerXYDataset)dataset;
        Number x = boxAndWhiskerData.getX(series, item);
        Number yMax = boxAndWhiskerData.getMaxRegularValue(series, item);
        Number yMin = boxAndWhiskerData.getMinRegularValue(series, item);
        Number yMedian = boxAndWhiskerData.getMedianValue(series, item);
        Number yAverage = boxAndWhiskerData.getMeanValue(series, item);
        Number yQ1Median = boxAndWhiskerData.getQ1Value(series, item);
        Number yQ3Median = boxAndWhiskerData.getQ3Value(series, item);
        double xx = domainAxis.valueToJava2D(x.doubleValue(), dataArea, plot.getDomainAxisEdge());
        RectangleEdge location = plot.getRangeAxisEdge();
        double yyMax = rangeAxis.valueToJava2D(yMax.doubleValue(), dataArea, location);
        double yyMin = rangeAxis.valueToJava2D(yMin.doubleValue(), dataArea, location);
        double yyMedian = rangeAxis.valueToJava2D(yMedian.doubleValue(), dataArea, location);
        double yyAverage = 0.0;
        if (yAverage != null) {
            yyAverage = rangeAxis.valueToJava2D(yAverage.doubleValue(), dataArea, location);
        }
        double yyQ1Median = rangeAxis.valueToJava2D(yQ1Median.doubleValue(), dataArea, location);
        double yyQ3Median = rangeAxis.valueToJava2D(yQ3Median.doubleValue(), dataArea, location);
        double width = exactBoxWidth = this.getBoxWidth();
        double dataAreaX = dataArea.getHeight();
        double maxBoxPercent = 0.1;
        double maxBoxWidth = dataAreaX * maxBoxPercent;
        if (exactBoxWidth <= 0.0) {
            int itemCount = boxAndWhiskerData.getItemCount(series);
            exactBoxWidth = dataAreaX / (double)itemCount * 4.5 / 7.0;
            width = exactBoxWidth < 3.0 ? 3.0 : (exactBoxWidth > maxBoxWidth ? maxBoxWidth : exactBoxWidth);
        }
        if ((p = this.getBoxPaint()) != null) {
            g2.setPaint(p);
        }
        Stroke s = this.getItemStroke(series, item);
        g2.setStroke(s);
        g2.draw(new Line2D.Double(yyMax, xx, yyQ3Median, xx));
        g2.draw(new Line2D.Double(yyMax, xx - width / 2.0, yyMax, xx + width / 2.0));
        g2.draw(new Line2D.Double(yyMin, xx, yyQ1Median, xx));
        g2.draw(new Line2D.Double(yyMin, xx - width / 2.0, yyMin, xx + width / 2.0));
        Rectangle2D.Double box = null;
        box = yyQ1Median < yyQ3Median ? new Rectangle2D.Double(yyQ1Median, xx - width / 2.0, yyQ3Median - yyQ1Median, width) : new Rectangle2D.Double(yyQ3Median, xx - width / 2.0, yyQ1Median - yyQ3Median, width);
        if (this.getBoxPaint() != null) {
            g2.setPaint(this.getBoxPaint());
        }
        if (this.fillBox) {
            g2.fill(box);
        }
        g2.draw(box);
        g2.setPaint(this.getArtifactPaint());
        g2.draw(new Line2D.Double(yyMedian, xx - width / 2.0, yyMedian, xx + width / 2.0));
        if (yAverage != null) {
            double aRadius = width / 4.0;
            Ellipse2D.Double avgEllipse = new Ellipse2D.Double(yyAverage - aRadius, xx - aRadius, aRadius * 2.0, aRadius * 2.0);
            g2.fill(avgEllipse);
            g2.draw(avgEllipse);
        }
        if (entities != null && box.intersects(dataArea)) {
            this.addEntity(entities, box, dataset, series, item, yyAverage, xx);
        }
    }

    public void drawVerticalItem(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        Cloneable cloneable;
        Paint paint;
        double d;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        BoxAndWhiskerXYDataset boxAndWhiskerData = (BoxAndWhiskerXYDataset)dataset;
        Number x = boxAndWhiskerData.getX(series, item);
        Number yMax = boxAndWhiskerData.getMaxRegularValue(series, item);
        Number yMin = boxAndWhiskerData.getMinRegularValue(series, item);
        Number yMedian = boxAndWhiskerData.getMedianValue(series, item);
        Number yAverage = boxAndWhiskerData.getMeanValue(series, item);
        Number yQ1Median = boxAndWhiskerData.getQ1Value(series, item);
        Number yQ3Median = boxAndWhiskerData.getQ3Value(series, item);
        List yOutliers = boxAndWhiskerData.getOutliers(series, item);
        double xx = domainAxis.valueToJava2D(x.doubleValue(), dataArea, plot.getDomainAxisEdge());
        RectangleEdge location = plot.getRangeAxisEdge();
        double yyMax = rangeAxis.valueToJava2D(yMax.doubleValue(), dataArea, location);
        double yyMin = rangeAxis.valueToJava2D(yMin.doubleValue(), dataArea, location);
        double yyMedian = rangeAxis.valueToJava2D(yMedian.doubleValue(), dataArea, location);
        double yyAverage = 0.0;
        if (yAverage != null) {
            yyAverage = rangeAxis.valueToJava2D(yAverage.doubleValue(), dataArea, location);
        }
        double yyQ1Median = rangeAxis.valueToJava2D(yQ1Median.doubleValue(), dataArea, location);
        double yyQ3Median = rangeAxis.valueToJava2D(yQ3Median.doubleValue(), dataArea, location);
        double exactBoxWidth = d = this.getBoxWidth();
        double width = dataArea.getMaxX() - dataArea.getMinX();
        double dataAreaX = 0.1;
        double maxBoxPercent = width * dataAreaX;
        if (d <= 0.0) {
            int n = boxAndWhiskerData.getItemCount(series);
            d = width / (double)n * 4.5 / 7.0;
            exactBoxWidth = d < 3.0 ? 3.0 : (d > maxBoxPercent ? maxBoxPercent : d);
        }
        if ((paint = this.getBoxPaint()) != null) {
            g2.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(series, item);
        g2.setStroke(stroke);
        g2.draw(new Line2D.Double(xx, yyMax, xx, yyQ3Median));
        g2.draw(new Line2D.Double(xx - exactBoxWidth / 2.0, yyMax, xx + exactBoxWidth / 2.0, yyMax));
        g2.draw(new Line2D.Double(xx, yyMin, xx, yyQ1Median));
        g2.draw(new Line2D.Double(xx - exactBoxWidth / 2.0, yyMin, xx + exactBoxWidth / 2.0, yyMin));
        Rectangle2D.Double p = null;
        p = yyQ1Median > yyQ3Median ? new Rectangle2D.Double(xx - exactBoxWidth / 2.0, yyQ3Median, exactBoxWidth, yyQ1Median - yyQ3Median) : new Rectangle2D.Double(xx - exactBoxWidth / 2.0, yyQ1Median, exactBoxWidth, yyQ3Median - yyQ1Median);
        if (this.fillBox) {
            g2.fill(p);
        }
        g2.draw(p);
        g2.setPaint(this.getArtifactPaint());
        g2.draw(new Line2D.Double(xx - exactBoxWidth / 2.0, yyMedian, xx + exactBoxWidth / 2.0, yyMedian));
        double d2 = 0.0;
        double aRadius = exactBoxWidth / 3.0;
        if (yAverage != null) {
            d2 = exactBoxWidth / 4.0;
            cloneable = new Ellipse2D.Double(xx - d2, yyAverage - d2, d2 * 2.0, d2 * 2.0);
            g2.fill((Shape)((Object)cloneable));
            g2.draw((Shape)((Object)cloneable));
        }
        cloneable = new ArrayList();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        for (int outliers = 0; outliers < yOutliers.size(); ++outliers) {
            double outlier;
            double d3 = ((Number)yOutliers.get(outliers)).doubleValue();
            if (d3 > boxAndWhiskerData.getMaxOutlier(series, item).doubleValue()) {
                outlierListCollection.setHighFarOut(true);
            } else if (d3 < boxAndWhiskerData.getMinOutlier(series, item).doubleValue()) {
                outlierListCollection.setLowFarOut(true);
            } else if (d3 > boxAndWhiskerData.getMaxRegularValue(series, item).doubleValue()) {
                outlier = rangeAxis.valueToJava2D(d3, dataArea, location);
                cloneable.add(new Outlier(xx, outlier, aRadius));
            } else if (d3 < boxAndWhiskerData.getMinRegularValue(series, item).doubleValue()) {
                outlier = rangeAxis.valueToJava2D(d3, dataArea, location);
                cloneable.add(new Outlier(xx, outlier, aRadius));
            }
            Collections.sort(cloneable);
        }
        Iterator outliers = cloneable.iterator();
        while (outliers.hasNext()) {
            Outlier outlier = (Outlier)outliers.next();
            outlierListCollection.add(outlier);
        }
        double d4 = rangeAxis.valueToJava2D(rangeAxis.getUpperBound(), dataArea, location) + d2;
        double d5 = rangeAxis.valueToJava2D(rangeAxis.getLowerBound(), dataArea, location) - d2;
        Iterator iterator = outlierListCollection.iterator();
        while (iterator.hasNext()) {
            OutlierList outlierList = (OutlierList)iterator.next();
            Outlier outlier = outlierList.getAveragedOutlier();
            Point2D point2D = outlier.getPoint();
            if (outlierList.isMultiple()) {
                this.drawMultipleEllipse(point2D, exactBoxWidth, aRadius, g2);
                continue;
            }
            this.drawEllipse(point2D, aRadius, g2);
        }
        if (outlierListCollection.isHighFarOut()) {
            this.drawHighFarOut(d2, g2, xx, d4);
        }
        if (outlierListCollection.isLowFarOut()) {
            this.drawLowFarOut(d2, g2, xx, d5);
        }
        if (entities != null && p.intersects(dataArea)) {
            this.addEntity(entities, p, dataset, series, item, xx, yyAverage);
        }
    }

    protected void drawEllipse(Point2D point, double oRadius, Graphics2D g2) {
        Ellipse2D.Double dot = new Ellipse2D.Double(point.getX() + oRadius / 2.0, point.getY(), oRadius, oRadius);
        g2.draw(dot);
    }

    protected void drawMultipleEllipse(Point2D point, double boxWidth, double oRadius, Graphics2D g2) {
        Ellipse2D.Double dot1 = new Ellipse2D.Double(point.getX() - boxWidth / 2.0 + oRadius, point.getY(), oRadius, oRadius);
        Ellipse2D.Double dot2 = new Ellipse2D.Double(point.getX() + boxWidth / 2.0, point.getY(), oRadius, oRadius);
        g2.draw(dot1);
        g2.draw(dot2);
    }

    protected void drawHighFarOut(double aRadius, Graphics2D g2, double xx, double m) {
        double side = aRadius * 2.0;
        g2.draw(new Line2D.Double(xx - side, m + side, xx + side, m + side));
        g2.draw(new Line2D.Double(xx - side, m + side, xx, m));
        g2.draw(new Line2D.Double(xx + side, m + side, xx, m));
    }

    protected void drawLowFarOut(double aRadius, Graphics2D g2, double xx, double m) {
        double side = aRadius * 2.0;
        g2.draw(new Line2D.Double(xx - side, m - side, xx + side, m - side));
        g2.draw(new Line2D.Double(xx - side, m - side, xx, m));
        g2.draw(new Line2D.Double(xx + side, m - side, xx, m));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof XYBoxAndWhiskerRenderer)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        XYBoxAndWhiskerRenderer that = (XYBoxAndWhiskerRenderer)obj;
        if (this.boxWidth != that.getBoxWidth()) {
            return false;
        }
        if (!PaintUtilities.equal(this.boxPaint, that.boxPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.artifactPaint, that.artifactPaint)) {
            return false;
        }
        return this.fillBox == that.fillBox;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtilities.writePaint(this.boxPaint, stream);
        SerialUtilities.writePaint(this.artifactPaint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.boxPaint = SerialUtilities.readPaint(stream);
        this.artifactPaint = SerialUtilities.readPaint(stream);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

