/*
 * Decompiled with CFR 0.152.
 */
package clover.org.jfree.data.contour;

import clover.org.jfree.data.Range;
import clover.org.jfree.data.contour.DefaultContourDataset;

public class NonGridContourDataset
extends DefaultContourDataset {
    static final int DEFAULT_NUM_X = 50;
    static final int DEFAULT_NUM_Y = 50;
    static final int DEFAULT_POWER = 4;

    public NonGridContourDataset() {
    }

    public NonGridContourDataset(String seriesName, Object[] xData, Object[] yData, Object[] zData) {
        super((Comparable)((Object)seriesName), xData, yData, zData);
        this.buildGrid(50, 50, 4);
    }

    public NonGridContourDataset(String seriesName, Object[] xData, Object[] yData, Object[] zData, int numX, int numY, int power) {
        super((Comparable)((Object)seriesName), xData, yData, zData);
        this.buildGrid(numX, numY, power);
    }

    /*
     * WARNING - void declaration
     */
    protected void buildGrid(int numX, int numY, int power) {
        int j;
        int n;
        double d;
        double yMax;
        int numValues = numX * numY;
        double[] xGrid = new double[numValues];
        double[] yGrid = new double[numValues];
        double[] zGrid = new double[numValues];
        double xMin = 1.0E20;
        for (int k = 0; k < this.xValues.length; ++k) {
            xMin = Math.min(xMin, this.xValues[k].doubleValue());
        }
        double d2 = -1.0E20;
        for (int i = 0; i < this.xValues.length; ++i) {
            d2 = Math.max(d2, this.xValues[i].doubleValue());
        }
        double d3 = 1.0E20;
        for (int i = 0; i < this.yValues.length; ++i) {
            d3 = Math.min(d3, this.yValues[i].doubleValue());
        }
        double d4 = -1.0E20;
        for (int i = 0; i < this.yValues.length; ++i) {
            d4 = Math.max(d4, this.yValues[i].doubleValue());
        }
        Range range = new Range(xMin, d2);
        Range range2 = new Range(yMax, d4);
        range.getLength();
        range2.getLength();
        double d5 = range.getLength() / (double)(numX - 1);
        double d6 = range2.getLength() / (double)(numY - 1);
        double d7 = 0.0;
        int n2 = 0;
        while (n2 < numX) {
            d7 = n2 == 0 ? xMin : (d7 += d5);
            d = 0.0;
            for (n = 0; n < numY; ++n) {
                void y;
                int n3 = numY * j + n;
                xGrid[n3] = y;
                d = n == 0 ? yMax : (d += d6);
                yGrid[n3] = d;
            }
            ++j;
        }
        j = 0;
        while (j < xGrid.length) {
            d = 0.0;
            zGrid[j] = 0.0;
            for (n = 0; n < this.xValues.length; ++n) {
                void k;
                double d8 = this.xValues[n].doubleValue();
                double d9 = this.yValues[n].doubleValue();
                double d10 = this.distance(d8, d9, xGrid[k], yGrid[k]);
                if (power != 1) {
                    d10 = Math.pow(d10, power);
                }
                d10 = (d10 = Math.sqrt(d10)) > 0.0 ? 1.0 / d10 : 1.0E20;
                if (this.zValues[n] != null) {
                    void v0 = k;
                    zGrid[v0] = zGrid[v0] + this.zValues[n].doubleValue() * d10;
                }
                xPt += d10;
            }
            zGrid[n2] = zGrid[n2] / d;
            ++n2;
        }
        this.initialize(NonGridContourDataset.formObjectArray(xGrid), NonGridContourDataset.formObjectArray(yGrid), NonGridContourDataset.formObjectArray(zGrid));
    }

    protected double distance(double xDataPt, double yDataPt, double xGrdPt, double yGrdPt) {
        double dx = xDataPt - xGrdPt;
        double dy = yDataPt - yGrdPt;
        return Math.sqrt(dx * dx + dy * dy);
    }
}

