/*
 * Decompiled with CFR 0.152.
 */
package clover_cenqua_com.atlassian.license.decoder;

import clover_cenqua_com.atlassian.license.DefaultLicense;
import clover_cenqua_com.atlassian.license.License;
import clover_cenqua_com.atlassian.license.LicenseException;
import clover_cenqua_com.atlassian.license.LicenseManager;
import clover_cenqua_com.atlassian.license.LicensePair;
import clover_cenqua_com.atlassian.license.LicenseType;
import clover_cenqua_com.atlassian.license.LicenseUtils;
import clover_cenqua_com.atlassian.license.util.Logger;
import clover_cenqua_com.atlassian.license.util.StringUtils;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.StringTokenizer;

public class LicenseDecoder {
    private static Logger.Log log = Logger.getInstance(LicenseDecoder.class);

    public static License getLicense(LicensePair pair, String applicationName) {
        try {
            return LicenseDecoder.loadLicense(pair, LicenseDecoder.getPublicKey(applicationName), applicationName);
        }
        catch (LicenseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isValid(LicensePair pair, String applicationName) {
        return LicenseDecoder.getLicense(pair, applicationName) != null;
    }

    private static PublicKey getPublicKey(String applicationName) throws LicenseException {
        String publicKeyFileName = LicenseDecoder.getPublicKeyFilename(applicationName);
        if (publicKeyFileName == null || "".equals(publicKeyFileName)) {
            throw new LicenseException("The filename for the public key is null. This must be set before a public key can be located.");
        }
        try {
            InputStream keyfis = Thread.currentThread().getContextClassLoader().getResourceAsStream(publicKeyFileName);
            if (keyfis == null) {
                keyfis = LicenseDecoder.class.getClassLoader().getResourceAsStream(publicKeyFileName);
            }
            byte[] encKey = LicenseUtils.readKey(keyfis);
            keyfis.close();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            log.error("Exception looking up public key: " + e.getMessage(), e);
            throw new LicenseException("Exception getting verification from file - possible classloader problem, or corrupt JIRA installation ");
        }
    }

    private static License loadLicense(LicensePair pair, PublicKey publicKey, String applicationName) {
        try {
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(pair.getLicense());
            if (signature.verify(pair.getHash())) {
                String messageString = LicenseDecoder.getDecodedMessage(pair.getLicense());
                StringTokenizer tokenizer = new StringTokenizer(messageString, "^");
                if (tokenizer.hasMoreTokens()) {
                    int licenseTypeCode = Integer.parseInt(tokenizer.nextToken());
                    LicenseType licenseType = LicenseManager.getInstance().getLicenseType(applicationName, licenseTypeCode);
                    Date dateCreated = new Date(Long.parseLong(tokenizer.nextToken()));
                    Date datePurchased = new Date(Long.parseLong(tokenizer.nextToken()));
                    Date dateExpires = null;
                    if (licenseType.expires()) {
                        dateExpires = new Date(Long.parseLong(tokenizer.nextToken()));
                    }
                    String organisation = tokenizer.nextToken();
                    String licenseId = LicenseDecoder.getLicenseIdFromLicenseString(pair.getOriginalLicenseString());
                    int users = -1;
                    int clusterCount = 0;
                    if (licenseType.requiresUserLimit()) {
                        String usersAndClustersLimits = tokenizer.nextToken();
                        String[] parts = usersAndClustersLimits.split("\\|");
                        if (parts.length != 1 && parts.length != 2) {
                            throw new LicenseException("License contained invalid user limit:" + usersAndClustersLimits);
                        }
                        users = Integer.parseInt(parts[0]);
                        if (parts.length == 2) {
                            clusterCount = Integer.parseInt(parts[1]);
                        }
                    }
                    String partnerName = null;
                    if (tokenizer.hasMoreTokens()) {
                        partnerName = tokenizer.nextToken();
                    }
                    return new DefaultLicense(dateCreated, datePurchased, dateExpires, organisation, licenseType, users, partnerName, licenseId, clusterCount);
                }
            } else {
                log.warn("Signature did not verify properly.");
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        return null;
    }

    private static String getLicenseIdFromLicenseString(String originalLicenseString) {
        if (originalLicenseString != null && originalLicenseString.length() > 70) {
            return StringUtils.replaceAll(StringUtils.replaceAll(StringUtils.replaceAll(originalLicenseString, "\n", ""), "\r", ""), "\t", "").substring(59, 69).toUpperCase();
        }
        return "";
    }

    private static String getDecodedMessage(byte[] message) {
        return new String(message);
    }

    public static boolean isValid(LicensePair pair, PublicKey publicKey, String applicationName) {
        return LicenseDecoder.loadLicense(pair, publicKey, applicationName) != null;
    }

    public static String getPublicKeyFilename(String applicationName) {
        return LicenseManager.getInstance().getLicenseTypeStore(applicationName).getPublicKeyFileName();
    }
}

