/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import com.cenqua.clover.CloverDatabaseSpec;
import com.cenqua.clover.CloverException;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.CoverageDataCollator;
import com.cenqua.clover.CoverageDataSpec;
import com.cenqua.clover.ProgressListener;
import com.cenqua.clover.context.ContextRegistry;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.HasMetricsFilter;
import com.cenqua.clover.registry.PackageInfo;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.Formatting;
import com.cenqua.clover.util.Path;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class CloverDatabase {
    private String initstring;
    private Clover2Registry registry;
    private CoverageDataCollator collator;
    private CoverageData data;
    private ProjectInfo testOnlyModel;
    private ProjectInfo appOnlyModel;

    public CloverDatabase(String initstring) throws CloverException {
        this(initstring, null, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name) throws CloverException {
        this(initstring, includeFilter, name, null);
    }

    public CloverDatabase(String initstring, HasMetricsFilter includeFilter, String name, String filterSpec) throws CloverException {
        this.initstring = initstring;
        try {
            this.registry = Clover2Registry.fromFile(new File(initstring), includeFilter);
            if (this.registry == null) {
                throw new CloverException("No database found at '" + initstring + "'");
            }
        }
        catch (IOException e) {
            throw new CloverException(e);
        }
        if (this.registry.isReadOnly()) {
            this.data = this.registry.getCoverageData();
        }
        if (this.data == null) {
            this.data = new CoverageData(this.registry.getModel().getDataLength());
        }
        this.collator = new CoverageDataCollator(this.registry);
        this.registry.getModel().setDataProvider(this.data);
        ContextSet filter = this.getContextSet(filterSpec);
        this.registry.getModel().setContextFilter(filter);
        if (name == null) {
            name = "Clover database " + Formatting.formatDate(new Date(this.registry.getVersion()));
        }
        this.registry.getModel().setName(name);
    }

    public CoverageData loadCoverageData() {
        return this.loadCoverageData(new CoverageDataSpec());
    }

    public CoverageData loadCoverageData(CoverageDataSpec spec) {
        if (!this.registry.isReadOnly()) {
            this.data = this.collator.loadCoverageData(spec);
        }
        if (spec.isResolve()) {
            this.data.resolve(this.registry);
        }
        if (!spec.isPreserveTestCaseCache()) {
            TestCaseInfo.Factory.reset();
        }
        this.registry.getModel().setHasTestResults(this.data.getTestCases().size() > 0);
        this.registry.getModel().setDataProvider(this.data);
        if (spec.getTestFilter() != null) {
            this.testOnlyModel = this.registry.getModel().copy(spec.getTestFilter());
            this.appOnlyModel = this.registry.getModel().copy(spec.getTestFilter().invert());
        }
        return this.data;
    }

    public String getInitstring() {
        return this.initstring;
    }

    public String getName() {
        return this.registry.getModel().getName();
    }

    public ProjectInfo getModel() {
        return this.getAppOnlyModel();
    }

    public ProjectInfo getTestOnlyModel() {
        return this.testOnlyModel;
    }

    public ProjectInfo getAppOnlyModel() {
        return this.appOnlyModel != null ? this.appOnlyModel : this.getFullModel();
    }

    public ProjectInfo getFullModel() {
        return this.registry.getModel();
    }

    public boolean isOutOfDate() {
        return this.registry.isOutOfDate() || this.collator.isOutOfDate();
    }

    public void resolve(Path sourcePath) {
        this.registry.getModel().resolve(sourcePath);
        if (this.appOnlyModel != null) {
            this.appOnlyModel.resolve(sourcePath);
        }
        if (this.testOnlyModel != null) {
            this.testOnlyModel.resolve(sourcePath);
        }
    }

    public ContextSet getContextSet(String spec) {
        return this.registry.getContextRegistry().createContextSetFilter(spec == null ? "" : spec);
    }

    public Set getTestHits(CoverageDataReceptor receptor) {
        ObjectOpenHashSet results = new ObjectOpenHashSet();
        Set[] sliceHits = this.data.getSliceHits();
        for (int i = receptor.getDataIndex(); i < receptor.getDataIndex() + receptor.getDataLength(); ++i) {
            if (sliceHits[i] == null) continue;
            results.addAll(sliceHits[i]);
        }
        return results;
    }

    public Set getTestHits(Collection receptors) {
        ObjectOpenHashSet results = new ObjectOpenHashSet();
        Set[] sliceHits = this.data.getSliceHits();
        Iterator iter = receptors.iterator();
        while (iter.hasNext()) {
            CoverageDataReceptor receptor = (CoverageDataReceptor)iter.next();
            for (int i = receptor.getDataIndex(); i < receptor.getDataIndex() + receptor.getDataLength(); ++i) {
                if (sliceHits[i] == null) continue;
                results.addAll(sliceHits[i]);
            }
        }
        return results;
    }

    public boolean hasTestHits(CoverageDataReceptor receptor) {
        Set[] sliceHits = this.data.getSliceHits();
        for (int i = receptor.getDataIndex(); i < receptor.getDataIndex() + receptor.getDataLength(); ++i) {
            if (sliceHits[i] == null) continue;
            return true;
        }
        return false;
    }

    public Clover2Registry getRegistry() {
        return this.registry;
    }

    public ContextRegistry getContextRegistry() {
        return this.registry.getContextRegistry();
    }

    public CoverageData getCoverageData() {
        return this.data;
    }

    public TestCaseInfo getTestCase(Integer id) {
        return this.data.getTestCase(id);
    }

    public int getNumRecordingsUsed() {
        return this.data.getNumRecordings();
    }

    public long getRecordingTimestamp() {
        return this.data.getTimestamp();
    }

    public static void merge(List dbspecs, String initString) throws CloverException, IOException {
        CloverDatabase.merge(dbspecs, initString, ProgressListener.NOOP_LISTENER);
    }

    public static void merge(List dbspecs, String initString, ProgressListener listener) throws CloverException, IOException {
        if (dbspecs.size() < 1) {
            throw new CloverException("need to specify a non-zero number of databases to merge");
        }
        Clover2Registry destReg = new Clover2Registry(new File(initString), "Merged Project");
        destReg.setVersion(System.currentTimeMillis());
        destReg.setReadOnly(true);
        ProjectInfo baseProject = destReg.getModel();
        int[] mergedCoverage = null;
        Set[] mergedSliceHits = null;
        int projectDataLength = 0;
        float progress = 0.0f;
        float progressInc = 0.8f / (float)dbspecs.size();
        int slotsUsed = 0;
        TestCaseInfo.Factory.reset();
        for (int i = 0; i < dbspecs.size(); ++i) {
            listener.handleProgress("merging database " + (i + 1) + " of " + dbspecs.size(), progress);
            CloverDatabaseSpec spec = (CloverDatabaseSpec)dbspecs.get(i);
            CloverDatabase mergingDb = new CloverDatabase(spec.getInitString());
            CoverageData mergingData = mergingDb.loadCoverageData(new CoverageDataSpec(null, spec.getSpan().getValueInMillis(), true, false, true));
            ProjectInfo mergingProject = mergingDb.getFullModel();
            if (mergedCoverage == null) {
                mergedCoverage = new int[mergingProject.getDataLength()];
                mergedSliceHits = new Set[mergingProject.getDataLength()];
            }
            List mergingFiles = mergingProject.getFiles(HasMetricsFilter.NO_OP);
            Iterator iterator = mergingFiles.iterator();
            while (iterator.hasNext()) {
                FileInfo mergeFI = (FileInfo)iterator.next();
                FileInfo baseFI = null;
                String mergePkgName = mergeFI.getContainingPackage().getName();
                PackageInfo basePkg = (PackageInfo)baseProject.getNamedPackage(mergePkgName);
                if (basePkg != null) {
                    baseFI = (FileInfo)basePkg.getFile(mergeFI.getPackagePath());
                }
                int newDataIndex = baseProject.getDataLength();
                int newDataLength = mergeFI.getDataLength();
                int oldDataIndex = mergeFI.getDataIndex();
                if (baseFI != null && baseFI.getFilesize() == mergeFI.getFilesize() && baseFI.getChecksum() == mergeFI.getChecksum()) {
                    newDataIndex = baseFI.getDataIndex();
                    newDataLength = baseFI.getDataLength();
                } else {
                    if (baseFI != null && baseFI.getTimestamp() >= mergeFI.getTimestamp()) continue;
                    mergeFI.setDataIndex(newDataIndex);
                    mergeFI.resetVersions(baseProject.getVersion());
                    if (basePkg == null) {
                        basePkg = new PackageInfo(baseProject, mergePkgName, newDataIndex);
                        baseProject.addPackage(basePkg);
                    }
                    basePkg.addFile(mergeFI);
                    projectDataLength = Math.max(projectDataLength, mergeFI.getDataIndex() + mergeFI.getDataLength());
                    baseProject.setDataLength(projectDataLength);
                    if (baseFI != null) {
                        slotsUsed -= baseFI.getDataLength();
                    }
                    slotsUsed += mergeFI.getDataLength();
                }
                mergedCoverage = CloverDatabase.addIntArrays(mergingData.getCoverage(), oldDataIndex, mergedCoverage, newDataIndex, newDataLength);
                mergedSliceHits = CloverDatabase.mergeSliceHitArrays(mergingData.getSliceHits(), oldDataIndex, mergedSliceHits, newDataIndex, newDataLength);
            }
            progress += progressInc;
        }
        int[] compactedCoverage = new int[slotsUsed];
        Set[] compactedSliceHits = new Set[slotsUsed];
        int insertPoint = 0;
        List mergedFiles = baseProject.getFiles(HasMetricsFilter.NO_OP);
        Iterator files = mergedFiles.iterator();
        while (files.hasNext()) {
            FileInfo fileInfo = (FileInfo)files.next();
            System.arraycopy(mergedCoverage, fileInfo.getDataIndex(), compactedCoverage, insertPoint, fileInfo.getDataLength());
            System.arraycopy(mergedSliceHits, fileInfo.getDataIndex(), compactedSliceHits, insertPoint, fileInfo.getDataLength());
            fileInfo.setDataIndex(insertPoint);
            insertPoint += fileInfo.getDataLength();
        }
        baseProject.setDataLength(slotsUsed);
        listener.handleProgress("Writing merged database registry", progress);
        destReg.setCoverageData(new CoverageData(System.currentTimeMillis(), compactedCoverage, compactedSliceHits, TestCaseInfo.Factory.getCacheValues()));
        destReg.store();
        TestCaseInfo.Factory.reset();
        listener.handleProgress("Merge complete", 1.0f);
    }

    private static Set[] mergeSliceHitArrays(Set[] src, int spos, Set[] dest, int dpos, int length) {
        if (dpos + length > dest.length) {
            Set[] tmp = new Set[dpos + length];
            for (int i = 0; i < dest.length; ++i) {
                Set di = dest[i];
                if (di == null) continue;
                tmp[i] = new ObjectOpenHashSet();
                tmp[i].addAll(di);
            }
            dest = tmp;
        }
        for (int i = 0; i < length; ++i) {
            Set s = src[spos + i];
            if (s == null) continue;
            Set d = dest[dpos + i];
            if (d == null) {
                dest[dpos + i] = new ObjectOpenHashSet();
                dest[dpos + i].addAll(s);
                continue;
            }
            ObjectOpenHashSet hits = new ObjectOpenHashSet(s);
            hits.addAll(d);
            dest[dpos + i] = hits;
        }
        return dest;
    }

    private static int[] addIntArrays(int[] src, int spos, int[] dest, int dpos, int length) {
        if (dpos + length > dest.length) {
            int[] tmp = new int[dpos + length];
            System.arraycopy(dest, 0, tmp, 0, dest.length);
            dest = tmp;
        }
        for (int i = 0; i < length; ++i) {
            int n = dpos + i;
            dest[n] = dest[n] + src[spos + i];
        }
        return dest;
    }
}

