/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.registry.Clover2Registry;
import com.cenqua.clover.registry.CoverageDataProvider;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.util.BitSetUtils;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class CoverageData
implements CoverageDataProvider,
Serializable {
    static final long serialVersionUID = -4833509864051626137L;
    private long timestamp;
    private int[] data;
    private Set[] sliceHits;
    private Set slices;
    private transient SortedMap sliceIDMap;
    private int numRecordings = 1;
    private transient Map hitMap;

    public CoverageData(int dataLength) {
        this.data = new int[dataLength];
        this.sliceHits = new Set[dataLength];
        this.slices = new HashSet();
    }

    public CoverageData(long timestamp, int[] data, Set[] sliceHits, Set slices) {
        this.timestamp = timestamp;
        this.data = data;
        this.sliceHits = sliceHits;
        this.slices = slices;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int[] getCoverage() {
        return this.data;
    }

    public int getCoverage(int index) {
        return this.data[index];
    }

    public Set[] getSliceHits() {
        return this.sliceHits;
    }

    public void resolve(Clover2Registry registry) {
        Iterator testcases = this.slices.iterator();
        while (testcases.hasNext()) {
            TestCaseInfo info = (TestCaseInfo)testcases.next();
            info.resolve(registry.getModel());
        }
    }

    public TestCaseInfo getTestCase(Integer testID) {
        if (this.sliceIDMap == null) {
            this.buildSliceIDMap();
        }
        return (TestCaseInfo)this.sliceIDMap.get(testID);
    }

    public int getNumRecordings() {
        return this.numRecordings;
    }

    public void setNumRecordings(int numRecordings) {
        this.numRecordings = numRecordings;
    }

    public CoverageDataProvider getPassOnlyCoverage() {
        if (this.hitMap == null) {
            this.buildHitMap();
        }
        Set allSlices = this.hitMap.keySet();
        HashSet<TestCaseInfo> passedTestSlices = new HashSet<TestCaseInfo>();
        Iterator iterator = allSlices.iterator();
        while (iterator.hasNext()) {
            TestCaseInfo testCase = (TestCaseInfo)iterator.next();
            if (testCase == null || !testCase.isSuccess()) continue;
            passedTestSlices.add(testCase);
        }
        BitSet passedTestCoverage = this.makeCoverageBitSetFor(passedTestSlices);
        BitSet allTestCoverage = this.makeCoverageBitSetFor(allSlices);
        BitSet allCoverage = BitSetUtils.fromIntArray(this.data);
        allCoverage.andNot(allTestCoverage);
        passedTestCoverage.or(allCoverage);
        return new BitSetCoverageProvider(passedTestCoverage);
    }

    public CoverageDataProvider getCoverageFrom(Set slices) {
        return this.getCoverageFrom(slices, null);
    }

    public CoverageDataProvider getCoverageFrom(Set slices, CoverageDataReceptor range) {
        BitSet coverage = this.makeCoverageBitSetFor(slices, range);
        return new BitSetCoverageProvider(coverage);
    }

    public CoverageDataProvider getUniqueCoverageFrom(Set targetSlices) {
        BitSet coverage = this.makeCoverageBitSetFor(targetSlices);
        HashSet otherSlices = new HashSet(this.slices);
        otherSlices.removeAll(targetSlices);
        BitSet otherCoverage = this.makeCoverageBitSetFor(otherSlices);
        coverage.andNot(otherCoverage);
        return new BitSetCoverageProvider(coverage);
    }

    private BitSet makeCoverageBitSetFor(Set slices) {
        return this.makeCoverageBitSetFor(slices, null);
    }

    private BitSet makeCoverageBitSetFor(Set slices, CoverageDataReceptor range) {
        if (this.hitMap == null) {
            this.buildHitMap();
        }
        BitSet coverage = new BitSet(this.data.length);
        int start = 0;
        int end = 0;
        if (range != null) {
            start = range.getDataIndex();
            end = start + range.getDataLength();
        }
        Iterator iterator = slices.iterator();
        while (iterator.hasNext()) {
            TestCaseInfo slice = (TestCaseInfo)iterator.next();
            BitSet hitsForSlice = (BitSet)this.hitMap.get(slice);
            if (hitsForSlice == null) continue;
            if (range != null) {
                int i = hitsForSlice.nextSetBit(start);
                while (i >= 0 && i < end) {
                    coverage.set(i);
                    i = hitsForSlice.nextSetBit(i + 1);
                }
                continue;
            }
            coverage.or(hitsForSlice);
        }
        return coverage;
    }

    private void buildSliceIDMap() {
        TreeMap<Integer, TestCaseInfo> tmp = new TreeMap<Integer, TestCaseInfo>();
        Iterator tcis = this.slices.iterator();
        while (tcis.hasNext()) {
            TestCaseInfo info = (TestCaseInfo)tcis.next();
            tmp.put(info.getId(), info);
        }
        this.sliceIDMap = tmp;
    }

    private void buildHitMap() {
        HashMap<TestCaseInfo, BitSet> hm = new HashMap<TestCaseInfo, BitSet>();
        for (int i = 0; i < this.data.length; ++i) {
            Set slicesForSlot = this.sliceHits[i];
            if (slicesForSlot == null) continue;
            Iterator iterator = slicesForSlot.iterator();
            while (iterator.hasNext()) {
                TestCaseInfo slice = (TestCaseInfo)iterator.next();
                BitSet sliceCov = (BitSet)hm.get(slice);
                if (sliceCov == null) {
                    sliceCov = new BitSet();
                    hm.put(slice, sliceCov);
                }
                sliceCov.set(i);
            }
        }
        this.hitMap = hm;
    }

    public void addTestCase(TestCaseInfo tci) {
        this.slices.add(tci);
    }

    public Set getTestCases() {
        return this.slices;
    }

    private static class BitSetCoverageProvider
    implements CoverageDataProvider {
        private BitSet data;

        public BitSetCoverageProvider(BitSet coverage) {
            this.data = (BitSet)coverage.clone();
        }

        public int getCoverage(int index) {
            return this.data.get(index) ? 1 : 0;
        }
    }
}

