/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import clover.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import com.cenqua.clover.CoverageData;
import com.cenqua.clover.CoverageRecording;
import com.cenqua.clover.registry.BaseFileInfo;
import com.cenqua.clover.registry.CoverageDataReceptor;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.FileInfoVisitor;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import java.util.Set;

public class CoverageSliceVisitor {
    final ProjectInfo model;
    final Set[] sliceHits;

    public CoverageSliceVisitor(ProjectInfo model, CoverageData data) {
        this.model = model;
        this.sliceHits = data.getSliceHits();
    }

    public void addSliceCoverageForSupportingFiles(final TestCaseInfo tci, final CoverageRecording start, final CoverageRecording end) {
        this.model.visitFiles(new FileInfoVisitor(){

            public void visitFileInfo(BaseFileInfo f) {
                FileInfo file = (FileInfo)f;
                if (file.supportsVersion(start.dbVersion)) {
                    CoverageSliceVisitor.this.addSliceCoverage(tci, start, end, file);
                }
            }
        });
    }

    private void addSliceCoverage(TestCaseInfo tci, CoverageRecording start, CoverageRecording end, CoverageDataReceptor receptor) {
        for (int i = receptor.getDataIndex(); i < receptor.getDataIndex() + receptor.getDataLength(); ++i) {
            int diff = end.elements[i] - start.elements[i];
            if (diff <= 0) continue;
            Set hits = this.sliceHits[i];
            if (hits == null) {
                hits = this.sliceHits[i] = new ObjectOpenHashSet();
            }
            hits.add(tci);
        }
    }
}

