/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover;

import com.cenqua.clover.JDKLogger;
import com.cenqua.clover.Log4JLogger;
import com.cenqua.clover.Logger;

public class RecorderLogging {
    static /* synthetic */ Class class$com$cenqua$clover$Logger$Factory;

    public static void init() {
        try {
            String adapter;
            String level = System.getProperty("clover.logging.level");
            if (level != null && "debug".equalsIgnoreCase(level)) {
                Logger.setDebug(true);
            }
            if ((adapter = System.getProperty("clover.logging.adapter")) != null && adapter.length() > 0) {
                if ("log4j".equalsIgnoreCase(adapter)) {
                    RecorderLogging.initLog4JLogging();
                } else if ("jdk".equalsIgnoreCase(adapter)) {
                    RecorderLogging.initJDKLogging();
                } else if (!"stderr".equals(adapter)) {
                    RecorderLogging.initCustomLogging(adapter);
                }
            }
        }
        catch (SecurityException e) {
            Logger.getInstance().debug("Security exception trying to initialise logger: " + e.getMessage());
        }
    }

    private static void initLog4JLogging() {
        if (Log4JLogger.init()) {
            Logger.setFactory(new Log4JLogger.Factory());
        } else {
            Logger.getInstance().error("Unable to initialise Log4J Logger. Using default logger.");
        }
    }

    private static void initJDKLogging() {
        try {
            Class.forName("java.util.logging.Logger");
            Logger.setFactory(new JDKLogger.Factory());
        }
        catch (ClassNotFoundException e) {
            Logger.getInstance().error("Unable to initialise JDK Logger. Using default logger.");
        }
    }

    private static void initCustomLogging(String classname) {
        String errorMsg = "Unable to initialise Logger class '" + classname + "'. ";
        boolean successful = false;
        try {
            Class<?> loggerFactoryClass = Class.forName(classname);
            if ((class$com$cenqua$clover$Logger$Factory == null ? (class$com$cenqua$clover$Logger$Factory = RecorderLogging.class$("com.cenqua.clover.Logger$Factory")) : class$com$cenqua$clover$Logger$Factory).isAssignableFrom(loggerFactoryClass)) {
                Logger.Factory factory = (Logger.Factory)loggerFactoryClass.newInstance();
                Logger.setFactory(factory);
                successful = true;
            } else {
                Logger.getInstance().error(errorMsg + " The class must be a subclass of " + (class$com$cenqua$clover$Logger$Factory == null ? (class$com$cenqua$clover$Logger$Factory = RecorderLogging.class$("com.cenqua.clover.Logger$Factory")) : class$com$cenqua$clover$Logger$Factory).getName() + ". Using default logger.");
            }
        }
        catch (ClassNotFoundException e) {
            errorMsg = errorMsg + "Class not found. ";
        }
        catch (ExceptionInInitializerError e) {
            errorMsg = errorMsg + "An error occured during class initialisation. ";
        }
        catch (IllegalAccessException e) {
            errorMsg = errorMsg + "An error occured during class initialisation. The class must provide a no-args public constructor. ";
        }
        catch (InstantiationException e) {
            errorMsg = errorMsg + "An error occured during class initialisation. The class must provide a no-args public constructor. ";
        }
        if (!successful) {
            errorMsg = errorMsg + " Using default logger";
            Logger.getInstance().error(errorMsg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

