/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.context.MethodRegexpContext;
import com.cenqua.clover.context.NamedContext;
import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationState;
import com.cenqua.clover.instr.MethodRegistrationNode;
import com.cenqua.clover.instr.MethodSignature;
import com.cenqua.clover.registry.MethodInfo;
import java.lang.reflect.Modifier;

public class MethodEntryInstrEmitter
extends Emitter {
    private MethodRegistrationNode methodNode;
    private boolean addTestInstr;
    private boolean needsFinally = false;

    public MethodEntryInstrEmitter(MethodRegistrationNode node) {
        this.methodNode = node;
    }

    protected boolean acceptsContextType(NamedContext context) {
        return context instanceof MethodRegexpContext;
    }

    public void init(InstrumentationState state) {
        this.addTestInstr = !state.getCfg().isTestRewriting() && state.isDetectTests() && state.getTestDetector().isMethodMatch(state, this.methodNode.getSignature());
        StringBuffer instr = new StringBuffer();
        if (state.isInstrEnabled()) {
            state.setDirty();
            if (this.addTestInstr) {
                instr.append("try{");
                instr.append(state.getRecorderPrefix());
                String typeInstr = "getClass()";
                if (Modifier.isStatic(this.getSignature().getModifiers())) {
                    typeInstr = this.getMethod().getContainingClass().getName() + ".class";
                }
                instr.append(".globalSliceStart(").append(typeInstr).append(",").append(this.methodNode.getMethod().getDataIndex()).append(");");
                this.needsFinally = true;
            } else if (state.getCfg().isIntervalBasedFlushing()) {
                instr.append("try{");
                this.needsFinally = true;
            }
            instr.append(state.getRecorderPrefix());
            instr.append(".E[");
            instr.append(this.methodNode.getMethod().getDataIndex());
            instr.append("]++;");
        }
        this.setInstr(instr.toString());
    }

    public boolean isAddTestInstr() {
        return this.addTestInstr;
    }

    public MethodSignature getSignature() {
        return this.methodNode.getSignature();
    }

    public MethodInfo getMethod() {
        return this.methodNode.getMethod();
    }

    public boolean needsFinally() {
        return this.needsFinally;
    }
}

