/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr;

import com.cenqua.clover.instr.Emitter;
import com.cenqua.clover.instr.InstrumentationState;
import com_cenqua_clover.CloverVersionInfo;
import com_cenqua_clover.CoverageRecorder;

public class RecorderInstrEmitter
extends Emitter {
    private static final String INCOMPATIBLE_MSG = "[CLOVER] WARNING: The Clover version used in instrumentation does not match the runtime version. You need to run instrumented classes against the same version of Clover that you instrumented with.";
    private static final String CLASSNOTFOUND_MSG = "[CLOVER] FATAL ERROR: Clover could not be initialised. Are you sure you have Clover in the runtime classpath?";
    private boolean isEnum;
    private boolean reportInitErrors;
    private boolean classInstrStrategy;
    private String recorderPrefix;
    private long recorderCfg;
    private String initString;
    private long registryVersion;
    private int maxDataIndex;
    private String javaLangPrefix;
    static /* synthetic */ Class class$com_cenqua_clover$CoverageRecorder;
    static /* synthetic */ Class class$com_cenqua_clover$CloverVersionInfo;
    static /* synthetic */ Class class$com_cenqua_clover$Clover;

    public RecorderInstrEmitter(boolean isEnum) {
        this.isEnum = isEnum;
    }

    public void init(InstrumentationState state) {
        this.recorderCfg = CoverageRecorder.getConfigBits(state.getCfg());
        this.recorderPrefix = state.getRecorderPrefix();
        this.classInstrStrategy = state.getCfg().isClassInstrStrategy();
        this.reportInitErrors = state.getCfg().isReportInitErrors();
        this.initString = state.getCfg().getInitString();
        this.registryVersion = state.getRegistry().getVersion();
        this.javaLangPrefix = state.getCfg().getJavaLangPrefix();
    }

    public String getInstr() {
        String instrString;
        if (this.classInstrStrategy || this.isEnum) {
            String recorderBase = this.recorderPrefix.substring(0, this.recorderPrefix.lastIndexOf(46));
            String recorderSuffix = this.recorderPrefix.substring(this.recorderPrefix.lastIndexOf(46) + 1);
            instrString = "public static class " + recorderBase + "{" + "public static " + (class$com_cenqua_clover$CoverageRecorder == null ? (class$com_cenqua_clover$CoverageRecorder = RecorderInstrEmitter.class$("com_cenqua_clover.CoverageRecorder")) : class$com_cenqua_clover$CoverageRecorder).getName() + " " + recorderSuffix + ";" + "static{";
            if (this.reportInitErrors) {
                instrString = instrString + "try{if(" + CloverVersionInfo.getBuildStamp() + "L!=" + (class$com_cenqua_clover$CloverVersionInfo == null ? (class$com_cenqua_clover$CloverVersionInfo = RecorderInstrEmitter.class$("com_cenqua_clover.CloverVersionInfo")) : class$com_cenqua_clover$CloverVersionInfo).getName() + ".getBuildStamp())" + "{" + (class$com_cenqua_clover$Clover == null ? (class$com_cenqua_clover$Clover = RecorderInstrEmitter.class$("com_cenqua_clover.Clover")) : class$com_cenqua_clover$Clover).getName() + ".l(\"" + INCOMPATIBLE_MSG + "\");" + (class$com_cenqua_clover$Clover == null ? (class$com_cenqua_clover$Clover = RecorderInstrEmitter.class$("com_cenqua_clover.Clover")) : class$com_cenqua_clover$Clover).getName() + ".l(\"[CLOVER] WARNING: Instr=" + CloverVersionInfo.getReleaseNum() + "#" + CloverVersionInfo.getBuildStamp() + ",Runtime=\"+" + (class$com_cenqua_clover$CloverVersionInfo == null ? (class$com_cenqua_clover$CloverVersionInfo = RecorderInstrEmitter.class$("com_cenqua_clover.CloverVersionInfo")) : class$com_cenqua_clover$CloverVersionInfo).getName() + ".getReleaseNum() + \"#\"+" + (class$com_cenqua_clover$CloverVersionInfo == null ? (class$com_cenqua_clover$CloverVersionInfo = RecorderInstrEmitter.class$("com_cenqua_clover.CloverVersionInfo")) : class$com_cenqua_clover$CloverVersionInfo).getName() + ".getBuildStamp());}";
            }
            instrString = instrString + recorderSuffix + "=" + (class$com_cenqua_clover$Clover == null ? (class$com_cenqua_clover$Clover = RecorderInstrEmitter.class$("com_cenqua_clover.Clover")) : class$com_cenqua_clover$Clover).getName() + ".getRecorder(" + RecorderInstrEmitter.asCharArrayStr(this.initString) + "," + this.registryVersion + "L," + this.recorderCfg + "L," + this.maxDataIndex + ");";
            if (this.reportInitErrors) {
                instrString = instrString + "}catch(" + this.javaLangPrefix + "Throwable t){" + this.javaLangPrefix + "System.err.println(\"" + CLASSNOTFOUND_MSG + " (\"+t.getClass()+\":\"+t.getMessage()+\")\");}";
            }
            instrString = instrString + "}}";
        } else {
            instrString = "public static " + (class$com_cenqua_clover$CoverageRecorder == null ? (class$com_cenqua_clover$CoverageRecorder = RecorderInstrEmitter.class$("com_cenqua_clover.CoverageRecorder")) : class$com_cenqua_clover$CoverageRecorder).getName() + " " + this.recorderPrefix + "=" + (class$com_cenqua_clover$Clover == null ? (class$com_cenqua_clover$Clover = RecorderInstrEmitter.class$("com_cenqua_clover.Clover")) : class$com_cenqua_clover$Clover).getName() + ".getRecorder(" + RecorderInstrEmitter.asCharArrayStr(this.initString) + "," + this.registryVersion + "L," + this.recorderCfg + "L);";
        }
        return instrString;
    }

    public static String asCharArrayStr(String str) {
        String res = "new char[]{";
        for (int i = 0; i < str.length(); ++i) {
            res = res + str.charAt(i);
            if (i + 1 >= str.length()) continue;
            res = res + ",";
        }
        res = res + "}";
        return res;
    }

    public void setMaxDataIndex(int maxIndex) {
        this.maxDataIndex = maxIndex;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

