/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.instr.bytecode;

import clover.org.objectweb.asm.ClassAdapter;
import clover.org.objectweb.asm.ClassWriter;
import com.cenqua.clover.instr.bytecode.AlreadyInstrumentedException;
import com.cenqua.clover.instr.bytecode.ClassTransformer;
import java.util.Arrays;
import java.util.HashSet;

class InstrumentingClassVisitor
extends ClassAdapter {
    public InstrumentingClassVisitor(ClassWriter cw) {
        super(cw);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (Arrays.asList(interfaces).contains(ClassTransformer.INSTRUMENTED_TYPE_NAME)) {
            throw new AlreadyInstrumentedException(name);
        }
        this.cv.visit(version, access, name, signature, superName, this.addCloveredTo(interfaces));
    }

    private String[] addCloveredTo(String[] interfaces) {
        HashSet<String> ifcs = new HashSet<String>(Arrays.asList(interfaces));
        ifcs.add(ClassTransformer.INSTRUMENTED_TYPE_NAME);
        return ifcs.toArray(new String[ifcs.size()]);
    }
}

