/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters;

import com.cenqua.clover.CloverException;
import com.cenqua.clover.Logger;
import com.cenqua.clover.cfg.Interval;
import com.cenqua.clover.cfg.Percentage;
import com.cenqua.clover.reporters.CloverReportConfig;
import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.Format;
import com.cenqua.clover.reporters.html.FullHtmlReporter;
import com.cenqua.clover.reporters.html.HtmlReporter;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class Historical
extends CloverReportConfig {
    private static final String ERR_TIME_INTERVAL_ENDS_BEFORE_START = "Invalid time interval: 'from' time greater than 'to' time.";
    private static final String ERR_RANGE_MUST_BE_POSITIVE_INTEGER = "Range must be a positive integer";
    private static final String ERR_HISTORY_DATA_DIR_NOT_SPECIFIED = "History data dir not specified.";
    private static final Columns DEFAULT_METRICS_COLUMNS = new Columns();
    private static final Columns DEFAULT_COVERAGE_COLUMNS = new Columns();
    private File historyDir;
    protected File[] historyFiles;
    private String from;
    private String to;
    private String dateFormat;
    private String packageName;
    private Date fromTS;
    private Date toTS;
    private List charts = new ArrayList();
    private List allMovers = new ArrayList();
    private Overview overview;
    public static final Date DEFAULT_FROM_TS;
    public static final Date DEFAULT_TO_TS;

    public HtmlReporter newReporter() throws IOException, CloverException {
        return new FullHtmlReporter(this);
    }

    public void setHistoryDir(File historyDir) {
        this.historyDir = historyDir;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setPackage(String packageName) {
        this.packageName = packageName;
    }

    public void addCoverage(Coverage coverage) {
        this.charts.add(coverage);
    }

    public void addMetrics(Metrics metrics) {
        this.charts.add(metrics);
    }

    public void addChart(Chart chart) {
        this.charts.add(chart);
    }

    public void addMovers(Movers movers) {
        this.allMovers.add(movers);
    }

    public void addOverview(Overview overview) {
        this.overview = overview;
    }

    public Overview getOverview() {
        return this.overview;
    }

    public List getCharts() {
        return this.charts;
    }

    public List getMovers() {
        return this.allMovers;
    }

    public File getHistoryDir() {
        return this.historyDir;
    }

    public File[] getHistoryFiles() {
        return this.historyFiles;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getPackage() {
        return this.packageName;
    }

    public Date getFromTS() {
        return this.fromTS;
    }

    public Date getToTS() {
        return this.toTS;
    }

    public boolean validate() {
        if (!super.validate()) {
            return false;
        }
        if (this.getFormat() == null) {
            this.setFormat(Format.DEFAULT_HTML);
        }
        if (this.getHistoryDir() == null) {
            this.setFailureReason(ERR_HISTORY_DATA_DIR_NOT_SPECIFIED);
            return false;
        }
        return this.processAndValidate();
    }

    public boolean processAndValidate() {
        this.processDateRange();
        if (this.getFromTS().after(this.getToTS())) {
            this.setFailureReason(ERR_TIME_INTERVAL_ENDS_BEFORE_START);
            return false;
        }
        if (this.overview == null && this.charts.size() == 0 && this.allMovers.size() == 0) {
            this.addOverview(new Overview());
            this.addMetrics(new Metrics());
            this.addCoverage(new Coverage());
            this.addMovers(Movers.DEFAULT_MOVERS);
        }
        Iterator iter = this.allMovers.iterator();
        while (iter.hasNext()) {
            Movers movers = (Movers)iter.next();
            if (movers == null || movers.getRange() > 0) continue;
            this.setFailureReason(ERR_RANGE_MUST_BE_POSITIVE_INTEGER);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDateRange() {
        SimpleDateFormat df;
        SimpleDateFormat def = new SimpleDateFormat();
        if (this.dateFormat == null) {
            df = def;
        } else {
            try {
                df = new SimpleDateFormat(this.dateFormat);
            }
            catch (IllegalStateException e) {
                df = def;
            }
        }
        if (this.from != null) {
            try {
                this.fromTS = df.parse(this.from);
            }
            catch (Exception e) {
            }
            finally {
                if (this.fromTS == null) {
                    this.fromTS = DEFAULT_FROM_TS;
                }
            }
        } else {
            this.fromTS = DEFAULT_FROM_TS;
        }
        if (this.to != null) {
            try {
                this.toTS = df.parse(this.to);
            }
            catch (Exception exception) {
            }
            finally {
                if (this.toTS == null) {
                    this.toTS = DEFAULT_TO_TS;
                }
            }
        } else {
            this.toTS = DEFAULT_TO_TS;
        }
    }

    static {
        DEFAULT_METRICS_COLUMNS.addConfiguredTotalPackages(new Columns.TotalPackages());
        DEFAULT_METRICS_COLUMNS.addConfiguredTotalFiles(new Columns.TotalFiles());
        DEFAULT_METRICS_COLUMNS.addConfiguredNcLineCount(new Columns.NcLineCount());
        DEFAULT_METRICS_COLUMNS.addConfiguredLineCount(new Columns.LineCount());
        DEFAULT_METRICS_COLUMNS.addConfiguredComplexity(new Columns.Complexity());
        DEFAULT_COVERAGE_COLUMNS.addConfiguredCoveredElements(new Columns.CoveredElements());
        DEFAULT_COVERAGE_COLUMNS.addConfiguredCoveredMethods(new Columns.CoveredMethods());
        DEFAULT_COVERAGE_COLUMNS.addConfiguredCoveredStatements(new Columns.CoveredStatements());
        DEFAULT_COVERAGE_COLUMNS.addConfiguredCoveredBranches(new Columns.CoveredBranches());
        DEFAULT_FROM_TS = new Date(0L);
        DEFAULT_TO_TS = new Date(Long.MAX_VALUE);
    }

    public static class Movers {
        private static Percentage DEFAULT_THRESHOLD = new Percentage("1%");
        private static int DEFAULT_RANGE = 5;
        public static final Movers DEFAULT_MOVERS = new Movers(null, DEFAULT_THRESHOLD, DEFAULT_RANGE);
        private Interval interval;
        private Percentage threshold = DEFAULT_THRESHOLD;
        private int range = DEFAULT_RANGE;

        public Movers() {
        }

        public Movers(Interval interval, Percentage threshold, int range) {
            this.interval = interval;
            this.threshold = threshold;
            this.range = range;
        }

        public void setInterval(Interval interval) {
            this.interval = interval;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public void setThreshold(Percentage threshold) {
            this.threshold = threshold;
        }

        public Percentage getThreshold() {
            return this.threshold;
        }

        public void setRange(int range) {
            this.range = range;
        }

        public int getRange() {
            return this.range;
        }
    }

    public static class Metrics
    extends Chart {
        public Metrics() {
            this.columns = DEFAULT_METRICS_COLUMNS;
            this.yLabel = "";
            this.title = "Metrics";
        }
    }

    public static class Coverage
    extends Chart {
        public Coverage() {
            this.columns = DEFAULT_COVERAGE_COLUMNS;
            this.yLabel = "Coverage (%)";
            this.title = "Coverage";
            this.logScale = false;
            this.upperBound = 100;
        }
    }

    public static class Chart {
        protected boolean logScale = true;
        protected Columns columns = Historical.access$000();
        private int height = 480;
        private int width = 640;
        private String xLabel;
        protected String yLabel;
        protected String title;
        protected int upperBound = -1;

        public void setInclude(String include) {
            Logger.getInstance().warn("WARN: The include attribute is deprecated. Use the nested <columns/> element instead.");
        }

        public void addColumns(Columns cols) {
            this.columns = cols;
        }

        public Columns getColumns() {
            return this.columns;
        }

        public void setLogScale(boolean logScale) {
            this.logScale = logScale;
        }

        public boolean isLogScale() {
            return this.logScale;
        }

        public String getTitle() {
            return this.title;
        }

        public String getYLabel() {
            return this.yLabel;
        }

        public String getXLabel() {
            return this.xLabel;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setXLabel(String xLabel) {
            this.xLabel = xLabel;
        }

        public void setYLabel(String yLabel) {
            this.yLabel = yLabel;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public int getUpperBound() {
            return this.upperBound;
        }

        public void setUpperBound(int upperBound) {
            this.upperBound = upperBound;
        }
    }

    public static class Overview {
    }
}

