/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.edu.emory.mathcs.backport.java.util.concurrent.Callable;
import clover.org.apache.velocity.VelocityContext;
import com.cenqua.clover.registry.HasMetricsSupport;
import com.cenqua.clover.registry.ProjectInfo;
import com.cenqua.clover.reporters.Columns;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.MetricsCollator;
import com.cenqua.clover.reporters.html.AbstractClassInfoClosure;
import com.cenqua.clover.reporters.html.ClosureValueComparator;
import com.cenqua.clover.reporters.html.HtmlReportUtil;
import com.cenqua.clover.reporters.html.StatisticsClassInfoVisitor;
import com.cenqua.clover.reporters.html.TestClassCoverageThresholdFilter;
import com.cenqua.clover.reporters.html.TestClassFilter;
import com.cenqua.clover.reporters.util.CloverChartFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class RenderDashboardAction
implements Callable {
    private static final int DBRD_PROJECT_RISKS_COUNT = 20;
    private static final int DBRD_TOP_N_COUNT = 5;
    private final File mBasePath;
    private final Current mCurrent;
    private final ProjectInfo mConfiguredInfo;
    private final ProjectInfo mProjectInfo;
    private final VelocityContext mContext;
    private final CloverChartFactory.ChartInfo mHistogram;
    private final CloverChartFactory.ChartInfo mScatter;

    public RenderDashboardAction(VelocityContext ctx, File basePath, Current current, ProjectInfo configured, ProjectInfo full, CloverChartFactory.ChartInfo histogram, CloverChartFactory.ChartInfo scatter) {
        this.mBasePath = basePath;
        this.mCurrent = current;
        this.mConfiguredInfo = configured;
        this.mProjectInfo = full;
        this.mContext = ctx;
        this.mHistogram = histogram;
        this.mScatter = scatter;
    }

    public Object call() throws Exception {
        File outfile = this.insertDashboardProperties();
        HtmlReportUtil.mergeTemplateToFile(outfile, this.mContext, "html_res/dashboard.vm");
        return null;
    }

    File insertDashboardProperties() {
        List classes = this.mConfiguredInfo.getClasses(new TestClassCoverageThresholdFilter());
        AbstractClassInfoClosure.AvgMethodComplexityClosure avgMethodCmpClosure = new AbstractClassInfoClosure.AvgMethodComplexityClosure();
        AbstractClassInfoClosure.PcCoveredElementsClosure pcCoveredEleClosure = new AbstractClassInfoClosure.PcCoveredElementsClosure();
        AbstractClassInfoClosure.ElementCountClosure eleCountClosure = new AbstractClassInfoClosure.ElementCountClosure();
        ArrayList amcOrder = new ArrayList(classes);
        Collections.sort(amcOrder, new ClosureValueComparator(new AbstractClassInfoClosure[]{avgMethodCmpClosure, pcCoveredEleClosure, eleCountClosure}));
        ArrayList pceOrder = new ArrayList(classes);
        Collections.sort(pceOrder, new ClosureValueComparator(new AbstractClassInfoClosure[]{pcCoveredEleClosure, avgMethodCmpClosure, eleCountClosure}));
        StatisticsClassInfoVisitor amcVisitor = StatisticsClassInfoVisitor.visit(amcOrder, avgMethodCmpClosure);
        StatisticsClassInfoVisitor pceVisitor = StatisticsClassInfoVisitor.visit(pceOrder, pcCoveredEleClosure);
        MetricsCollator collator = new MetricsCollator();
        Map classMap = collator.rankProjectRisks(pceOrder, amcOrder);
        List topRisks = collator.getTopRisks(classMap, 20);
        Columns.TotalPercentageCovered tpc = new Columns.TotalPercentageCovered();
        tpc.setFormat("longbar");
        this.mContext.put("tpcColumn", tpc);
        this.mContext.put("hasResults", this.mProjectInfo.hasTestResults());
        this.mContext.put("projectInfo", this.mProjectInfo);
        this.mContext.put("headerMetrics", this.mConfiguredInfo.getMetrics());
        this.mContext.put("headerMetricsRaw", this.mConfiguredInfo.getRawMetrics());
        List packages = this.mConfiguredInfo.getPackages();
        List complexPkgs = collator.getTopOfList(packages, 5, HasMetricsSupport.CMP_COMPLEXITY);
        this.mContext.put("complexPkgs", complexPkgs);
        List allClasses = this.mConfiguredInfo.getClasses(new TestClassFilter());
        List complexClasses = collator.getTopOfList(allClasses, 5, HasMetricsSupport.CMP_COMPLEXITY);
        this.mContext.put("complexClasses", complexClasses);
        this.mContext.put("leastTestedMethods", collator.getLeastTestedMethods(classes));
        String filename = "dashboard.html";
        File outfile = new File(this.mBasePath, filename);
        this.mContext.put("currentPageURL", filename);
        this.mContext.put("topRisks", topRisks);
        this.mContext.put("axisColor", pceVisitor);
        this.mContext.put("axisSize", amcVisitor);
        this.mContext.put("chartInfoHistogram", this.mHistogram);
        this.mContext.put("chartInfoScatter", this.mScatter);
        return outfile;
    }
}

