/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.clover.reporters.html;

import clover.org.apache.velocity.VelocityContext;
import cloverantlr.TokenStreamException;
import com.cenqua.clover.CloverDatabase;
import com.cenqua.clover.Logger;
import com.cenqua.clover.context.ContextSet;
import com.cenqua.clover.registry.BranchInfo;
import com.cenqua.clover.registry.FileInfo;
import com.cenqua.clover.registry.LineInfo;
import com.cenqua.clover.registry.MethodInfo;
import com.cenqua.clover.registry.SourceRegion;
import com.cenqua.clover.registry.StatementInfo;
import com.cenqua.clover.registry.TestCaseInfo;
import com.cenqua.clover.reporters.Current;
import com.cenqua.clover.reporters.html.HtmlRenderingSupport;
import com.cenqua.clover.reporters.html.HtmlSourceRenderer;
import com.cenqua.clover.util.ChecksummingReader;
import com.cenqua.clover.util.Formatting;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SourceRenderHelper {
    boolean mOutOfDate;
    private CloverDatabase mDb;
    private Current mCurrent;
    private HtmlRenderingSupport mHelper;

    public SourceRenderHelper(CloverDatabase db, Current current, HtmlRenderingSupport helper) {
        this.mDb = db;
        this.mCurrent = current;
        this.mHelper = helper;
    }

    public void insertLineInfosForFile(FileInfo fileInfo, VelocityContext context, ContextSet contextSet, String emptyChar) throws TokenStreamException {
        try {
            context.put("renderInfo", this.gatherSrcRenderInfo(context, fileInfo, contextSet, emptyChar));
            context.put("outofdate", this.mOutOfDate);
            if (this.mOutOfDate) {
                Logger.getInstance().warn("Source file " + fileInfo.getPhyscialFile() + " has changed since coverage information was" + " generated");
            }
        }
        catch (FileNotFoundException e) {
            Logger.getInstance().error(e.getMessage());
            context.put("errormsg", "Could not read source file: " + fileInfo.getPhyscialFile().getAbsolutePath());
        }
        catch (IOException ioe) {
            context.put("errormsg", "problem rendering source");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HtmlSourceRenderer.LineRenderInfo[] gatherSrcRenderInfo(VelocityContext vc, FileInfo finfo, ContextSet contextSet, String emptyChar) throws IOException, TokenStreamException {
        finfo.setDataProvider(this.mDb.getCoverageData());
        int l = finfo.getLineCount();
        ArrayList<HtmlSourceRenderer.LineRenderInfo> renderedLines = new ArrayList<HtmlSourceRenderer.LineRenderInfo>(l);
        ChecksummingReader csr = SourceRenderHelper.getChecksummingReader(finfo);
        String spaceChar = this.mCurrent.getFormat().getSpaceChar();
        if (spaceChar == null || spaceChar.length() == 0) {
            spaceChar = " ";
        }
        String tabStr = "";
        for (int j = 0; j < this.mCurrent.getFormat().getTabWidth(); ++j) {
            tabStr = tabStr + spaceChar;
        }
        HtmlSourceRenderer renderer = new HtmlSourceRenderer(finfo, renderedLines, this.mHelper, tabStr, spaceChar);
        try {
            renderer.process(csr);
        }
        finally {
            csr.close();
        }
        List[] testLineInfo = (List[])vc.remove("testLineInfo");
        LineInfo[] lines = finfo.getLineInfo();
        for (int i = 0; i < l; ++i) {
            List testsForLine;
            boolean hilightInfo = false;
            boolean hilightBad = false;
            ContextSet filteredCtx = null;
            String msg = "";
            int coverage = -1;
            String ccstr = emptyChar;
            LineInfo linfo = lines[i + 1];
            if (linfo != null) {
                int j;
                for (j = 0; !hilightBad && linfo.getMethodStarts() != null && j < linfo.getMethodStarts().length; ++j) {
                    MethodInfo methodInfo = linfo.getMethodStarts()[j];
                    coverage = methodInfo.getHitCount();
                    msg = this.getRegionStartStr(linfo.getMethodStarts()[j]) + "method" + (coverage == 0 ? " not entered." : " entered " + Formatting.pluralizedVal(coverage, "time") + ".");
                    if (filteredCtx != null || methodInfo.isFiltered(contextSet)) {
                        filteredCtx = methodInfo.getContext();
                    }
                    if (coverage != 0) continue;
                    hilightBad = true;
                    break;
                }
                for (j = 0; !hilightBad && linfo.getStatements() != null && j < linfo.getStatements().length; ++j) {
                    StatementInfo statementInfo = linfo.getStatements()[j];
                    coverage = statementInfo.getHitCount();
                    msg = this.getRegionStartStr(statementInfo) + "statement" + (coverage == 0 ? " not executed." : " executed " + Formatting.pluralizedVal(coverage, "time") + ".");
                    if (filteredCtx != null || statementInfo.isFiltered(contextSet)) {
                        filteredCtx = statementInfo.getContext();
                    }
                    if (coverage != 0) continue;
                    hilightBad = true;
                }
                for (j = 0; !hilightBad && linfo.getBranches() != null && j < linfo.getBranches().length; ++j) {
                    BranchInfo branchInfo = linfo.getBranches()[j];
                    int tc = branchInfo.getTrueHitCount();
                    int fc = branchInfo.getFalseHitCount();
                    coverage = tc + fc;
                    if (filteredCtx != null || branchInfo.isFiltered(contextSet)) {
                        filteredCtx = branchInfo.getContext();
                    }
                    if (!branchInfo.isInstrumented()) {
                        msg = this.getRegionStartStr(branchInfo) + "coverage not measured due to assignment in expression.";
                        if (filteredCtx == null) {
                            ccstr = "?";
                        }
                    } else {
                        msg = this.getRegionStartStr(branchInfo) + "true branch executed " + Formatting.pluralizedVal(tc, "time") + ", false branch executed " + Formatting.pluralizedVal(fc, "time") + ".";
                    }
                    if (tc != 0 && fc != 0) continue;
                    hilightBad = true;
                    break;
                }
                if (coverage >= 0) {
                    hilightInfo = true;
                    if (ccstr.equals(emptyChar) && filteredCtx == null) {
                        ccstr = "" + coverage;
                    }
                }
            }
            if (renderedLines.size() <= i || renderedLines.get(i) == null) {
                renderedLines.add(new HtmlSourceRenderer.LineRenderInfo());
            }
            HtmlSourceRenderer.LineRenderInfo thisLine = (HtmlSourceRenderer.LineRenderInfo)renderedLines.get(i);
            if (linfo != null && linfo.getClassStarts() != null) {
                thisLine.classStart = linfo.getClassStarts()[0];
            }
            if (linfo != null && linfo.getMethodStarts() != null) {
                thisLine.methodStart = linfo.getMethodStarts()[0];
            }
            if (linfo != null && linfo.getFailStackEntries() != null) {
                thisLine.failedStackEntries = linfo.getFailStackEntries();
            }
            boolean classStart = thisLine.classStart != null;
            String hitClass = "missedByTest";
            List list = testsForLine = testLineInfo == null ? null : testLineInfo[i + 1];
            if (testsForLine != null) {
                Iterator tests = testsForLine.iterator();
                while (tests.hasNext()) {
                    TestCaseInfo tci = (TestCaseInfo)tests.next();
                    if (!tci.isSuccess()) {
                        hitClass = "hitByFailedTest";
                        continue;
                    }
                    hitClass = "hitByTest";
                    break;
                }
            }
            if (filteredCtx != null) {
                thisLine.lineNumberCSS = "lineCount Filtered";
                thisLine.coverageCountCSS = "coverageCount Filtered";
                thisLine.testHitCSS = "missedByTest";
                thisLine.sourceCSS = "srcLineFiltered";
                thisLine.filtered = true;
                filteredCtx.and(contextSet);
                String contextString = this.mDb.getContextRegistry().getContextsAsString(filteredCtx);
                msg = "Filtered by: " + this.mHelper.htmlEscapeStr(contextString);
            } else if (hilightBad) {
                thisLine.lineNumberCSS = "lineCount Bad";
                thisLine.coverageCountCSS = "coverageCount Bad";
                thisLine.sourceCSS = "srcLineHilight";
                thisLine.testHitCSS = hitClass;
            } else if (hilightInfo) {
                thisLine.lineNumberCSS = "lineCount Good";
                thisLine.coverageCountCSS = "coverageCount Good";
                thisLine.sourceCSS = classStart ? "srcLineClassStart" : "srcLine";
                thisLine.testHitCSS = hitClass;
            } else {
                thisLine.lineNumberCSS = "lineCount NoHilight";
                thisLine.coverageCountCSS = "coverageCount NoHilight";
                String string = thisLine.sourceCSS = classStart ? "srcLineClassStart" : "srcLine";
            }
            if (this.mOutOfDate) {
                thisLine.lineNumberCSS = "lineWarning";
            }
            thisLine.hilight = hilightInfo && filteredCtx == null;
            thisLine.coverageStr = ccstr;
            thisLine.msg = msg;
            thisLine.testHits = testsForLine != null ? testsForLine : Collections.EMPTY_LIST;
        }
        HtmlSourceRenderer.LineRenderInfo[] infos = new HtmlSourceRenderer.LineRenderInfo[renderedLines.size()];
        this.mOutOfDate = csr.getChecksum() != finfo.getChecksum();
        return renderedLines.toArray(infos);
    }

    static List getUnrenderedSrcLines(FileInfo finfo) throws IOException {
        String line;
        LineNumberReader reader = new LineNumberReader(SourceRenderHelper.getChecksummingReader(finfo));
        ArrayList<String> srclines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            srclines.add(line);
        }
        return srclines;
    }

    private static ChecksummingReader getChecksummingReader(FileInfo finfo) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader fileReader;
        if (finfo.getEncoding() == null) {
            fileReader = new FileReader(finfo.getPhyscialFile());
        } else {
            FileInputStream fis = new FileInputStream(finfo.getPhyscialFile());
            fileReader = new InputStreamReader((InputStream)fis, finfo.getEncoding());
        }
        return new ChecksummingReader(new BufferedReader(fileReader));
    }

    private String getRegionStartStr(SourceRegion reg) {
        return "Line " + reg.getStartLine() + ", Col " + reg.getStartColumn() + ": ";
    }
}

